/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.junit.Assert;
import org.junit.Test;

public class WindowStoreUtilsTest {
    protected StateSerdes<String, String> serdes = new StateSerdes<String, String>("dummy", new Serdes.StringSerde(), new Serdes.StringSerde());

    @Test
    public void testSerialization() {
        String key = "key1";
        long timestamp = 99L;
        int seqNum = 3;
        Bytes bytes = WindowStoreUtils.toBinaryKey("key1", 99L, 3, this.serdes);
        String parsedKey = WindowStoreUtils.keyFromBinaryKey(bytes.get(), this.serdes);
        long parsedTs = WindowStoreUtils.timestampFromBinaryKey(bytes.get());
        int parsedSeqNum = WindowStoreUtils.sequenceNumberFromBinaryKey(bytes.get());
        Assert.assertEquals((Object)"key1", (Object)parsedKey);
        Assert.assertEquals((long)99L, (long)parsedTs);
        Assert.assertEquals((long)3L, (long)parsedSeqNum);
    }
}

