/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.test.TestUtils;

public class BrokerCompatibilityTest {
    private static final String SOURCE_TOPIC = "brokerCompatibilitySourceTopic";
    private static final String SINK_TOPIC = "brokerCompatibilitySinkTopic";

    public static void main(String[] args) {
        System.out.println("StreamsTest instance started");
        String kafka = args.length > 0 ? args[0] : "localhost:9092";
        String stateDirStr = args.length > 1 ? args[1] : TestUtils.tempDirectory().getAbsolutePath();
        boolean eosEnabled = args.length > 2 ? Boolean.parseBoolean(args[2]) : false;
        File stateDir = new File(stateDirStr);
        stateDir.mkdir();
        Properties streamsProperties = new Properties();
        streamsProperties.put("bootstrap.servers", kafka);
        streamsProperties.put("application.id", "kafka-streams-system-test-broker-compatibility");
        streamsProperties.put("state.dir", stateDir.toString());
        streamsProperties.put("auto.offset.reset", "earliest");
        streamsProperties.put("default.key.serde", Serdes.String().getClass());
        streamsProperties.put("default.value.serde", Serdes.String().getClass());
        streamsProperties.put("commit.interval.ms", (Object)100);
        streamsProperties.put("cache.max.bytes.buffering", (Object)0);
        if (eosEnabled) {
            streamsProperties.put("processing.guarantee", "exactly_once");
        }
        int timeout = 6000;
        streamsProperties.put(StreamsConfig.consumerPrefix("session.timeout.ms"), (Object)6000);
        streamsProperties.put(StreamsConfig.consumerPrefix("fetch.max.wait.ms"), (Object)6000);
        streamsProperties.put("request.timeout.ms", (Object)6001);
        streamsProperties.put(StreamsConfig.producerPrefix("request.timeout.ms"), (Object)60000);
        Serde<String> stringSerde = Serdes.String();
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(SOURCE_TOPIC).groupByKey(Serialized.with(stringSerde, stringSerde)).count().toStream().mapValues(new ValueMapper<Long, String>(){

            @Override
            public String apply(Long value) {
                return value.toString();
            }
        }).to(SINK_TOPIC);
        final KafkaStreams streams = new KafkaStreams(builder.build(), streamsProperties);
        streams.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Throwable cause = e;
                if (cause instanceof StreamsException) {
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                }
                System.err.println("FATAL: An unexpected exception " + cause);
                e.printStackTrace(System.err);
                System.err.flush();
                streams.close(30L, TimeUnit.SECONDS);
            }
        });
        System.out.println("start Kafka Streams");
        streams.start();
        System.out.println("send data");
        Properties producerProperties = new Properties();
        producerProperties.put("bootstrap.servers", kafka);
        producerProperties.put("key.serializer", StringSerializer.class);
        producerProperties.put("value.serializer", StringSerializer.class);
        try (KafkaProducer<String, String> producer = new KafkaProducer<String, String>(producerProperties);){
            producer.send(new ProducerRecord<String, String>(SOURCE_TOPIC, "key", "value"));
            System.out.println("wait for result");
            BrokerCompatibilityTest.loopUntilRecordReceived(kafka, eosEnabled);
            System.out.println("close Kafka Streams");
            streams.close();
        }
        catch (RuntimeException e) {
            System.err.println("Non-Streams exception occurred: ");
            e.printStackTrace(System.err);
            System.err.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loopUntilRecordReceived(String kafka, boolean eosEnabled) {
        Properties consumerProperties = new Properties();
        consumerProperties.put("bootstrap.servers", kafka);
        consumerProperties.put("group.id", "broker-compatibility-consumer");
        consumerProperties.put("auto.offset.reset", "earliest");
        consumerProperties.put("key.deserializer", StringDeserializer.class);
        consumerProperties.put("value.deserializer", StringDeserializer.class);
        if (eosEnabled) {
            consumerProperties.put("isolation.level", IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT));
        }
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProperties);){
            consumer.subscribe(Collections.singletonList(SINK_TOPIC));
            block10: while (true) {
                ConsumerRecords records = consumer.poll(100L);
                Iterator i$ = records.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block10;
                    ConsumerRecord record = i$.next();
                    if (((String)record.key()).equals("key") && ((String)record.value()).equals("1")) {
                        return;
                    }
                    continue;
                    break;
                }
                break;
            }
        }
    }
}

