/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;

public class MockInternalTopicManager
extends InternalTopicManager {
    public final Map<String, Integer> readyTopics = new HashMap<String, Integer>();
    private final MockConsumer<byte[], byte[]> restoreConsumer;

    public MockInternalTopicManager(StreamsConfig streamsConfig, MockConsumer<byte[], byte[]> restoreConsumer) {
        super(KafkaAdminClient.create(streamsConfig.originals()), streamsConfig);
        this.restoreConsumer = restoreConsumer;
    }

    @Override
    public void makeReady(Map<String, InternalTopicConfig> topics) {
        for (InternalTopicConfig topic : topics.values()) {
            String topicName = topic.name();
            int numberOfPartitions = topic.numberOfPartitions();
            this.readyTopics.put(topicName, numberOfPartitions);
            ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
            for (int i = 0; i < numberOfPartitions; ++i) {
                partitions.add(new PartitionInfo(topicName, i, null, null, null));
            }
            this.restoreConsumer.updatePartitions(topicName, partitions);
        }
    }

    @Override
    protected Map<String, Integer> getNumPartitions(Set<String> topics) {
        HashMap<String, Integer> partitions = new HashMap<String, Integer>();
        for (String topic : topics) {
            partitions.put(topic, this.restoreConsumer.partitionsFor(topic) == null ? null : Integer.valueOf(this.restoreConsumer.partitionsFor(topic).size()));
        }
        return partitions;
    }
}

