/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueMapper;

public class MockMapper {
    public static <K, V> KeyValueMapper<K, V, K> selectKeyKeyValueMapper() {
        return new SelectKeyMapper();
    }

    public static <K, V> KeyValueMapper<K, V, Iterable<KeyValue<K, V>>> noOpFlatKeyValueMapper() {
        return new NoOpFlatKeyValueMapper();
    }

    public static <K, V> KeyValueMapper<K, V, KeyValue<K, V>> noOpKeyValueMapper() {
        return new NoOpKeyValueMapper();
    }

    public static <K, V> KeyValueMapper<K, V, KeyValue<V, V>> selectValueKeyValueMapper() {
        return new SelectValueKeyValueMapper();
    }

    public static <K, V> KeyValueMapper<K, V, V> selectValueMapper() {
        return new SelectValueMapper();
    }

    public static <V> ValueMapper<V, V> noOpValueMapper() {
        return new NoOpValueMapper();
    }

    private static class NoOpValueMapper<V>
    implements ValueMapper<V, V> {
        private NoOpValueMapper() {
        }

        @Override
        public V apply(V value) {
            return value;
        }
    }

    private static class SelectKeyMapper<K, V>
    implements KeyValueMapper<K, V, K> {
        private SelectKeyMapper() {
        }

        @Override
        public K apply(K key, V value) {
            return key;
        }
    }

    private static class SelectValueMapper<K, V>
    implements KeyValueMapper<K, V, V> {
        private SelectValueMapper() {
        }

        @Override
        public V apply(K key, V value) {
            return value;
        }
    }

    private static class SelectValueKeyValueMapper<K, V>
    implements KeyValueMapper<K, V, KeyValue<V, V>> {
        private SelectValueKeyValueMapper() {
        }

        @Override
        public KeyValue<V, V> apply(K key, V value) {
            return KeyValue.pair(value, value);
        }
    }

    private static class NoOpFlatKeyValueMapper<K, V>
    implements KeyValueMapper<K, V, Iterable<KeyValue<K, V>>> {
        private NoOpFlatKeyValueMapper() {
        }

        @Override
        public Iterable<KeyValue<K, V>> apply(K key, V value) {
            return Collections.singletonList(KeyValue.pair(key, value));
        }
    }

    private static class NoOpKeyValueMapper<K, V>
    implements KeyValueMapper<K, V, KeyValue<K, V>> {
        private NoOpKeyValueMapper() {
        }

        @Override
        public KeyValue<K, V> apply(K key, V value) {
            return KeyValue.pair(key, value);
        }
    }
}

