/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.test.MockProcessorSupplier;

public class MockProcessorNode<K, V>
extends ProcessorNode<K, V> {
    private static final String NAME = "MOCK-PROCESS-";
    private static final AtomicInteger INDEX = new AtomicInteger(1);
    public final MockProcessorSupplier<K, V> supplier;
    public boolean closed;
    public long punctuatedAt;
    public boolean initialized;

    public MockProcessorNode(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockProcessorNode(long scheduleInterval, PunctuationType punctuationType) {
        this(new MockProcessorSupplier(scheduleInterval, punctuationType));
    }

    private MockProcessorNode(MockProcessorSupplier<K, V> supplier) {
        super(NAME + INDEX.getAndIncrement(), supplier.get(), Collections.emptySet());
        this.supplier = supplier;
    }

    @Override
    public void init(ProcessorContext context) {
        super.init(context);
        this.initialized = true;
    }

    @Override
    public void process(K key, V value) {
        this.processor().process(key, value);
    }

    @Override
    public void punctuate(long timestamp, Punctuator punctuator) {
        super.punctuate(timestamp, punctuator);
        this.punctuatedAt = timestamp;
    }

    @Override
    public void close() {
        super.close();
        this.closed = true;
    }
}

