/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import org.apache.kafka.streams.kstream.Reducer;

public class MockReducer {
    public static final Reducer<String> STRING_ADDER = new StringAdd();
    public static final Reducer<String> STRING_REMOVER = new StringRemove();
    public static final Reducer<Integer> INTEGER_ADDER = new IntegerAdd();
    public static final Reducer<Integer> INTEGER_SUBTRACTOR = new IntegerSubtract();

    private static class IntegerSubtract
    implements Reducer<Integer> {
        private IntegerSubtract() {
        }

        @Override
        public Integer apply(Integer value1, Integer value2) {
            return value1 - value2;
        }
    }

    private static class IntegerAdd
    implements Reducer<Integer> {
        private IntegerAdd() {
        }

        @Override
        public Integer apply(Integer value1, Integer value2) {
            return value1 + value2;
        }
    }

    private static class StringRemove
    implements Reducer<String> {
        private StringRemove() {
        }

        @Override
        public String apply(String value1, String value2) {
            return value1 + "-" + value2;
        }
    }

    private static class StringAdd
    implements Reducer<String> {
        private StringAdd() {
        }

        @Override
        public String apply(String value1, String value2) {
            return value1 + "+" + value2;
        }
    }
}

