/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.AbstractNotifyingRestoreCallback;

public class MockStateRestoreListener
extends AbstractNotifyingRestoreCallback {
    public final Map<String, String> storeNameCalledStates = new HashMap<String, String>();
    public final List<KeyValue<byte[], byte[]>> restored = new ArrayList<KeyValue<byte[], byte[]>>();
    public long restoreStartOffset;
    public long restoreEndOffset;
    public long restoredBatchOffset;
    public long numBatchRestored;
    public long totalNumRestored;
    public TopicPartition restoreTopicPartition;
    public static final String RESTORE_START = "restore_start";
    public static final String RESTORE_BATCH = "restore_batch";
    public static final String RESTORE_END = "restore_end";

    @Override
    public void restore(byte[] key, byte[] value) {
        this.restored.add(KeyValue.pair(key, value));
    }

    @Override
    public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_START, storeName);
        this.restoreStartOffset = startingOffset;
        this.restoreEndOffset = endingOffset;
    }

    @Override
    public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_BATCH, storeName);
        this.restoredBatchOffset = batchEndOffset;
        this.numBatchRestored = numRestored;
    }

    @Override
    public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_END, storeName);
        this.totalNumRestored = totalRestored;
    }

    public String toString() {
        return "MockStateRestoreListener{storeNameCalledStates=" + this.storeNameCalledStates + ", restored=" + this.restored + ", restoreStartOffset=" + this.restoreStartOffset + ", restoreEndOffset=" + this.restoreEndOffset + ", restoredBatchOffset=" + this.restoredBatchOffset + ", numBatchRestored=" + this.numBatchRestored + ", totalNumRestored=" + this.totalNumRestored + ", restoreTopicPartition=" + this.restoreTopicPartition + '}';
    }
}

