/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class NoOpReadOnlyStore<K, V>
implements ReadOnlyKeyValueStore<K, V>,
StateStore {
    private final String name;
    private final boolean rocksdbStore;
    private boolean open = true;
    public boolean initialized;
    public boolean flushed;

    public NoOpReadOnlyStore() {
        this("", false);
    }

    public NoOpReadOnlyStore(String name) {
        this(name, false);
    }

    public NoOpReadOnlyStore(String name, boolean rocksdbStore) {
        this.name = name;
        this.rocksdbStore = rocksdbStore;
    }

    @Override
    public V get(K key) {
        return null;
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return null;
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return null;
    }

    @Override
    public long approximateNumEntries() {
        return 0L;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        if (this.rocksdbStore) {
            new File(context.stateDir() + File.separator + "rocksdb" + File.separator + this.name).mkdirs();
        } else {
            new File(context.stateDir() + File.separator + this.name).mkdir();
        }
        this.initialized = true;
    }

    @Override
    public void flush() {
        this.flushed = true;
    }

    @Override
    public void close() {
        this.open = false;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }
}

