/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class StateStoreProviderStub
implements StateStoreProvider {
    private final Map<String, StateStore> stores = new HashMap<String, StateStore>();
    private final boolean throwException;

    public StateStoreProviderStub(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public <T> List<T> stores(String storeName, QueryableStoreType<T> queryableStoreType) {
        if (this.throwException) {
            throw new InvalidStateStoreException("store is unavailable");
        }
        if (this.stores.containsKey(storeName) && queryableStoreType.accepts(this.stores.get(storeName))) {
            return Collections.singletonList(this.stores.get(storeName));
        }
        return Collections.emptyList();
    }

    public void addStore(String storeName, StateStore store) {
        this.stores.put(storeName, store);
    }
}

