/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class StreamsTestUtils {
    public static Properties getStreamsConfig(String applicationId, String bootstrapServers, String keySerdeClassName, String valueSerdeClassName, Properties additional) {
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", applicationId);
        streamsConfiguration.put("bootstrap.servers", bootstrapServers);
        streamsConfiguration.put("metadata.max.age.ms", "1000");
        streamsConfiguration.put("default.key.serde", keySerdeClassName);
        streamsConfiguration.put("default.value.serde", valueSerdeClassName);
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        streamsConfiguration.put("cache.max.bytes.buffering", (Object)0);
        streamsConfiguration.put("commit.interval.ms", (Object)100);
        streamsConfiguration.putAll((Map<?, ?>)additional);
        return streamsConfiguration;
    }

    public static Properties minimalStreamsConfig() {
        Properties properties = new Properties();
        properties.put("application.id", UUID.randomUUID().toString());
        properties.put("bootstrap.servers", "anyserver:9092");
        return properties;
    }

    public static <K, V> List<KeyValue<K, V>> toList(Iterator<KeyValue<K, V>> iterator) {
        ArrayList<KeyValue<K, V>> results = new ArrayList<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }

    public static <K> void verifyKeyValueList(List<KeyValue<K, byte[]>> expected, List<KeyValue<K, byte[]>> actual) {
        MatcherAssert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.equalTo((Object)expected.size()));
        for (int i = 0; i < actual.size(); ++i) {
            KeyValue<K, byte[]> expectedKv = expected.get(i);
            KeyValue<K, byte[]> actualKv = actual.get(i);
            MatcherAssert.assertThat(actualKv.key, (Matcher)CoreMatchers.equalTo(expectedKv.key));
            MatcherAssert.assertThat(actualKv.value, (Matcher)CoreMatchers.equalTo(expectedKv.value));
        }
    }

    public static void verifyWindowedKeyValue(KeyValue<Windowed<Bytes>, byte[]> actual, Windowed<Bytes> expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)((Windowed)actual.key).window(), (Matcher)CoreMatchers.equalTo((Object)expectedKey.window()));
        MatcherAssert.assertThat(((Windowed)actual.key).key(), (Matcher)CoreMatchers.equalTo((Object)expectedKey.key()));
        MatcherAssert.assertThat(actual.value, (Matcher)CoreMatchers.equalTo((Object)expectedValue.getBytes()));
    }
}

