/*
 * Decompiled with CFR 0.152.
 */
package io.woo.htmltopdf;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import io.woo.htmltopdf.HtmlToPdfException;
import io.woo.htmltopdf.HtmlToPdfObject;
import io.woo.htmltopdf.HtmlToPdfProgress;
import io.woo.htmltopdf.PdfColorMode;
import io.woo.htmltopdf.PdfOrientation;
import io.woo.htmltopdf.PdfPageSize;
import io.woo.htmltopdf.WkValue;
import io.woo.htmltopdf.wkhtmltopdf.WkHtmlToPdf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class HtmlToPdf {
    private final Map<String, String> settings;
    private final List<HtmlToPdfObject> objects = new ArrayList<HtmlToPdfObject>();
    private final List<Consumer<String>> warningCallbacks;
    private final List<Consumer<String>> errorCallbacks;
    private final List<Consumer<HtmlToPdfProgress>> progressChangedCallbacks;
    private final List<Consumer<Boolean>> finishedCallbacks;

    public static HtmlToPdf create() {
        return new HtmlToPdf();
    }

    private HtmlToPdf() {
        this.settings = new HashMap<String, String>();
        this.warningCallbacks = new ArrayList<Consumer<String>>();
        this.errorCallbacks = new ArrayList<Consumer<String>>();
        this.progressChangedCallbacks = new ArrayList<Consumer<HtmlToPdfProgress>>();
        this.finishedCallbacks = new ArrayList<Consumer<Boolean>>();
    }

    public HtmlToPdf pageSize(PdfPageSize pageSize) {
        return this.setting("size.pageSize", pageSize);
    }

    public HtmlToPdf orientation(PdfOrientation orientation) {
        return this.setting("orientation", orientation);
    }

    public HtmlToPdf colorMode(PdfColorMode colorMode) {
        return this.setting("colorMode", colorMode);
    }

    public HtmlToPdf dpi(int dpi) {
        return this.setting("dpi", dpi);
    }

    public HtmlToPdf collate(boolean collate) {
        return this.setting("collate", collate);
    }

    public HtmlToPdf outline(boolean outline) {
        return this.setting("outline", outline);
    }

    public HtmlToPdf outlineDepth(int outlineDepth) {
        return this.setting("outlineDepth", outlineDepth);
    }

    public HtmlToPdf documentTitle(String title) {
        return this.setting("documentTitle", title);
    }

    public HtmlToPdf compression(boolean compression) {
        return this.setting("useCompression", compression);
    }

    public HtmlToPdf marginTop(String marginTop) {
        return this.setting("margin.top", marginTop);
    }

    public HtmlToPdf marginBottom(String marginBottom) {
        return this.setting("margin.bottom", marginBottom);
    }

    public HtmlToPdf marginLeft(String marginLeft) {
        return this.setting("margin.left", marginLeft);
    }

    public HtmlToPdf marginRight(String marginRight) {
        return this.setting("margin.right", marginRight);
    }

    public HtmlToPdf imageDpi(int imageDpi) {
        return this.setting("imageDPI", imageDpi);
    }

    public HtmlToPdf imageQuality(int quality) {
        return this.setting("imageQuality", quality);
    }

    public HtmlToPdf cookieJar(String cookieJar) {
        return this.setting("load.cookieJar", cookieJar);
    }

    public HtmlToPdf warning(Consumer<String> warningConsumer) {
        this.warningCallbacks.add(warningConsumer);
        return this;
    }

    public HtmlToPdf error(Consumer<String> errorConsumer) {
        this.errorCallbacks.add(errorConsumer);
        return this;
    }

    public HtmlToPdf progress(Consumer<HtmlToPdfProgress> progressChangeConsumer) {
        this.progressChangedCallbacks.add(progressChangeConsumer);
        return this;
    }

    public HtmlToPdf finished(Consumer<Boolean> finishConsumer) {
        this.finishedCallbacks.add(finishConsumer);
        return this;
    }

    public HtmlToPdf success(Runnable successRunnable) {
        return this.finished(success -> {
            if (success.booleanValue()) {
                successRunnable.run();
            }
        });
    }

    public HtmlToPdf failure(Runnable failureRunnable) {
        return this.finished(success -> {
            if (!success.booleanValue()) {
                failureRunnable.run();
            }
        });
    }

    public HtmlToPdf object(HtmlToPdfObject object) {
        this.objects.add(object);
        return this;
    }

    public boolean convert(String path) {
        if (this.objects.size() < 1) {
            return false;
        }
        HashMap<String, String> settings = new HashMap<String, String>(this.settings);
        settings.put("out", path);
        return this.withConverter(settings, (c, wkHtmlToPdf) -> wkHtmlToPdf.wkhtmltopdf_convert((Pointer)c) == 1);
    }

    public InputStream convert() {
        HashMap<String, String> settings = new HashMap<String, String>(this.settings);
        settings.remove("out");
        return this.withConverter(settings, (c, wkHtmlToPdf) -> {
            ArrayList log = new ArrayList();
            this.warning(w -> log.add("Warning: " + w));
            this.error(e -> log.add("Error: " + e));
            PointerByReference out = new PointerByReference();
            if (wkHtmlToPdf.wkhtmltopdf_convert((Pointer)c) == 1) {
                long size = wkHtmlToPdf.wkhtmltopdf_get_output((Pointer)c, out);
                byte[] pdfBytes = new byte[(int)size];
                out.getValue().read(0L, pdfBytes, 0, pdfBytes.length);
                return new ByteArrayInputStream(pdfBytes);
            }
            throw new HtmlToPdfException("Conversion returned with failure. Log:\n" + log.stream().collect(Collectors.joining("\n")));
        });
    }

    private HtmlToPdf setting(String name, Object value) {
        return this.setting(name, value.toString());
    }

    private HtmlToPdf setting(String name, WkValue value) {
        return this.setting(name, value.getWkValue());
    }

    private HtmlToPdf setting(String name, String value) {
        this.settings.put(name, value);
        return this;
    }

    private <T> T withConverter(Map<String, String> settings, BiFunction<Pointer, WkHtmlToPdf, T> consumer) {
        return (T)WkHtmlToPdf.withInstance(wkHtmlToPdf -> {
            Pointer globalSettings = wkHtmlToPdf.wkhtmltopdf_create_global_settings();
            settings.forEach((k, v) -> wkHtmlToPdf.wkhtmltopdf_set_global_setting(globalSettings, (String)k, (String)v));
            Pointer converter = wkHtmlToPdf.wkhtmltopdf_create_converter(globalSettings);
            wkHtmlToPdf.wkhtmltopdf_set_warning_callback(converter, (c, s) -> this.warningCallbacks.forEach(wc -> wc.accept(s)));
            wkHtmlToPdf.wkhtmltopdf_set_error_callback(converter, (c, s) -> this.errorCallbacks.forEach(ec -> ec.accept(s)));
            wkHtmlToPdf.wkhtmltopdf_set_progress_changed_callback(converter, (c, phaseProgress) -> {
                int phase = wkHtmlToPdf.wkhtmltopdf_current_phase(c);
                int totalPhases = wkHtmlToPdf.wkhtmltopdf_phase_count(c);
                String phaseDesc = wkHtmlToPdf.wkhtmltopdf_phase_description(c, phase);
                HtmlToPdfProgress progress = new HtmlToPdfProgress(phase, phaseDesc, totalPhases, phaseProgress);
                this.progressChangedCallbacks.forEach(pc -> pc.accept(progress));
            });
            wkHtmlToPdf.wkhtmltopdf_set_finished_callback(converter, (c, i) -> this.finishedCallbacks.forEach(fc -> fc.accept(i == 1)));
            try {
                this.objects.forEach(object -> {
                    Pointer objectSettings = wkHtmlToPdf.wkhtmltopdf_create_object_settings();
                    object.getSettings().forEach((k, v) -> wkHtmlToPdf.wkhtmltopdf_set_object_setting(objectSettings, (String)k, (String)v));
                    wkHtmlToPdf.wkhtmltopdf_add_object(converter, objectSettings, object.getHtmlData());
                });
                Object r = consumer.apply(converter, (WkHtmlToPdf)wkHtmlToPdf);
                return r;
            }
            finally {
                wkHtmlToPdf.wkhtmltopdf_destroy_converter(converter);
            }
        });
    }
}

