/*
 * Decompiled with CFR 0.152.
 */
package io.writeopia.loadingbutton.presentation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import io.writeopia.loadingbutton.customViews.ProgressButton;
import io.writeopia.loadingbutton.presentation.State;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lio/writeopia/loadingbutton/presentation/ProgressButtonPresenter;", "", "view", "Lio/writeopia/loadingbutton/customViews/ProgressButton;", "<init>", "(Lio/writeopia/loadingbutton/customViews/ProgressButton;)V", "state", "Lio/writeopia/loadingbutton/presentation/State;", "getState", "()Lio/writeopia/loadingbutton/presentation/State;", "setState", "(Lio/writeopia/loadingbutton/presentation/State;)V", "morphStart", "", "morphEnd", "morphRevertStart", "morphRevertEnd", "onDraw", "canvas", "Landroid/graphics/Canvas;", "startAnimation", "stopAnimation", "revertAnimation", "doneLoadingAnimation", "fillColor", "", "bitmap", "Landroid/graphics/Bitmap;", "validateSetProgress", "", "validateSetProgress$loading_button_android_release", "loading-button-android_release"})
public final class ProgressButtonPresenter {
    @NotNull
    private final ProgressButton view;
    @NotNull
    private State state;

    public ProgressButtonPresenter(@NotNull ProgressButton view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.state = State.BEFORE_DRAW;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    public final void morphStart() {
        ProgressButton $this$morphStart_u24lambda_u240 = this.view;
        boolean bl = false;
        $this$morphStart_u24lambda_u240.hideInitialState();
        $this$morphStart_u24lambda_u240.setClickable(false);
        $this$morphStart_u24lambda_u240.setCompoundDrawables(null, null, null, null);
        this.state = State.MORPHING;
    }

    public final void morphEnd() {
        State state;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                new Handler().postDelayed(() -> ProgressButtonPresenter.morphEnd$lambda$1(this), 50L);
                state = State.DONE;
                break;
            }
            case 2: {
                state = State.STOPPED;
                break;
            }
            default: {
                state = State.PROGRESS;
            }
        }
        this.state = state;
    }

    public final void morphRevertStart() {
        this.view.setClickable(false);
        this.state = State.MORPHING;
    }

    public final void morphRevertEnd() {
        this.view.setClickable(true);
        this.view.recoverInitialState();
        this.state = State.IDLE;
    }

    public final void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 3: {
                this.state = State.IDLE;
                this.view.saveInitialState();
                break;
            }
            case 4: {
                this.view.saveInitialState();
                this.view.startMorphAnimation();
                break;
            }
            case 5: {
                this.view.drawProgress(canvas);
                break;
            }
            case 6: {
                this.view.drawDoneAnimation(canvas);
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void startAnimation() {
        if (this.state == State.BEFORE_DRAW) {
            this.state = State.WAITING_PROGRESS;
            return;
        }
        if (this.state != State.IDLE) {
            return;
        }
        this.view.startMorphAnimation();
    }

    public final void stopAnimation() {
        State state;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 5: {
                this.view.stopProgressAnimation();
                state = State.STOPPED;
                break;
            }
            case 4: 
            case 7: {
                state = State.WAITING_TO_STOP;
                break;
            }
            default: {
                state = State.STOPPED;
            }
        }
        this.state = state;
    }

    public final void revertAnimation() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 7: {
                this.view.stopMorphAnimation();
                this.view.startMorphRevertAnimation();
                break;
            }
            case 5: {
                this.view.stopProgressAnimation();
                this.view.startMorphRevertAnimation();
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                this.view.startMorphRevertAnimation();
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void doneLoadingAnimation(int fillColor, @NotNull Bitmap bitmap) {
        State state;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.view.initRevealAnimation(fillColor, bitmap);
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 5: {
                this.view.stopProgressAnimation();
                this.view.startRevealAnimation();
                state = State.DONE;
                break;
            }
            case 7: {
                state = State.WAITING_DONE;
                break;
            }
            case 8: {
                this.view.startRevealAnimation();
                state = State.DONE;
                break;
            }
            default: {
                state = State.DONE;
            }
        }
        this.state = state;
    }

    public final boolean validateSetProgress$loading_button_android_release() {
        return this.state == State.PROGRESS || this.state == State.MORPHING || this.state == State.WAITING_PROGRESS;
    }

    private static final void morphEnd$lambda$1(ProgressButtonPresenter this$0) {
        this$0.view.startRevealAnimation();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.WAITING_DONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.WAITING_TO_STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.BEFORE_DRAW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.WAITING_PROGRESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PROGRESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DONE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MORPHING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.STOPPED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

