/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.graal.templating.spring.repository;

import io.wttech.graal.templating.javascript.JavascriptRendererException;
import io.wttech.graal.templating.repository.ScriptProvider;
import java.net.URI;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class ExternalScriptProvider
implements ScriptProvider {
    private final WebClient webClient;
    private final URI uri;

    public Mono<String> getBundle() {
        return this.webClient.get().uri(this.uri).retrieve().onStatus(status -> !status.equals((Object)HttpStatus.OK), response -> Mono.error((Throwable)new JavascriptRendererException("Could not retrieve script. Server did not return 200 OK."))).bodyToMono(String.class);
    }

    ExternalScriptProvider(WebClient webClient, URI uri) {
        this.webClient = webClient;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WebClient webClient;
        private URI uri;

        Builder() {
        }

        public Builder webClient(WebClient webClient) {
            this.webClient = webClient;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public ExternalScriptProvider build() {
            return new ExternalScriptProvider(this.webClient, this.uri);
        }

        public String toString() {
            return "ExternalScriptProvider.Builder(webClient=" + this.webClient + ", uri=" + this.uri + ")";
        }
    }
}

