/*
 * Decompiled with CFR 0.152.
 */
package io.xconn.cryptology;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.util.Pack;

class HSalsa20 {
    private static final byte[] SIGMA = "expand 32-byte k".getBytes(StandardCharsets.US_ASCII);
    private static final int SIGMA_0 = Pack.littleEndianToInt((byte[])SIGMA, (int)0);
    private static final int SIGMA_4 = Pack.littleEndianToInt((byte[])SIGMA, (int)4);
    private static final int SIGMA_8 = Pack.littleEndianToInt((byte[])SIGMA, (int)8);
    private static final int SIGMA_12 = Pack.littleEndianToInt((byte[])SIGMA, (int)12);

    HSalsa20() {
    }

    static void hsalsa20(byte[] out, byte[] in, byte[] k) {
        int[] x = new int[16];
        int in0 = Pack.littleEndianToInt((byte[])in, (int)0);
        int in4 = Pack.littleEndianToInt((byte[])in, (int)4);
        int in8 = Pack.littleEndianToInt((byte[])in, (int)8);
        int in12 = Pack.littleEndianToInt((byte[])in, (int)12);
        x[0] = SIGMA_0;
        x[1] = Pack.littleEndianToInt((byte[])k, (int)0);
        x[2] = Pack.littleEndianToInt((byte[])k, (int)4);
        x[3] = Pack.littleEndianToInt((byte[])k, (int)8);
        x[4] = Pack.littleEndianToInt((byte[])k, (int)12);
        x[5] = SIGMA_4;
        x[6] = in0;
        x[7] = in4;
        x[8] = in8;
        x[9] = in12;
        x[10] = SIGMA_8;
        x[11] = Pack.littleEndianToInt((byte[])k, (int)16);
        x[12] = Pack.littleEndianToInt((byte[])k, (int)20);
        x[13] = Pack.littleEndianToInt((byte[])k, (int)24);
        x[14] = Pack.littleEndianToInt((byte[])k, (int)28);
        x[15] = SIGMA_12;
        Salsa20Engine.salsaCore((int)20, (int[])x, (int[])x);
        x[0] = x[0] - SIGMA_0;
        x[5] = x[5] - SIGMA_4;
        x[10] = x[10] - SIGMA_8;
        x[15] = x[15] - SIGMA_12;
        x[6] = x[6] - in0;
        x[7] = x[7] - in4;
        x[8] = x[8] - in8;
        x[9] = x[9] - in12;
        Pack.intToLittleEndian((int)x[0], (byte[])out, (int)0);
        Pack.intToLittleEndian((int)x[5], (byte[])out, (int)4);
        Pack.intToLittleEndian((int)x[10], (byte[])out, (int)8);
        Pack.intToLittleEndian((int)x[15], (byte[])out, (int)12);
        Pack.intToLittleEndian((int)x[6], (byte[])out, (int)16);
        Pack.intToLittleEndian((int)x[7], (byte[])out, (int)20);
        Pack.intToLittleEndian((int)x[8], (byte[])out, (int)24);
        Pack.intToLittleEndian((int)x[9], (byte[])out, (int)28);
    }
}

