/*
 * Decompiled with CFR 0.152.
 */
package io.xconn.cryptology;

import io.xconn.cryptology.Util;

public class SecretBox {
    public static byte[] box(byte[] nonce, byte[] message, byte[] privateKey) {
        byte[] output = new byte[message.length + 16];
        SecretBox.box(output, nonce, message, privateKey);
        return output;
    }

    public static void box(byte[] output, byte[] nonce, byte[] message, byte[] privateKey) {
        Util.encrypt(output, nonce, message, privateKey);
    }

    public static byte[] boxOpen(byte[] nonce, byte[] ciphertext, byte[] privateKey) {
        byte[] plainText = new byte[ciphertext.length - 16];
        SecretBox.boxOpen(plainText, nonce, ciphertext, privateKey);
        return plainText;
    }

    public static void boxOpen(byte[] output, byte[] nonce, byte[] ciphertext, byte[] privateKey) {
        Util.decrypt(output, nonce, ciphertext, privateKey);
    }

    public static byte[] generateSecret() {
        return Util.generateRandomBytesArray(32);
    }

    public static byte[] generateNonce() {
        return Util.generateRandomBytesArray(24);
    }
}

