package io.xiaper.jpa.model;

import javax.persistence.*;

/**
 * 留言
 *
 * @author xiaper.io
 */
@Entity
@Table(name = "leave_message")
public class LeaveMessage extends AuditModel {

    private static final long serialVersionUID = 5541007700000492374L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    private Long id;

    /**
     * 唯一数字id，保证唯一性
     * 替代id
     */
    @Column(name = "lid", unique = true, nullable = false)
    private String lid;

    /**
     * 手机号
     */
    @Column(name = "mobile")
    private String mobile;

    /**
     * 邮箱
     */
    @Column(name = "email")
    private String email;

    /**
     * 留言内容
     */
    @Column(name = "content")
    private String content;

    /**
     * 是否已经回复
     */
    @Column(name = "is_replied")
    private boolean replied;

    /**
     * 回复内容
     */
    @Column(name = "reply")
    private String reply;

    /**
     * 小结内容，因summary为Oracle保留字，故添加my_前缀
     */
    @Column(name = "my_summary")
    private String summary;

    /**
     * 留言状态: 未领取、已领取、已小结
     */
    @Column(name = "status")
    private String status;

    /**
     * 留言类型：工作组留言、一对一留言
     */
    @Column(name = "by_type")
    private String type;

    /**
     * 访客, 留言者
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "visitor_id", nullable = false,
            foreignKey = @ForeignKey(name = "none", value = ConstraintMode.NO_CONSTRAINT))
    private User visitor;

    /**
     * 留言对应工作组
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "workGroup_id", foreignKey = @ForeignKey(name = "none", value = ConstraintMode.NO_CONSTRAINT))
    private WorkGroup workGroup;

    /**
     * 一对一被留言人
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "agent_id", foreignKey = @ForeignKey(name = "none", value = ConstraintMode.NO_CONSTRAINT))
    private User agent;

    /**
     * 领取人
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "claimer_id", foreignKey = @ForeignKey(name = "none", value = ConstraintMode.NO_CONSTRAINT))
    private User claimer;

    /**
     * 管理员:
     * FIXME: 为方便查询添加此字段，有待优化
     */
//    @ManyToOne(fetch = FetchType.EAGER)
//    @JoinColumn(name = "users_id", foreignKey = @ForeignKey(name = "none", value = ConstraintMode.NO_CONSTRAINT))
//    private User user;

    @Column(name = "sub_domain")
    private String subDomain;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLid() {
        return lid;
    }

    public void setLid(String lid) {
        this.lid = lid;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public User getVisitor() {
        return visitor;
    }

    public void setVisitor(User visitor) {
        this.visitor = visitor;
    }

    public String getSubDomain() {
        return subDomain;
    }

    public void setSubDomain(String subDomain) {
        this.subDomain = subDomain;
    }

    public boolean isReplied() {
        return replied;
    }

    public void setReplied(boolean replied) {
        this.replied = replied;
    }

    public String getReply() {
        return reply;
    }

    public void setReply(String reply) {
        this.reply = reply;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WorkGroup getWorkGroup() {
        return workGroup;
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.workGroup = workGroup;
    }

    public User getAgent() {
        return agent;
    }

    public void setAgent(User agent) {
        this.agent = agent;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public User getClaimer() {
        return claimer;
    }

    public void setClaimer(User claimer) {
        this.claimer = claimer;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }
}
