package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.persistence.*;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 工作时间
 *
 * @author xiaper.io
 */
@Entity
@Table(name = "work_time")
public class WorkTime extends AuditModel {

    private static final long serialVersionUID = 6998065367142353284L;

//    @Transient
//    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    private Long id;

    /**
     * columnDefinition=" COMMENT '上班时间' "
     */
    @Column(name = "start_time")
    @JsonFormat(pattern = "HH:mm:ss", timezone="GMT+8")
    @Temporal(TemporalType.TIME)
    private Date startTime;

    /**
     * columnDefinition=" COMMENT '下班时间' "
     */
    @Column(name = "end_time")
    @JsonFormat(pattern = "HH:mm:ss", timezone="GMT+8")
    @Temporal(TemporalType.TIME)
    private Date endTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 是否工作时间
     *
     * @return 是否工作时间
     */
    public boolean isWorkTime() {

        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String timeString = formatter.format(new Date());

        Date now = null;
        try {
            now = formatter.parse(timeString);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        Calendar calendarNow = Calendar.getInstance();
        calendarNow.setTime(now);
        calendarNow.set(0,0,0);

        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(startTime);
        calendarStart.set(0, 0, 0);

        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(endTime);
        calendarEnd.set(0,0,0);

        boolean result1 = calendarNow.getTime().after(calendarStart.getTime());
        boolean result2 = calendarNow.getTime().before(calendarEnd.getTime());

//        logger.info("startTime {}, nowTime {}, endTime {}, result1 {},  result2 {}",
//                calendarStart.getTime().toString(), calendarNow.getTime().toString(), calendarEnd.getTime().toString(),
//                result1 ? "before true" : "before false",
//                result2 ? "end true" : "end false");

        return result1 && result2;
    }

}
