package io.xiaper.jpa.repository;

import io.xiaper.jpa.model.App;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.App;
import io.xiaper.jpa.model.User;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.Optional;

/**
 *
 * 测试:
 *  设置了data-rest前缀之后，通过 http://localhost:8000/apps 可以访问测试rest接口
 * //@RepositoryRestResource(path="apps")
 * @author xiaper.io
 */
@Repository
public interface AppRepository extends JpaRepository<App, Long>, JpaSpecificationExecutor {

    Optional<App> findByAid(String aid);

    Optional<App> findFirstByUser(User user);

    Page<App> findByUserAndType(User user, String type, Pageable pageable);
}
