package io.xiaper.jpa.repository;

import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.Thread;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 *
 * @author xiaper.io
 */
@Repository
public interface MessageRepository extends JpaRepository<Message, Long>, JpaSpecificationExecutor {

    Optional<Message> findByMid(String mid);

    Page<Message> findByGidAndDeletedSetNotContains(String gid, User user, Pageable pageable);

    Page<Message> findByCidAndUserOrCidAndUserAndDeletedSetNotContains(String cid1, User user1, String cid2, User user2, User user3, Pageable pageable);

    Page<Message> findByThread(Thread thread, Pageable pageable);

    List<Message> findByThreadAndDeletedSetNotContains(Thread thread, User user);

    List<Message> findByGidAndDeletedSetNotContains(String gid, User user);

    Optional<Message> findFirstByThreadAndTypeOrderByIdDesc(Thread thread, String type);

    Page<Message> findByThread_VisitorAndDeletedSetNotContains(User visitor, User user, Pageable pageable);

    Page<Message> findByThread_WorkGroup_User(User user, Pageable pageable);


    @Query(value = "select * from message m left outer join thread t on m.thread_id=t.id where m.id < :id and t.visitor_id = :visitor_id", nativeQuery = true)
    Page<Message> findByIdAndThread_Visitor(@Param("id") Long id, @Param("visitor_id") Long visitor_id, Pageable pageable);

    @Query(value = "select * from message m where m.id < :id and ( ( m.cid = :cid1 and m.users_id = :user1_id ) or ( m.cid = :cid2 and m.users_id = :user2_id ) )", nativeQuery = true)
    Page<Message> findByIdAndCidAndUserOrCidAndUser(@Param("id") Long id, @Param("cid1") String cid1, @Param("user1_id") Long user1_id,
                                                    @Param("cid2") String cid2, @Param("user2_id") Long user2_id, Pageable pageable);

    /**
     * 加载某条聊天记录之后的数据
     *
     * @param id id
     * @param gid gid
     * @param pageable 分页
     * @return 聊天记录
     */
    @Query(value = "select * from message m where m.id < :id and m.gid = :gid", nativeQuery = true)
    Page<Message> findByIdAndGid(@Param("id") Long id, @Param("gid") String gid, Pageable pageable);

    /**
     * 某个时间段内的所有消息
     *
     * @param startAt 起始时间
     * @param endAt 结束时间
     * @param sessionType 会话类型
     * @return 聊天记录
     */
    List<Message> findByCreatedAtBetweenAndSessionType(Date startAt, Date endAt, String sessionType);

}
