package io.xiaper.jpa.repository;

import io.xiaper.jpa.model.Group;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.model.Group;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.WorkGroup;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 *
 * @author xiaper.io
 */
@Repository
public interface ThreadRepository extends JpaRepository<Thread, Long>, JpaSpecificationExecutor {

    Optional<Thread> findFirstByVisitorAndWorkGroupAndAppointedAndClosed(User visitor, WorkGroup workGroup, boolean appointed, boolean closed);

    Optional<Thread> findFirstByVisitorAndAgentAndAppointedAndClosed(User visitor, User agent, boolean appointed, boolean closed);

    Optional<Thread> findByTid(String tid);

    Optional<Thread> findFirstByContactAndAgent(User contact, User agent);

    Optional<Thread> findFirstByGroup(Group group);

    Page<Thread> findByAgentsContainsAndClosed(User agent, boolean closed, Pageable pageable);

    Page<Thread> findByWorkGroup_UserAndClosedAndAgentNotNull(User user, boolean closed, Pageable pageable);

    Page<Thread> findByWorkGroup_UserAndClosedAndAgentNotNullOrAgentOrAgent_User(User user, boolean closed, User user1, User user2, Pageable pageable);

    Page<Thread> findByWorkGroup_UsersContainsAndClosedAndWorkGroup_AdminAndAgentNotNull(User user, boolean closed, User admin, Pageable pageable);

    Page<Thread> findByVisitor(User visitor, Pageable pageable);

    /**
     * 找出某个客服*时间至现在的所有会话
     *
     * @param timestamp 时间
     * @param agent 客服
     * @param pageable 分页
     * @return 会话列表
     */
    Page<Thread> findByTimestampAfterAndAgentsContains(Date timestamp, User agent, Pageable pageable);

    /**
     * 查询某个时间点之前，而且是否关闭的会话
     * @param timestamp 时间
     * @param type 类型
     * @param closed 是否关闭
     * @return 会话列表
     */
    List<Thread> findByTimestampBeforeAndTypeAndClosedOrderByIdAsc(Date timestamp, String type, boolean closed);

    /**
     * 某个时间段内进入的会话thread
     * @param startAt 开始时间
     * @param endAt 结束时间
     * @return 会话列表
     */
    List<Thread> findByCreatedAtBetween(Date startAt, Date endAt);

    /**
     * 某个时间段内开始的客服会话
     * @param startAt 开始时间
     * @param endAt 结束时间
     * @param type 类型
     * @return 会话列表
     */
    List<Thread> findByStartedAtBetweenAndType(Date startAt, Date endAt, String type);

    /**
     * 所有结束/未结束会话
     * @param close 是否结束
     * @return 会话
     */
    List<Thread> findByClosed(boolean close);

    Long countByAgentsContainsAndClosed(User agent, boolean closed);

    List<Thread> findByVisitorAndClosed(User visitor, boolean closed);

    List<Thread> findByVisitorAndSessionIdAndClosed(User visitor, String sessionId, boolean closed);

    List<Thread> findByAgentAndClosed(User agent, boolean closed);

    /**
     * 查询一对一会话的thread
     * @param type 类型
     * @param agent1 客服
     * @param agent2 客服
     * @return 会话
     */
    Optional<Thread> findByTypeAndAgentsContainsAndAgentsContains(String type, User agent1, User agent2);

    List<Thread> findByAgentAndTypeAndDeletedSetNotContains(User agent, String type, User user);

    List<Thread> findByGroup_MembersContainsAndGroup_DismissedAndType(User user, boolean dismissed, String type);

}
