/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.xiaper.jpa.model.AuditModel;
import io.xiaper.jpa.model.Category;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="answer")
public class Answer
extends AuditModel {
    private static final long serialVersionUID = -5490961831704509253L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Long id;
    @Column(name="aid", unique=true, nullable=false)
    private String aid;
    @Column(name="question")
    private String question;
    @Column(name="answer")
    private String answer;
    @Column(name="query_count")
    private int queryCount;
    @Column(name="is_welcome")
    private boolean welcome = false;
    @Column(name="is_recommend")
    private boolean recommend = false;
    @Column(name="rate_helpful")
    private int rateHelpful;
    @Column(name="rate_useless")
    private int rateUseless;
    @Column(name="url")
    private String url;
    @Column(name="media_id")
    private String mediaId;
    @Column(name="weixin_url")
    private String weiXinUrl;
    @Column(name="is_related")
    private boolean related;
    @Column(name="code")
    private String code;
    @JsonIgnore
    @ManyToMany(mappedBy="answers", fetch=FetchType.EAGER)
    private Set<Message> messages = new HashSet<Message>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="answer_category", joinColumns={@JoinColumn(name="answer_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="category_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<Category> categories = new HashSet<Category>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="answer_related", joinColumns={@JoinColumn(name="answer_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="related_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<Answer> relateds = new HashSet<Answer>();
    @JsonIgnore
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="workgroup_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private WorkGroup workGroup;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="users_id", nullable=false, foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User user;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void setQueryCount(int queryCount) {
        this.queryCount = queryCount;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getWeiXinUrl() {
        return this.weiXinUrl;
    }

    public void setWeiXinUrl(String weiXinUrl) {
        this.weiXinUrl = weiXinUrl;
    }

    public WorkGroup getWorkGroup() {
        return this.workGroup;
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.workGroup = workGroup;
    }

    public Set<Answer> getRelateds() {
        return this.relateds;
    }

    public void setRelateds(Set<Answer> relateds) {
        this.relateds = relateds;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Set<Message> messages) {
        this.messages = messages;
    }

    public boolean isRelated() {
        return this.related;
    }

    public void setRelated(boolean related) {
        this.related = related;
    }

    public int getRateHelpful() {
        return this.rateHelpful;
    }

    public void setRateHelpful(int rateHelpful) {
        this.rateHelpful = rateHelpful;
    }

    public int getRateUseless() {
        return this.rateUseless;
    }

    public void setRateUseless(int rateUseless) {
        this.rateUseless = rateUseless;
    }

    public String getAid() {
        return this.aid;
    }

    public void setAid(String aid) {
        this.aid = aid;
    }

    public boolean isWelcome() {
        return this.welcome;
    }

    public void setWelcome(boolean welcome) {
        this.welcome = welcome;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public void setRecommend(boolean recommend) {
        this.recommend = recommend;
    }

    public void updateQueryCount() {
        ++this.queryCount;
    }

    public void rate(boolean rate) {
        if (rate) {
            this.rateHelpful();
        } else {
            this.rateUseless();
        }
    }

    public void rateHelpful() {
        ++this.rateHelpful;
    }

    public void rateUseless() {
        ++this.rateUseless;
    }
}

