/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.xiaper.jpa.model.ArticleRate;
import io.xiaper.jpa.model.ArticleRead;
import io.xiaper.jpa.model.AuditModel;
import io.xiaper.jpa.model.Category;
import io.xiaper.jpa.model.Comment;
import io.xiaper.jpa.model.Tag;
import io.xiaper.jpa.model.User;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="article")
public class Article
extends AuditModel {
    private static final long serialVersionUID = 8654550640233552864L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Long id;
    @Column(name="aid", unique=true, nullable=false)
    private String aid;
    @Column(name="title")
    private String title;
    @Column(name="summary")
    private String summary;
    @Column(name="read_count")
    private int readCount;
    @Column(name="is_recommend")
    private boolean recommend = false;
    @Column(name="is_top")
    private boolean top = false;
    @Column(name="is_reship")
    private boolean reship = false;
    @Column(name="reship_url")
    private String reshipUrl;
    @Column(name="is_published")
    private boolean published = false;
    @Column(name="is_markdown")
    private boolean markdown = false;
    @Column(name="rate_helpful")
    private int rateHelpful;
    @Column(name="rate_useless")
    private int rateUseless;
    @Lob
    @Column(name="content")
    private String content;
    @JsonIgnore
    @OneToMany(mappedBy="article")
    private Set<ArticleRate> rates = new HashSet<ArticleRate>();
    @JsonIgnore
    @OneToMany(mappedBy="article")
    private Set<ArticleRead> reads = new HashSet<ArticleRead>();
    @OneToMany(mappedBy="article")
    private Set<Comment> comments = new HashSet<Comment>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="article_keyword", joinColumns={@JoinColumn(name="article_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="tag_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<Tag> keywords = new HashSet<Tag>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="article_category", joinColumns={@JoinColumn(name="article_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="category_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<Category> categories = new HashSet<Category>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="users_id", nullable=false, foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User user;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getRateHelpful() {
        return this.rateHelpful;
    }

    public void setRateHelpful(int rateHelpful) {
        this.rateHelpful = rateHelpful;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public Set<Comment> getComments() {
        return this.comments;
    }

    public void setComments(Set<Comment> comments) {
        this.comments = comments;
    }

    public String getAid() {
        return this.aid;
    }

    public void setAid(String aid) {
        this.aid = aid;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public void setRecommend(boolean recommend) {
        this.recommend = recommend;
    }

    public int getRateUseless() {
        return this.rateUseless;
    }

    public void setRateUseless(int rateUseless) {
        this.rateUseless = rateUseless;
    }

    public Set<ArticleRate> getRates() {
        return this.rates;
    }

    public void setRates(Set<ArticleRate> rates) {
        this.rates = rates;
    }

    public Set<ArticleRead> getReads() {
        return this.reads;
    }

    public void setReads(Set<ArticleRead> reads) {
        this.reads = reads;
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public Set<Tag> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<Tag> keywords) {
        this.keywords = keywords;
    }

    public boolean isReship() {
        return this.reship;
    }

    public void setReship(boolean reship) {
        this.reship = reship;
    }

    public String getReshipUrl() {
        return this.reshipUrl;
    }

    public void setReshipUrl(String reshipUrl) {
        this.reshipUrl = reshipUrl;
    }

    public boolean isMarkdown() {
        return this.markdown;
    }

    public void setMarkdown(boolean markdown) {
        this.markdown = markdown;
    }

    public void updateReadCount() {
        ++this.readCount;
    }

    public void rate(boolean rate) {
        if (rate) {
            this.rateHelpful();
        } else {
            this.rateUseless();
        }
    }

    public void rateHelpful() {
        ++this.rateHelpful;
    }

    public void rateUseless() {
        ++this.rateUseless;
    }
}

