/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import io.xiaper.jpa.model.AuditModel;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="queue")
public class Queue
extends AuditModel {
    private static final long serialVersionUID = -5749949008949056993L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Long id;
    @Column(name="qid", unique=true, nullable=false)
    private String qid;
    @Column(name="client")
    private String client;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="visitor_id", nullable=false, foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User visitor;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="agent_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User agent;
    @Column(name="agent_client")
    private String agentClient;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private Thread thread;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="workgroup_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private WorkGroup workGroup;
    @Column(name="actioned_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date actionedAt;
    @Column(name="status")
    private String status;

    public boolean queuing() {
        return this.status.equals("queuing");
    }

    public void accept() {
        this.actionedAt = new Date();
        this.status = "accepted";
    }

    public void leave() {
        this.actionedAt = new Date();
        this.status = "leaved";
    }

    public Long waitLength() {
        return (this.actionedAt.getTime() - this.getCreatedAt().getTime()) / 1000L;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getVisitor() {
        return this.visitor;
    }

    public void setVisitor(User visitor) {
        this.visitor = visitor;
    }

    public User getAgent() {
        return this.agent;
    }

    public void setAgent(User agent) {
        this.agent = agent;
    }

    public String getAgentClient() {
        return this.agentClient;
    }

    public void setAgentClient(String agentClient) {
        this.agentClient = agentClient;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public WorkGroup getWorkGroup() {
        return this.workGroup;
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.workGroup = workGroup;
    }

    public Date getActionedAt() {
        return this.actionedAt;
    }

    public void setActionedAt(Date actionedAt) {
        this.actionedAt = actionedAt;
    }

    public String getQid() {
        return this.qid;
    }

    public void setQid(String qid) {
        this.qid = qid;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String toString() {
        return "Queue{id=" + this.id + ", qid='" + this.qid + '\'' + ", visitor=" + this.visitor + ", agent=" + this.agent + ", agentClient='" + this.agentClient + '\'' + ", workGroup=" + this.workGroup + '}';
    }
}

