/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.xiaper.jpa.model.AuditModel;
import io.xiaper.jpa.model.Group;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Queue;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="thread")
public class Thread
extends AuditModel {
    private static final long serialVersionUID = 1194607482984119161L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Long id;
    @Column(name="tid", unique=true, nullable=false)
    private String tid;
    @Column(name="token")
    private String token;
    @Column(name="session_id")
    private String sessionId;
    @Column(name="content")
    private String content;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="timestamp")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date timestamp;
    @Column(name="unread_count")
    private int unreadCount;
    @Column(name="is_current")
    private boolean current = false;
    @Column(name="by_type")
    private String type;
    @Column(name="client")
    private String client;
    @Column(name="close_type")
    private String closeType;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="queue_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private Queue queue;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="visitor_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User visitor;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="contact_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User contact;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="group_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private Group group;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="agent_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User agent;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="thread_agent", joinColumns={@JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> agents = new HashSet<User>();
    @JsonIgnore
    @OneToMany(mappedBy="thread")
    private Set<Message> messages = new HashSet<Message>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="workgroup_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private WorkGroup workGroup;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="thread_top", joinColumns={@JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> topSet = new HashSet<User>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="thread_disturb", joinColumns={@JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> disturbSet = new HashSet<User>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="thread_unread", joinColumns={@JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> unreadSet = new HashSet<User>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="thread_deleted", joinColumns={@JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> deletedSet = new HashSet<User>();
    @Column(name="started_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startedAt;
    @Column(name="is_appointed")
    private boolean appointed = false;
    @Column(name="is_rated")
    private boolean rated;
    @Column(name="is_closed")
    private boolean closed;
    @Column(name="is_auto_close")
    private boolean autoClose;
    @Column(name="closed_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date closedAt;

    public Thread() {
    }

    public Thread(String tid) {
        this.tid = tid;
    }

    public void close() {
        this.closedAt = new Date();
        this.closed = true;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    public void increaseUnreadCount() {
        ++this.unreadCount;
    }

    public void clearUnreadCount() {
        this.unreadCount = 0;
    }

    public WorkGroup getWorkGroup() {
        return this.workGroup;
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.workGroup = workGroup;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public User getVisitor() {
        return this.visitor;
    }

    public void setVisitor(User visitor) {
        this.visitor = visitor;
    }

    public User getContact() {
        return this.contact;
    }

    public void setContact(User contact) {
        this.contact = contact;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public User getAgent() {
        return this.agent;
    }

    public void setAgent(User agent) {
        this.agent = agent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<User> getAgents() {
        return this.agents;
    }

    public void setAgents(Set<User> agents) {
        this.agents = agents;
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Set<Message> messages) {
        this.messages = messages;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isAppointed() {
        return this.appointed;
    }

    public void setAppointed(boolean appointed) {
        this.appointed = appointed;
    }

    public boolean isRated() {
        return this.rated;
    }

    public void setRated(boolean rated) {
        this.rated = rated;
    }

    public String getCloseType() {
        return this.closeType;
    }

    public void setCloseType(String closeType) {
        this.closeType = closeType;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public Set<User> getTopSet() {
        return this.topSet;
    }

    public void setTopSet(Set<User> topSet) {
        this.topSet = topSet;
    }

    public Set<User> getDisturbSet() {
        return this.disturbSet;
    }

    public void setDisturbSet(Set<User> disturbSet) {
        this.disturbSet = disturbSet;
    }

    public Set<User> getUnreadSet() {
        return this.unreadSet;
    }

    public void setUnreadSet(Set<User> unreadSet) {
        this.unreadSet = unreadSet;
    }

    public Set<User> getDeletedSet() {
        return this.deletedSet;
    }

    public void setDeletedSet(Set<User> deletedSet) {
        this.deletedSet = deletedSet;
    }

    public boolean isTop(User user) {
        for (User user1 : this.topSet) {
            if (!user.getUid().equals(user1.getUid())) continue;
            return true;
        }
        return false;
    }

    public boolean isUnread(User user) {
        for (User user1 : this.unreadSet) {
            if (!user.getUid().equals(user1.getUid())) continue;
            return true;
        }
        return false;
    }

    public boolean isDeleted(User user) {
        for (User user1 : this.deletedSet) {
            if (!user.getUid().equals(user1.getUid())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Thread{id=" + this.id + ", tid='" + this.tid + '\'' + ", sessionId='" + this.sessionId + '\'' + ", queue=" + this.queue + ", content='" + this.content + '\'' + ", timestamp=" + this.timestamp + ", unreadCount='" + this.unreadCount + '\'' + ", closed=" + this.closed + ", visitor=" + this.visitor + ", workGroup=" + this.workGroup + ", startedAt=" + this.startedAt + ", closedAt=" + this.closedAt + '}';
    }
}

