/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.model.AuditModel;
import io.xiaper.jpa.model.Authority;
import io.xiaper.jpa.model.FingerPrint2;
import io.xiaper.jpa.model.Role;
import io.xiaper.jpa.model.Tag;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.WorkGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@SQLDelete(sql="UPDATE users SET is_deleted = true WHERE id = ?")
@Where(clause="is_deleted = false")
@Table(name="users")
@JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "fieldHandler"})
public class User
extends AuditModel
implements UserDetails {
    private static final long serialVersionUID = -7810168718373868640L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(name="uuid", unique=true)
    private String uid;
    @Column(name="num")
    private String num;
    @Column(name="username", unique=true, nullable=false)
    private String username;
    @Column(name="email")
    private String email;
    @JsonIgnore
    @Column(name="passwords")
    private String password;
    @Column(name="mobile")
    private String mobile;
    @Column(name="nickname")
    private String nickname;
    @Column(name="real_name")
    private String realName;
    @Column(name="avatar")
    private String avatar;
    @Column(name="company")
    private String company;
    @Column(name="sub_domain")
    private String subDomain;
    @Column(name="connection_status")
    private String connectionStatus;
    @Column(name="accept_status")
    private String acceptStatus;
    @Column(name="im_status")
    private String imStatus;
    @Column(name="client")
    private String client;
    @Column(name="is_enabled")
    private boolean enabled = true;
    @Column(name="is_robot")
    private boolean robot = false;
    @Column(name="welcome_tip")
    private String welcomeTip = "\u60a8\u597d\uff0c\u6709\u4ec0\u4e48\u53ef\u4ee5\u5e2e\u60a8\u7684?";
    @Column(name="device_token")
    private String deviceToken;
    @Column(name="is_auto_reply")
    private boolean autoReply = false;
    @Column(name="auto_reply_content")
    private String autoReplyContent = "\u65e0\u81ea\u52a8\u56de\u590d";
    @Column(name="description")
    private String description = "\u5168\u5fc3\u5168\u610f\u4e3a\u60a8\u670d\u52a1";
    @Column(name="max_thread_count")
    private int maxThreadCount = 10;
    @Column(name="is_deleted")
    private boolean deleted = false;
    @JsonIgnore
    @OneToMany(mappedBy="visitor")
    private Set<Thread> threads = new HashSet<Thread>();
    @OneToMany(mappedBy="visitor", fetch=FetchType.EAGER)
    @Where(clause=" my_key = 'os-name' or my_key = 'browser-name' ")
    private Set<FingerPrint2> fingerPrint2s = new HashSet<FingerPrint2>();
    @JsonIgnore
    @ManyToMany(mappedBy="users", fetch=FetchType.EAGER)
    private Set<WorkGroup> workGroups = new HashSet<WorkGroup>();
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="users_tag", joinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="tag_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<Tag> tags = new HashSet<Tag>();
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="users_follow", joinColumns={@JoinColumn(name="follow_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> fans = new HashSet<User>();
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="users_follow", joinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="follow_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> follows = new HashSet<User>();
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="users_robot", joinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="robot_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> robots = new HashSet<User>();
    @ManyToMany(cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinTable(name="users_role", joinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="role_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    @BatchSize(size=20)
    private Set<Role> roles = new HashSet<Role>();
    @ManyToMany(targetEntity=Authority.class, fetch=FetchType.EAGER)
    @JoinTable(name="users_authority", joinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="authority_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<Authority> userAuthorities = new HashSet<Authority>();
    @JsonIgnore
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User user;
    @JsonIgnore
    @Transient
    private Set<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();

    public User() {
    }

    public User(String uid) {
        this.uid = uid;
    }

    public User(User user) {
        this.id = user.getId();
        this.username = user.getUsername();
        this.password = user.getPassword();
        this.nickname = user.getNickname();
        this.email = user.getEmail();
        this.mobile = user.getMobile();
        this.avatar = user.getAvatar();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<String> authorities = new ArrayList<String>();
        ArrayList<Authority> collection = new ArrayList<Authority>();
        for (Role role : this.roles) {
            collection.addAll(role.getAuthorities());
        }
        for (Authority item : collection) {
            authorities.add(item.getName());
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (String authority : authorities) {
            grantedAuthorities.add(new SimpleGrantedAuthority(authority));
        }
        return grantedAuthorities;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Set<User> getFans() {
        return this.fans;
    }

    public void setFans(Set<User> fans) {
        this.fans = fans;
    }

    public Set<User> getFollows() {
        return this.follows;
    }

    public void setFollows(Set<User> follows) {
        this.follows = follows;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setAuthorities(Set<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public String getSubDomain() {
        return this.subDomain;
    }

    public void setSubDomain(String subDomain) {
        this.subDomain = subDomain;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Set<WorkGroup> getWorkGroups() {
        return this.workGroups;
    }

    public void setWorkGroups(Set<WorkGroup> workGroups) {
        this.workGroups = workGroups;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public String getAcceptStatus() {
        return this.acceptStatus;
    }

    public void setAcceptStatus(String acceptStatus) {
        this.acceptStatus = acceptStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Thread> getThreads() {
        return this.threads;
    }

    public void setThreads(Set<Thread> threads) {
        this.threads = threads;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Set<Authority> getUserAuthorities() {
        return this.userAuthorities;
    }

    public void setUserAuthorities(Set<Authority> userAuthorities) {
        this.userAuthorities = userAuthorities;
    }

    public Set<FingerPrint2> getFingerPrint2s() {
        return this.fingerPrint2s;
    }

    public void setFingerPrint2s(Set<FingerPrint2> fingerPrint2s) {
        this.fingerPrint2s = fingerPrint2s;
    }

    public Set<User> getRobots() {
        return this.robots;
    }

    public void setRobots(Set<User> robots) {
        this.robots = robots;
    }

    public boolean isRobot() {
        return this.robot;
    }

    public void setRobot(boolean robot) {
        this.robot = robot;
    }

    public String getWelcomeTip() {
        return this.welcomeTip;
    }

    public void setWelcomeTip(String welcomeTip) {
        this.welcomeTip = welcomeTip;
    }

    public boolean isAutoReply() {
        return this.autoReply;
    }

    public void setAutoReply(boolean autoReply) {
        this.autoReply = autoReply;
    }

    public String getAutoReplyContent() {
        return this.autoReplyContent;
    }

    public void setAutoReplyContent(String autoReplyContent) {
        this.autoReplyContent = autoReplyContent;
    }

    public String getImStatus() {
        return this.imStatus;
    }

    public void setImStatus(String imStatus) {
        this.imStatus = imStatus;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.uid == null || o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.uid.equals(user.uid);
    }

    public int hashCode() {
        return Objects.hash(this.uid);
    }

    public WorkGroup defaultWorkGroup() {
        for (WorkGroup workGroup : this.workGroups) {
            if (!workGroup.isDefaulted()) continue;
            return workGroup;
        }
        return null;
    }

    public boolean isSuper() {
        if (this.roles == null) {
            return false;
        }
        for (Role role : this.roles) {
            if (!role.getValue().equals("ROLE_SUPER")) continue;
            return true;
        }
        return false;
    }

    public boolean isAdmin() {
        if (this.roles == null) {
            return false;
        }
        for (Role role : this.roles) {
            if (!role.getValue().equals("ROLE_ADMIN") && !role.getValue().equals("ROLE_SUPER")) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkGroupAdmin() {
        if (this.workGroups == null) {
            return false;
        }
        for (WorkGroup workGroup : this.workGroups) {
            if (workGroup.getAdmin() == null || !workGroup.getAdmin().getUid().equals(this.getUid())) continue;
            return true;
        }
        return false;
    }

    public boolean isAgent() {
        if (this.roles == null) {
            return false;
        }
        for (Role role : this.roles) {
            if (!role.getValue().equals("ROLE_WORKGROUP_AGENT")) continue;
            return true;
        }
        return false;
    }

    public boolean isVisitor() {
        if (this.roles == null) {
            return false;
        }
        for (Role role : this.roles) {
            if (!role.getValue().equals("ROLE_VISITOR")) continue;
            return true;
        }
        return false;
    }

    public boolean isWeChatMp() {
        return this.client != null && this.client.equals(ClientConsts.CLIENT_WECHAT_MP);
    }

    public boolean isWeChatMini() {
        return this.client != null && this.client.equals(ClientConsts.CLIENT_WECHAT_MINI);
    }

    public boolean isAvailable() {
        if (this.connectionStatus == null || this.acceptStatus == null) {
            return false;
        }
        return this.connectionStatus.equals("connected") && this.acceptStatus.equals("online");
    }

    @JsonIgnore
    public User getAdmin() {
        if (this.user != null) {
            return this.user;
        }
        return this;
    }

    @JsonIgnore
    public User getRoBotUser() {
        if (this.robots.size() > 0) {
            return (User)this.robots.toArray()[0];
        }
        return null;
    }
}

