/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.xiaper.jpa.model.App;
import io.xiaper.jpa.model.AuditModel;
import io.xiaper.jpa.model.Company;
import io.xiaper.jpa.model.Questionnaire;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="workgroup")
@JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "fieldHandler"})
public class WorkGroup
extends AuditModel {
    private static final long serialVersionUID = 733054358991055193L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Long id;
    @Column(name="wid", unique=true, nullable=false)
    private String wid;
    @Column(name="nickname")
    private String nickname;
    @Column(name="avatar")
    private String avatar = "https://chainsnow.oss-cn-shenzhen.aliyuncs.com/avatars/workgroup_default_avatar.png";
    @Column(name="is_default_robot")
    private boolean defaultRobot = false;
    @Column(name="is_offline_robot")
    private boolean offlineRobot = false;
    @Lob
    @Column(name="slogan")
    private String slogan = "\u5168\u5fc3\u5168\u610f\u4e3a\u60a8\u670d\u52a1";
    @Column(name="welcome_tip")
    private String welcomeTip = "\u60a8\u597d\uff0c\u8bf7\u7a0d\u5019\uff0c\u5ba2\u670d\u5c06\u5f88\u5feb\u4e3a\u60a8\u670d\u52a1";
    @Column(name="accept_tip")
    private String acceptTip = "\u60a8\u597d\uff0c\u6709\u4ec0\u4e48\u53ef\u4ee5\u5e2e\u60a8\u7684\uff1f";
    @Column(name="non_working_time_tip")
    private String nonWorkingTimeTip = "\u5f53\u524d\u975e\u5de5\u4f5c\u65f6\u95f4\uff0c\u8bf7\u81ea\u52a9\u67e5\u8be2\u6216\u7559\u8a00";
    @Column(name="offline_tip")
    private String offlineTip = "\u5f53\u524d\u65e0\u5ba2\u670d\u5728\u7ebf\uff0c\u8bf7\u81ea\u52a9\u67e5\u8be2\u6216\u7559\u8a00";
    @Column(name="close_tip")
    private String closeTip = "\u5ba2\u670d\u5173\u95ed\u4f1a\u8bdd";
    @Column(name="auto_close_tip")
    private String autoCloseTip = "\u957f\u65f6\u95f4\u6ca1\u6709\u5bf9\u8bdd\uff0c\u7cfb\u7edf\u81ea\u52a8\u5173\u95ed\u4f1a\u8bdd";
    @Column(name="is_force_rate")
    private boolean forceRate = false;
    @Column(name="route_type")
    private String routeType = "robin";
    @Column(name="is_default")
    private boolean defaulted = false;
    @Column(name="is_department")
    private boolean department = false;
    @Column(name="is_auto_pop")
    private boolean autoPop = false;
    @Column(name="pop_after_time_length")
    private int popAfterTimeLength = 10;
    @Column(name="max_queue_count")
    private int maxQueueCount = 10;
    @Column(name="max_queue_count_exceed_tip")
    private String maxQueueCountExceedTip = "\u4eba\u5de5\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
    @Column(name="max_queue_second")
    private int maxQueueSecond = 60;
    @Column(name="max_queue_second_exceed_tip")
    private String maxQueueSecondExceedTip = "\u5f88\u62b1\u6b49\uff0c\u76ee\u524d\u4eba\u5de5\u670d\u52a1\u5168\u5fd9\uff0c\u5c0fM\u5c3d\u5feb\u4e3a\u60a8\u8f6c\u63a5\u3002\u5982\u9700\u81ea\u52a9\u670d\u52a1\u8bf7\u56de\u590d\u5e8f\u53f7\uff0c\u9000\u51fa\u6392\u961f\u540e\u7ee7\u7eed\u5411\u5c0fM\u63d0\u95ee\uff1a[1]\u7ee7\u7eed\u7b49\u5f85 [2]\u9000\u51fa\u6392\u961f";
    @Column(name="about")
    private String about = "\u5173\u4e8e\u6211\u4eec";
    @Column(name="description")
    private String description = "\u8fd9\u662f\u4e00\u4e2a\u9ed8\u8ba4\u5de5\u4f5c\u7ec4\uff0c\u7cfb\u7edf\u81ea\u52a8\u751f\u6210";
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="questionnaire_id")
    private Questionnaire questionnaire;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="on_duty_workgroup_id")
    private WorkGroup onDutyWorkGroup;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="company_id")
    private Company company;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="workgroup_app", joinColumns={@JoinColumn(name="workgroup_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="app_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<App> apps = new HashSet<App>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="workgroup_worktime", joinColumns={@JoinColumn(name="workgroup_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="worktime_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<WorkTime> workTimes = new HashSet<WorkTime>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="workgroup_users", joinColumns={@JoinColumn(name="workgroup_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))}, inverseJoinColumns={@JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))})
    private Set<User> users = new HashSet<User>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="admin_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User admin;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="users_id", foreignKey=@ForeignKey(name="none", value=ConstraintMode.NO_CONSTRAINT))
    private User user;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Set<WorkTime> getWorkTimes() {
        return this.workTimes;
    }

    public void setWorkTimes(Set<WorkTime> workTimes) {
        this.workTimes = workTimes;
    }

    public boolean isDefaultRobot() {
        return this.defaultRobot;
    }

    public void setDefaultRobot(boolean defaultRobot) {
        this.defaultRobot = defaultRobot;
    }

    public boolean isOfflineRobot() {
        return this.offlineRobot;
    }

    public void setOfflineRobot(boolean offlineRobot) {
        this.offlineRobot = offlineRobot;
    }

    public String getWelcomeTip() {
        return this.welcomeTip;
    }

    public void setWelcomeTip(String welcomeTip) {
        this.welcomeTip = welcomeTip;
    }

    public String getAcceptTip() {
        return this.acceptTip;
    }

    public void setAcceptTip(String acceptTip) {
        this.acceptTip = acceptTip;
    }

    public String getOfflineTip() {
        return this.offlineTip;
    }

    public void setOfflineTip(String offlineTip) {
        this.offlineTip = offlineTip;
    }

    public boolean isForceRate() {
        return this.forceRate;
    }

    public void setForceRate(boolean forceRate) {
        this.forceRate = forceRate;
    }

    public String getRouteType() {
        return this.routeType;
    }

    public void setRouteType(String routeType) {
        this.routeType = routeType;
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public void setDefaulted(boolean defaulted) {
        this.defaulted = defaulted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<App> getApps() {
        return this.apps;
    }

    public void setApps(Set<App> apps) {
        this.apps = apps;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public String getWid() {
        return this.wid;
    }

    public void setWid(String wid) {
        this.wid = wid;
    }

    public String getNonWorkingTimeTip() {
        return this.nonWorkingTimeTip;
    }

    public void setNonWorkingTimeTip(String nonWorkingTimeTip) {
        this.nonWorkingTimeTip = nonWorkingTimeTip;
    }

    public boolean isDepartment() {
        return this.department;
    }

    public void setDepartment(boolean department) {
        this.department = department;
    }

    public String getSlogan() {
        return this.slogan;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public WorkGroup getOnDutyWorkGroup() {
        return this.onDutyWorkGroup;
    }

    public void setOnDutyWorkGroup(WorkGroup onDutyWorkGroup) {
        this.onDutyWorkGroup = onDutyWorkGroup;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    public boolean isAutoPop() {
        return this.autoPop;
    }

    public void setAutoPop(boolean autoPop) {
        this.autoPop = autoPop;
    }

    public int getPopAfterTimeLength() {
        return this.popAfterTimeLength;
    }

    public void setPopAfterTimeLength(int popAfterTimeLength) {
        this.popAfterTimeLength = popAfterTimeLength;
    }

    public String getCloseTip() {
        return this.closeTip;
    }

    public void setCloseTip(String closeTip) {
        this.closeTip = closeTip;
    }

    public String getAutoCloseTip() {
        return this.autoCloseTip;
    }

    public void setAutoCloseTip(String autoCloseTip) {
        this.autoCloseTip = autoCloseTip;
    }

    public User getAdmin() {
        return this.admin;
    }

    public void setAdmin(User admin) {
        this.admin = admin;
    }

    public int getMaxQueueCount() {
        return this.maxQueueCount;
    }

    public void setMaxQueueCount(int maxQueueCount) {
        this.maxQueueCount = maxQueueCount;
    }

    public String getMaxQueueCountExceedTip() {
        return this.maxQueueCountExceedTip;
    }

    public void setMaxQueueCountExceedTip(String maxQueueCountExceedTip) {
        this.maxQueueCountExceedTip = maxQueueCountExceedTip;
    }

    public int getMaxQueueSecond() {
        return this.maxQueueSecond;
    }

    public void setMaxQueueSecond(int maxQueueSecond) {
        this.maxQueueSecond = maxQueueSecond;
    }

    public String getMaxQueueSecondExceedTip() {
        return this.maxQueueSecondExceedTip;
    }

    public void setMaxQueueSecondExceedTip(String maxQueueSecondExceedTip) {
        this.maxQueueSecondExceedTip = maxQueueSecondExceedTip;
    }

    public boolean isQuestionnaire() {
        return this.questionnaire != null;
    }

    public boolean isWorkTime() {
        for (WorkTime workTime : this.workTimes) {
            if (!workTime.isWorkTime()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.wid == null || o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkGroup workGroup = (WorkGroup)o;
        return this.wid.equals(workGroup.getWid());
    }

    public int hashCode() {
        return Objects.hash(this.wid);
    }
}

