/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.xiaper.jpa.model.AuditModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="work_time")
public class WorkTime
extends AuditModel {
    private static final long serialVersionUID = 6998065367142353284L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Long id;
    @Column(name="start_time")
    @JsonFormat(pattern="HH:mm:ss", timezone="GMT+8")
    @Temporal(value=TemporalType.TIME)
    private Date startTime;
    @Column(name="end_time")
    @JsonFormat(pattern="HH:mm:ss", timezone="GMT+8")
    @Temporal(value=TemporalType.TIME)
    private Date endTime;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean isWorkTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String timeString = formatter.format(new Date());
        Date now = null;
        try {
            now = formatter.parse(timeString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendarNow = Calendar.getInstance();
        calendarNow.setTime(now);
        calendarNow.set(0, 0, 0);
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(this.startTime);
        calendarStart.set(0, 0, 0);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(this.endTime);
        calendarEnd.set(0, 0, 0);
        boolean result1 = calendarNow.getTime().after(calendarStart.getTime());
        boolean result2 = calendarNow.getTime().before(calendarEnd.getTime());
        return result1 && result2;
    }
}

