/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.util.id;

import io.xiaper.jpa.util.id.DefaultIdGeneratorConfig;
import io.xiaper.jpa.util.id.IdGenerator;
import io.xiaper.jpa.util.id.IdGeneratorConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultIdGenerator
implements IdGenerator,
Runnable {
    private String time;
    private AtomicInteger value;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private IdGeneratorConfig config;
    private Thread thread;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public DefaultIdGenerator() {
        this.config = new DefaultIdGeneratorConfig();
        this.time = LocalDateTime.now().format(FORMATTER);
        this.value = new AtomicInteger(this.config.getInitial());
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public DefaultIdGenerator(IdGeneratorConfig config) {
        this.config = config;
        this.time = LocalDateTime.now().format(FORMATTER);
        this.value = new AtomicInteger(config.getInitial());
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public String next() {
        this.lock.readLock().lock();
        StringBuffer sb = new StringBuffer(this.config.getPrefix()).append(this.config.getSplitString()).append(this.time).append(this.config.getSplitString()).append(this.value.getAndIncrement());
        this.lock.readLock().unlock();
        return sb.toString();
    }

    @Override
    public void run() {
        while (true) {
            String now;
            try {
                Thread.sleep(1000 * this.config.getRollingInterval());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((now = LocalDateTime.now().format(FORMATTER)).equals(this.time)) continue;
            this.lock.writeLock().lock();
            this.time = now;
            this.value.set(this.config.getInitial());
            this.lock.writeLock().unlock();
        }
    }
}

