/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.jpa.util.ip;

import io.xiaper.jpa.util.ip.IPZone;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;

public class QQWry {
    private static final int INDEX_RECORD_LENGTH = 7;
    private static final byte REDIRECT_MODE_1 = 1;
    private static final byte REDIRECT_MODE_2 = 2;
    private static final byte STRING_END = 0;
    private final byte[] data;
    private final long indexHead;
    private final long indexTail;

    public QQWry() throws IOException {
        int r;
        InputStream in = QQWry.class.getClassLoader().getResourceAsStream("qqwry.dat");
        ByteArrayOutputStream out = new ByteArrayOutputStream(0xA00000);
        byte[] buffer = new byte[4096];
        while ((r = in.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        this.data = out.toByteArray();
        this.indexHead = this.readLong32(0);
        this.indexTail = this.readLong32(4);
    }

    public QQWry(byte[] data) {
        this.data = data;
        this.indexHead = this.readLong32(0);
        this.indexTail = this.readLong32(4);
    }

    public QQWry(Path file) throws IOException {
        this(Files.readAllBytes(file));
    }

    public IPZone findIP(String ip) {
        long ipNum = this.toNumericIP(ip);
        QIndex idx = this.searchIndex(ipNum);
        if (idx == null) {
            return new IPZone(ip);
        }
        return this.readIP(ip, idx);
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private QIndex readIndex(int offset) {
        long min = this.readLong32(offset);
        int record = this.readInt24(offset + 4);
        long max = this.readLong32(record);
        return new QIndex(min, max, record);
    }

    private int readInt24(int offset) {
        int v = this.data[offset] & 0xFF;
        v |= this.data[offset + 1] << 8 & 0xFF00;
        return v |= this.data[offset + 2] << 16 & 0xFF0000;
    }

    private IPZone readIP(String ip, QIndex idx) {
        int pos = idx.recordOffset + 4;
        byte mode = this.data[pos];
        IPZone z = new IPZone(ip);
        if (mode == 1) {
            int offset = this.readInt24(pos + 1);
            if (this.data[offset] == 2) {
                this.readMode2(z, offset);
            } else {
                QString mainInfo = this.readString(offset);
                String subInfo = this.readSubInfo(offset + mainInfo.length);
                z.setMainInfo(mainInfo.string);
                z.setSubInfo(subInfo);
            }
        } else if (mode == 2) {
            this.readMode2(z, pos);
        } else {
            QString mainInfo = this.readString(pos);
            String subInfo = this.readSubInfo(pos + mainInfo.length);
            z.setMainInfo(mainInfo.string);
            z.setSubInfo(subInfo);
        }
        return z;
    }

    private long readLong32(int offset) {
        long v = (long)this.data[offset] & 0xFFL;
        v |= (long)(this.data[offset + 1] << 8) & 0xFF00L;
        v |= (long)(this.data[offset + 2] << 16) & 0xFF0000L;
        return v |= (long)(this.data[offset + 3] << 24) & 0xFF000000L;
    }

    private void readMode2(IPZone z, int offset) {
        int mainInfoOffset = this.readInt24(offset + 1);
        String main = this.readString((int)mainInfoOffset).string;
        String sub = this.readSubInfo(offset + 4);
        z.setMainInfo(main);
        z.setSubInfo(sub);
    }

    private QString readString(int offset) {
        byte b;
        int i = 0;
        byte[] buf = new byte[128];
        while (0 != (b = this.data[offset + i])) {
            buf[i] = b;
            ++i;
        }
        try {
            return new QString(new String(buf, 0, i, "GB18030"), i + 1);
        }
        catch (UnsupportedEncodingException e) {
            return new QString("", 0);
        }
    }

    private String readSubInfo(int offset) {
        byte b = this.data[offset];
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt24(offset + 1);
            if (areaOffset == 0) {
                return "";
            }
            return this.readString((int)areaOffset).string;
        }
        return this.readString((int)offset).string;
    }

    private QIndex searchIndex(long ip) {
        long head = this.indexHead;
        long tail = this.indexTail;
        while (tail > head) {
            long cur = this.getMiddleOffset(head, tail);
            QIndex idx = this.readIndex((int)cur);
            if (ip >= idx.minIP && ip <= idx.maxIP) {
                return idx;
            }
            if (cur == head || cur == tail) {
                return idx;
            }
            if (ip < idx.minIP) {
                tail = cur;
                continue;
            }
            if (ip > idx.maxIP) {
                head = cur;
                continue;
            }
            return idx;
        }
        return null;
    }

    private long toNumericIP(String s) {
        String[] parts = s.split("\\.");
        if (parts.length != 4) {
            throw new IllegalArgumentException("ip=" + s);
        }
        long n = Long.parseLong(parts[0]) << 24;
        n += Long.parseLong(parts[1]) << 16;
        n += Long.parseLong(parts[2]) << 8;
        return n += Long.parseLong(parts[3]);
    }

    private static class QString {
        public final String string;
        public final int length;

        public QString(String string, int length) {
            this.string = string;
            this.length = length;
        }
    }

    private static class QIndex {
        public final long minIP;
        public final long maxIP;
        public final int recordOffset;

        public QIndex(long minIP, long maxIP, int recordOffset) {
            this.minIP = minIP;
            this.maxIP = maxIP;
            this.recordOffset = recordOffset;
        }
    }
}

