/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.tokenization.EDIFACTDialect;
import io.xlate.edi.internal.stream.tokenization.X12Dialect;

public interface DialectFactory {
    public static Dialect getDialect(char[] buffer, int start, int length) throws EDIException {
        String tag = new String(buffer, start, length);
        return DialectFactory.getDialect(tag);
    }

    public static Dialect getDialect(String tag) throws EDIException {
        DialectTag type = DialectTag.fromValue(tag);
        if (type != null) {
            Dialect dialect = type == DialectTag.X12 ? new X12Dialect() : new EDIFACTDialect();
            dialect.setHeaderTag(tag);
            return dialect;
        }
        throw new EDIException(EDIException.UNSUPPORTED_DIALECT, tag);
    }

    public static enum DialectTag {
        X12("ISA"),
        EDIFACT_A("UNA"),
        EDIFACT_B("UNB");

        private String tag;

        private DialectTag(String tag) {
            this.tag = tag;
        }

        public static DialectTag fromValue(String tag) {
            for (DialectTag d : DialectTag.values()) {
                if (!d.tag.equals(tag)) continue;
                return d;
            }
            return null;
        }
    }
}

