/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EventHandler;
import io.xlate.edi.internal.stream.tokenization.StreamEvent;
import io.xlate.edi.internal.stream.validation.UsageError;
import io.xlate.edi.internal.stream.validation.Validator;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ProxyEventHandler
implements EventHandler {
    private final StaEDIStreamLocation location;
    private Schema controlSchema;
    private Validator controlValidator;
    private Schema transactionSchema;
    private Validator transactionValidator;
    private boolean transactionSchemaAllowed = false;
    private boolean transaction = false;
    private InputStream binary;
    private String segmentTag;
    private CharArraySequence elementHolder = new CharArraySequence();
    private StreamEvent[] events = new StreamEvent[99];
    private int eventCount = 0;
    private int eventIndex = 0;
    private Dialect dialect;

    public ProxyEventHandler(StaEDIStreamLocation location, Schema controlSchema) {
        this.location = location;
        this.setControlSchema(controlSchema, true);
        for (int i = 0; i < 99; ++i) {
            this.events[i] = new StreamEvent();
        }
    }

    public void setControlSchema(Schema controlSchema, boolean validateCodeValues) {
        if (this.controlValidator != null) {
            throw new IllegalStateException("control validator already created");
        }
        this.controlSchema = controlSchema;
        this.controlValidator = controlSchema != null ? new Validator(controlSchema, validateCodeValues, null) : null;
    }

    public boolean isTransactionSchemaAllowed() {
        return this.transactionSchemaAllowed;
    }

    public Schema getTransactionSchema() {
        return this.transactionSchema;
    }

    public void setTransactionSchema(Schema transactionSchema) {
        if (!Objects.equals(this.transactionSchema, transactionSchema)) {
            this.transactionSchema = transactionSchema;
            this.transactionValidator = transactionSchema != null ? new Validator(transactionSchema, true, this.controlSchema) : null;
        }
    }

    public void resetEvents() {
        this.eventCount = 0;
        this.eventIndex = 0;
    }

    public EDIStreamEvent getEvent() {
        if (this.hasEvents()) {
            return this.events[this.eventIndex].type;
        }
        return null;
    }

    public CharBuffer getCharacters() {
        if (this.hasEvents()) {
            return this.events[this.eventIndex].getData();
        }
        throw new IllegalStateException();
    }

    public boolean hasEvents() {
        return this.eventIndex < this.eventCount;
    }

    public boolean nextEvent() {
        if (this.eventCount < 1) {
            return false;
        }
        return ++this.eventIndex < this.eventCount;
    }

    public EDIStreamValidationError getErrorType() {
        return this.events[this.eventIndex].errorType;
    }

    public String getReferenceCode() {
        return this.hasEvents() ? this.events[this.eventIndex].getReferenceCode() : null;
    }

    public Location getLocation() {
        if (this.hasEvents() && this.events[this.eventIndex].location != null) {
            return this.events[this.eventIndex].location;
        }
        return this.location;
    }

    public InputStream getBinary() {
        return this.binary;
    }

    public void setBinary(InputStream binary) {
        this.binary = binary;
    }

    public EDIReference getSchemaTypeReference() {
        return this.hasEvents() ? this.events[this.eventIndex].getTypeReference() : null;
    }

    @Override
    public void interchangeBegin(Dialect dialect) {
        this.dialect = dialect;
        this.enqueueEvent(EDIStreamEvent.START_INTERCHANGE, EDIStreamValidationError.NONE, "", null, this.location);
    }

    @Override
    public void interchangeEnd() {
        Validator validator = this.validator();
        if (validator != null) {
            validator.validateLoopSyntax(this);
        }
        this.enqueueEvent(EDIStreamEvent.END_INTERCHANGE, EDIStreamValidationError.NONE, "", null, this.location);
    }

    @Override
    public void loopBegin(EDIReference typeReference) {
        String loopCode = typeReference.getReferencedType().getCode();
        if (EDIType.Type.TRANSACTION.toString().equals(loopCode)) {
            this.transaction = true;
            this.transactionSchemaAllowed = true;
            this.enqueueEvent(EDIStreamEvent.START_TRANSACTION, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
            if (this.transactionValidator != null) {
                this.transactionValidator.reset();
            }
        } else if (EDIType.Type.GROUP.toString().equals(loopCode)) {
            this.enqueueEvent(EDIStreamEvent.START_GROUP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        } else {
            this.enqueueEvent(EDIStreamEvent.START_LOOP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        }
    }

    @Override
    public void loopEnd(EDIReference typeReference) {
        String loopCode = typeReference.getReferencedType().getCode();
        this.validator().validateLoopSyntax(this);
        if (EDIType.Type.TRANSACTION.toString().equals(loopCode)) {
            this.transaction = false;
            this.dialect.transactionEnd();
            this.enqueueEvent(EDIStreamEvent.END_TRANSACTION, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        } else if (EDIType.Type.GROUP.toString().equals(loopCode)) {
            this.dialect.groupEnd();
            this.enqueueEvent(EDIStreamEvent.END_GROUP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        } else {
            this.enqueueEvent(EDIStreamEvent.END_LOOP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        }
    }

    @Override
    public boolean segmentBegin(String segmentTag) {
        this.segmentTag = segmentTag;
        this.transactionSchemaAllowed = false;
        Validator validator = this.validator();
        boolean eventsReady = true;
        EDIReference typeReference = null;
        if (validator != null && !this.dialect.isServiceAdviceSegment(segmentTag)) {
            validator.validateSegment(this, segmentTag);
            typeReference = validator.getSegmentReferenceCode();
            boolean bl = eventsReady = !validator.isPendingDiscrimination();
        }
        if (this.exitTransaction(segmentTag)) {
            if (validator != null) {
                validator.validateLoopSyntax(this);
            }
            this.transaction = false;
            validator = this.validator();
            validator.validateSegment(this, segmentTag);
            typeReference = this.validator().getSegmentReferenceCode();
        }
        this.enqueueEvent(EDIStreamEvent.START_SEGMENT, EDIStreamValidationError.NONE, segmentTag, typeReference, this.location);
        return eventsReady;
    }

    boolean exitTransaction(CharSequence tag) {
        return this.transaction && !this.transactionSchemaAllowed && this.controlSchema != null && this.controlSchema.containsSegment(tag.toString());
    }

    @Override
    public boolean segmentEnd() {
        Validator validator = this.validator();
        EDIReference typeReference = null;
        if (validator != null) {
            validator.validateSyntax(this.dialect, this, this, this.location, false);
            validator.validateVersionConstraints(this.dialect, this);
            typeReference = validator.getSegmentReferenceCode();
        }
        this.location.clearSegmentLocations();
        this.enqueueEvent(EDIStreamEvent.END_SEGMENT, EDIStreamValidationError.NONE, this.segmentTag, typeReference, this.location);
        return true;
    }

    @Override
    public boolean compositeBegin(boolean isNil) {
        EDIReference typeReference = null;
        boolean eventsReady = true;
        if (this.validator() != null && !isNil) {
            boolean invalid;
            boolean bl = invalid = !this.validator().validCompositeOccurrences(this.dialect, this.location);
            if (invalid) {
                typeReference = this.validator().getElementReference();
                List<UsageError> errors = this.validator().getElementErrors();
                for (UsageError error : errors) {
                    this.enqueueEvent(error.getError().getCategory(), error.getError(), "", error.getTypeReference(), this.location);
                }
            } else {
                typeReference = this.validator().getCompositeReference();
            }
            eventsReady = !this.validator().isPendingDiscrimination();
        }
        this.enqueueEvent(EDIStreamEvent.START_COMPOSITE, EDIStreamValidationError.NONE, "", typeReference, this.location);
        return eventsReady;
    }

    @Override
    public boolean compositeEnd(boolean isNil) {
        boolean eventsReady = true;
        if (this.validator() != null && !isNil) {
            this.validator().validateSyntax(this.dialect, this, this, this.location, true);
            eventsReady = !this.validator().isPendingDiscrimination();
        }
        this.location.clearComponentPosition();
        this.enqueueEvent(EDIStreamEvent.END_COMPOSITE, EDIStreamValidationError.NONE, "", null, this.location);
        return eventsReady;
    }

    @Override
    public boolean elementData(char[] text, int start, int length) {
        EDIReference typeReference;
        boolean derivedComposite;
        boolean eventsReady = true;
        this.elementHolder.set(text, start, length);
        this.dialect.elementData(this.elementHolder, this.location);
        Validator validator = this.validator();
        if (validator != null) {
            derivedComposite = this.validateElement(validator);
            typeReference = validator.getElementReference();
        } else {
            derivedComposite = false;
            typeReference = null;
        }
        if (!(text == null || derivedComposite && length <= 0)) {
            this.enqueueEvent(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.NONE, this.elementHolder, typeReference, this.location);
            if (validator != null && validator.isPendingDiscrimination()) {
                eventsReady = validator.selectImplementation(this.events, this.eventIndex, this.eventCount, this);
            }
        }
        if (derivedComposite && text != null) {
            this.compositeEnd(length == 0);
            this.location.clearComponentPosition();
        }
        return eventsReady;
    }

    boolean validateElement(Validator validator) {
        List<UsageError> errors;
        boolean derivedComposite;
        boolean composite = this.location.getComponentPosition() > -1;
        boolean valid = validator.validateElement(this.dialect, this.location, this.elementHolder);
        boolean bl = derivedComposite = !composite && validator.isComposite();
        if (!valid) {
            errors = validator.getElementErrors();
            Iterator<UsageError> cursor = errors.iterator();
            while (cursor.hasNext()) {
                UsageError error = cursor.next();
                switch (error.getError()) {
                    case TOO_MANY_DATA_ELEMENTS: 
                    case TOO_MANY_REPETITIONS: {
                        this.enqueueEvent(error.getError().getCategory(), error.getError(), this.elementHolder, error.getTypeReference(), this.location);
                        cursor.remove();
                    }
                }
            }
        }
        if (derivedComposite && this.elementHolder.getText() != null) {
            this.compositeBegin(this.elementHolder.length() == 0);
            this.location.incrementComponentPosition();
        }
        if (!valid) {
            errors = validator.getElementErrors();
            for (UsageError error : errors) {
                this.enqueueEvent(error.getError().getCategory(), error.getError(), this.elementHolder, error.getTypeReference(), this.location);
            }
        }
        return derivedComposite;
    }

    public boolean isBinaryElementLength() {
        return this.validator() != null && this.validator().isBinaryElementLength();
    }

    @Override
    public boolean binaryData(InputStream binaryStream) {
        this.enqueueEvent(EDIStreamEvent.ELEMENT_DATA_BINARY, EDIStreamValidationError.NONE, "", null, this.location);
        this.setBinary(binaryStream);
        return true;
    }

    @Override
    public void segmentError(CharSequence token, EDIReference typeReference, EDIStreamValidationError error) {
        this.enqueueEvent(EDIStreamEvent.SEGMENT_ERROR, error, token, typeReference, this.location);
    }

    @Override
    public void elementError(EDIStreamEvent event, EDIStreamValidationError error, EDIReference typeReference, CharSequence data, int element, int component, int repetition) {
        StaEDIStreamLocation copy = this.location.copy();
        copy.setElementPosition(element);
        copy.setElementOccurrence(repetition);
        copy.setComponentPosition(component);
        this.enqueueEvent(event, error, data, typeReference, copy);
    }

    private Validator validator() {
        return this.transaction && !this.transactionSchemaAllowed ? this.transactionValidator : this.controlValidator;
    }

    private void enqueueEvent(EDIStreamEvent event, EDIStreamValidationError error, CharSequence data, EDIReference typeReference, Location location) {
        EDIStreamEvent associatedEvent;
        int index = this.eventCount;
        StreamEvent target = this.events[index];
        EDIStreamEvent eDIStreamEvent = associatedEvent = index > 0 ? ProxyEventHandler.getAssociatedEvent(error) : null;
        if (this.eventExists(associatedEvent, index)) {
            int offset = index;
            boolean complete = false;
            while (!complete) {
                if (this.events[offset - 1].type == associatedEvent) {
                    complete = true;
                    continue;
                }
                this.events[offset] = this.events[offset - 1];
                --offset;
            }
            this.events[offset] = target;
        }
        target.type = event;
        target.errorType = error;
        target.setData(data);
        target.setTypeReference(typeReference);
        target.setLocation(location);
        ++this.eventCount;
    }

    private boolean eventExists(EDIStreamEvent associatedEvent, int index) {
        for (int offset = index; associatedEvent != null && offset > 0; --offset) {
            if (this.events[offset - 1].type != associatedEvent) continue;
            return true;
        }
        return false;
    }

    private static EDIStreamEvent getAssociatedEvent(EDIStreamValidationError error) {
        EDIStreamEvent event;
        switch (error) {
            case IMPLEMENTATION_LOOP_OCCURS_UNDER_MINIMUM_TIMES: {
                event = EDIStreamEvent.END_LOOP;
                break;
            }
            case MANDATORY_SEGMENT_MISSING: 
            case IMPLEMENTATION_SEGMENT_BELOW_MINIMUM_USE: {
                event = null;
                break;
            }
            default: {
                event = null;
            }
        }
        return event;
    }
}

