/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.VersionedProperty;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class Reference
implements EDIReference {
    private static final String TOSTRING_FORMAT = "refId: %s, minOccurs: %d, maxOccurs: %d, type: { %s }";
    private String refId;
    private String refTag;
    private EDIType referencedType;
    final int minOccurs;
    final int maxOccurs;
    final List<Version> versions;
    private final String title;
    private final String description;

    Reference(String refId, String refTag, int minOccurs, int maxOccurs, List<Version> versions, String title, String description) {
        this.refId = refId;
        this.refTag = refTag;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.versions = Collections.unmodifiableList(new ArrayList<Version>(versions));
        this.title = title;
        this.description = description;
    }

    Reference(String refId, String refTag, int minOccurs, int maxOccurs, String title, String description) {
        this(refId, refTag, minOccurs, maxOccurs, Collections.emptyList(), title, description);
    }

    Reference(EDIType referencedType, int minOccurs, int maxOccurs) {
        this.referencedType = referencedType;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.versions = Collections.emptyList();
        this.title = null;
        this.description = null;
    }

    <T> T getVersionAttribute(String version, BiFunction<Version, Reference, T> versionedSupplier, Supplier<T> defaultSupplier) {
        for (Version ver : this.versions) {
            if (!ver.appliesTo(version)) continue;
            return versionedSupplier.apply(ver, this);
        }
        return defaultSupplier.get();
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, this.refId, this.minOccurs, this.maxOccurs, this.referencedType);
    }

    String getRefId() {
        return this.refId;
    }

    String getRefTag() {
        return this.refTag;
    }

    @Override
    public EDIType getReferencedType() {
        return this.referencedType;
    }

    void setReferencedType(EDIType referencedType) {
        this.referencedType = referencedType;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public boolean hasVersions() {
        return !this.versions.isEmpty();
    }

    @Override
    public int getMinOccurs(String version) {
        return this.getVersionAttribute(version, Version::getMinOccurs, this::getMinOccurs);
    }

    @Override
    public int getMaxOccurs(String version) {
        return this.getVersionAttribute(version, Version::getMaxOccurs, this::getMaxOccurs);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static class Version
    extends VersionedProperty {
        final Integer minOccurs;
        final Integer maxOccurs;

        Version(String minVersion, String maxVersion, Integer minOccurs, Integer maxOccurs) {
            super(minVersion, maxVersion);
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }

        public int getMinOccurs(Reference defaultElement) {
            return this.minOccurs != null ? this.minOccurs.intValue() : defaultElement.getMinOccurs();
        }

        public int getMaxOccurs(Reference defaultElement) {
            return this.maxOccurs != null ? this.maxOccurs.intValue() : defaultElement.getMaxOccurs();
        }
    }
}

