/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.SchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;

public class SchemaUtils {
    static Properties controlIndex = new Properties();
    static NavigableMap<String, String> controlVersions = new TreeMap<String, String>();
    static NavigableMap<String, Schema> controlSchemas = new TreeMap<String, Schema>();

    private SchemaUtils() {
    }

    static Enumeration<URL> getStreams(String resource) throws IOException {
        ClassLoader loader = SchemaUtils.class.getClassLoader();
        return loader.getResources(resource);
    }

    static URL getURL(String resource) {
        return SchemaUtils.class.getResource(resource);
    }

    public static Schema getControlSchema(String standard, String[] version) throws EDISchemaException {
        String key = "EDIFACT".equals(standard) ? standard + '.' + version[1] + (version.length > 4 ? '.' + version[4] : "") : standard + '.' + String.join((CharSequence)".", version);
        Map.Entry<String, Schema> controlEntry = controlSchemas.floorEntry(key);
        if (SchemaUtils.isValidEntry(controlEntry, standard)) {
            return controlEntry.getValue();
        }
        Map.Entry<String, String> pathEntry = controlVersions.floorEntry(key);
        if (SchemaUtils.isValidEntry(pathEntry, standard)) {
            Schema created = SchemaUtils.getXmlSchema(pathEntry.getValue());
            controlSchemas.put(pathEntry.getKey(), created);
            return created;
        }
        return null;
    }

    static boolean isValidEntry(Map.Entry<String, ?> entry, String standard) {
        if (entry == null) {
            return false;
        }
        if (!entry.getKey().startsWith(standard)) {
            return false;
        }
        return entry.getValue() != null;
    }

    private static Schema getXmlSchema(String resource) throws EDISchemaException {
        URL locationContext;
        URL location = SchemaUtils.getURL(resource);
        try {
            String external = location.toExternalForm();
            locationContext = new URL(external.substring(0, external.lastIndexOf(47) + 1));
        }
        catch (MalformedURLException e) {
            throw new EDISchemaException("Unable to resolve schema location context", e);
        }
        SchemaFactory schemaFactory = SchemaFactory.newFactory();
        schemaFactory.setProperty("io.xlate.edi.schema.SCHEMA_LOCATION_URL_CONTEXT", locationContext);
        return schemaFactory.createSchema(location);
    }

    static {
        try {
            Enumeration<URL> resources = SchemaUtils.getStreams("staedi-control-index.properties");
            while (resources.hasMoreElements()) {
                InputStream stream = resources.nextElement().openStream();
                try {
                    controlIndex.load(stream);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (Map.Entry<Object, Object> entry : controlIndex.entrySet()) {
            String standardVersion = entry.getKey().toString();
            String schemaPath = entry.getValue().toString();
            controlVersions.put(standardVersion, schemaPath);
            controlSchemas.put(standardVersion, null);
        }
    }
}

