/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.stream.Location;

public class EDIFACTDialect
extends Dialect {
    public static final String UNA = "UNA";
    public static final String UNB = "UNB";
    private static final String[] EMPTY = new String[0];
    static final char DFLT_SEGMENT_TERMINATOR = '\'';
    static final char DFLT_DATA_ELEMENT_SEPARATOR = '+';
    static final char DFLT_COMPONENT_ELEMENT_SEPARATOR = ':';
    static final char DFLT_REPETITION_SEPARATOR = '*';
    static final char DFLT_RELEASE_CHARACTER = '?';
    static final char DFLT_DECIMAL_MARK = '.';
    private static final int EDIFACT_UNA_LENGTH = 9;
    private String headerTag;
    private String[] version;
    StringBuilder header;
    private int index = -1;
    private int unbStart = -1;
    private boolean initialized;
    private boolean rejected;
    private static final int TX_AGENCY = 0;
    private static final int TX_VERSION = 1;
    private static final int TX_RELEASE = 2;
    private static final int TX_ASSIGNED_CODE = 3;
    private String[] transactionVersion = new String[4];
    private String transactionVersionString;

    EDIFACTDialect() {
        this.componentDelimiter = (char)58;
        this.elementDelimiter = (char)43;
        this.decimalMark = (char)46;
        this.releaseIndicator = (char)63;
        this.elementRepeater = (char)42;
        this.segmentDelimiter = (char)39;
        this.clearTransactionVersion();
    }

    @Override
    public void setHeaderTag(String tag) {
        this.headerTag = tag;
    }

    @Override
    public String getHeaderTag() {
        return this.headerTag;
    }

    boolean initialize(CharacterSet characters) {
        String[] parsedVersion = this.parseVersion();
        if (parsedVersion.length > 1) {
            this.version = parsedVersion;
            String syntaxVersion = this.version[1];
            characters.setClass(this.componentDelimiter, CharacterClass.COMPONENT_DELIMITER);
            characters.setClass(this.elementDelimiter, CharacterClass.ELEMENT_DELIMITER);
            if (syntaxVersion.compareTo("4") >= 0 || this.releaseIndicator != ' ') {
                characters.setClass(this.releaseIndicator, CharacterClass.RELEASE_CHARACTER);
            } else {
                this.releaseIndicator = '\u0000';
            }
            if (syntaxVersion.compareTo("4") >= 0) {
                characters.setClass(this.elementRepeater, CharacterClass.ELEMENT_REPEATER);
            } else {
                this.elementRepeater = '\u0000';
            }
            characters.setClass(this.segmentDelimiter, CharacterClass.SEGMENT_DELIMITER);
            this.initialized = true;
        } else {
            this.initialized = false;
        }
        return this.initialized;
    }

    private String[] parseVersion() {
        int versionStart = this.findVersionStart();
        int versionEnd = this.header.indexOf(String.valueOf(this.elementDelimiter), versionStart);
        if (versionEnd - versionStart > 1) {
            return this.header.substring(versionStart, versionEnd).split('\\' + String.valueOf(this.componentDelimiter));
        }
        return EMPTY;
    }

    int findVersionStart() {
        return UNB.equals(this.headerTag) ? 4 : this.unbStart + 4;
    }

    @Override
    public boolean isConfirmed() {
        return this.initialized;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public boolean isServiceAdviceSegment(String tag) {
        return UNA.equals(tag);
    }

    @Override
    public String getStandard() {
        return "EDIFACT";
    }

    @Override
    public String[] getVersion() {
        return this.version;
    }

    @Override
    public boolean appendHeader(CharacterSet characters, char value) {
        boolean proceed = true;
        if (++this.index == 0) {
            this.header = new StringBuilder();
        }
        if (UNB.equals(this.headerTag)) {
            if (characters.isIgnored(value)) {
                --this.index;
            } else {
                this.header.append(value);
                proceed = this.processInterchangeHeader(characters, value);
            }
        } else {
            this.header.append(value);
            proceed = this.processServiceStringAdvice(characters, value);
        }
        return proceed;
    }

    boolean processInterchangeHeader(CharacterSet characters, char value) {
        if (this.index == 0) {
            characters.setClass(this.componentDelimiter, CharacterClass.COMPONENT_DELIMITER);
        } else if (this.index == 3) {
            characters.setClass(this.elementDelimiter, CharacterClass.ELEMENT_DELIMITER);
        } else if (this.segmentDelimiter == value) {
            this.rejected = !this.initialize(characters);
            return this.isConfirmed();
        }
        return true;
    }

    boolean processServiceStringAdvice(CharacterSet characters, char value) {
        boolean proceed = true;
        switch (this.index) {
            case 3: {
                this.componentDelimiter = value;
                this.setCharacterClass(characters, CharacterClass.COMPONENT_DELIMITER, value, true);
                break;
            }
            case 4: {
                this.elementDelimiter = value;
                this.setCharacterClass(characters, CharacterClass.ELEMENT_DELIMITER, value, true);
                break;
            }
            case 5: {
                this.decimalMark = value;
                break;
            }
            case 6: {
                this.releaseIndicator = value;
                this.setCharacterClass(characters, CharacterClass.RELEASE_CHARACTER, value, false);
                break;
            }
            case 7: {
                this.elementRepeater = value;
                break;
            }
            case 8: {
                this.segmentDelimiter = value;
                this.setCharacterClass(characters, CharacterClass.SEGMENT_DELIMITER, value, true);
                break;
            }
        }
        if (this.index > 9) {
            if (characters.isIgnored(value)) {
                this.header.deleteCharAt(this.index--);
            } else if (this.isIndexBeyondUNBFirstElement()) {
                if (value == this.elementDelimiter) {
                    this.rejected = !this.initialize(characters);
                    proceed = this.isConfirmed();
                }
            } else if (value == 'B') {
                CharSequence un = this.header.subSequence(this.index - 2, this.index);
                if ("UN".contentEquals(un)) {
                    this.unbStart = this.index - 2;
                } else {
                    proceed = false;
                }
            } else if (this.isUnexpectedSegmentDetected(value)) {
                proceed = false;
            }
        }
        return proceed;
    }

    boolean isIndexBeyondUNBFirstElement() {
        return this.unbStart > -1 && this.index - this.unbStart > 3;
    }

    boolean isUnexpectedSegmentDetected(int value) {
        return this.unbStart < 0 && value == this.elementDelimiter;
    }

    void setCharacterClass(CharacterSet characters, CharacterClass charClass, char value, boolean allowSpace) {
        if (value != ' ' || allowSpace) {
            characters.setClass(value, charClass);
        }
    }

    void clearTransactionVersion() {
        for (int i = 0; i < this.transactionVersion.length; ++i) {
            this.transactionVersion[i] = "";
        }
        this.updateTransactionVersionString(null);
    }

    void updateTransactionVersionString(String[] transactionVersion) {
        this.transactionVersionString = transactionVersion != null ? String.join((CharSequence)".", transactionVersion) : "";
    }

    @Override
    public void elementData(CharSequence data, Location location) {
        switch (location.getSegmentTag()) {
            case "UNG": {
                this.groupHeaderElementData(data, location);
                break;
            }
            case "UNH": {
                this.messageHeaderElementData(data, location);
                break;
            }
        }
    }

    void groupHeaderElementData(CharSequence data, Location location) {
        if (location.getElementPosition() == 1) {
            this.clearTransactionVersion();
        } else if (location.getElementPosition() == 6) {
            this.transactionVersion[0] = data.toString();
        } else if (location.getElementPosition() == 7) {
            switch (location.getComponentPosition()) {
                case 1: {
                    this.transactionVersion[1] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
                case 2: {
                    this.transactionVersion[2] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
                case 3: {
                    this.transactionVersion[3] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
            }
        }
    }

    void messageHeaderElementData(CharSequence data, Location location) {
        if (location.getElementPosition() == 1) {
            this.clearTransactionVersion();
        } else if (location.getElementPosition() == 2) {
            switch (location.getComponentPosition()) {
                case 2: {
                    this.transactionVersion[1] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
                case 3: {
                    this.transactionVersion[2] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
                case 4: {
                    this.transactionVersion[0] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
                case 5: {
                    this.transactionVersion[3] = data.toString();
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
            }
        }
    }

    @Override
    public void transactionEnd() {
        this.clearTransactionVersion();
    }

    @Override
    public void groupEnd() {
        this.clearTransactionVersion();
    }

    @Override
    public String[] getTransactionVersion() {
        return this.transactionVersionString.isEmpty() ? null : this.transactionVersion;
    }

    @Override
    public String getTransactionVersionString() {
        return this.transactionVersionString;
    }
}

