/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.stream.Location;

public class LocationView
implements Location {
    protected int lineNumber;
    protected int columnNumber;
    protected int characterOffset;
    protected int segmentPosition;
    protected String segmentTag;
    protected int elementPosition;
    protected int componentPosition;
    protected int elementOccurrence;

    public LocationView(Location source) {
        this.lineNumber = source.getLineNumber();
        this.columnNumber = source.getColumnNumber();
        this.characterOffset = source.getCharacterOffset();
        this.segmentPosition = source.getSegmentPosition();
        this.segmentTag = source.getSegmentTag();
        this.elementPosition = source.getElementPosition();
        this.elementOccurrence = source.getElementOccurrence();
        this.componentPosition = source.getComponentPosition();
    }

    protected LocationView() {
        this.lineNumber = 1;
        this.columnNumber = 0;
        this.characterOffset = 0;
        this.segmentPosition = -1;
        this.elementPosition = -1;
        this.componentPosition = -1;
        this.elementOccurrence = -1;
    }

    public String toString() {
        StringBuilder display = new StringBuilder();
        if (this.getSegmentPosition() < 0) {
            display.append("at offset ");
            display.append(this.getCharacterOffset());
        } else {
            display.append("in segment ");
            display.append(String.valueOf(this.getSegmentTag()));
            display.append(" at position ");
            display.append(String.valueOf(this.getSegmentPosition()));
            if (this.getElementPosition() > -1) {
                display.append(", element ");
                display.append(String.valueOf(this.getElementPosition()));
                if (this.getElementOccurrence() > 1) {
                    display.append(" (occurrence ");
                    display.append(String.valueOf(this.getElementOccurrence()));
                    display.append(')');
                }
            }
            if (this.getComponentPosition() > -1) {
                display.append(", component ");
                display.append(String.valueOf(this.getComponentPosition()));
            }
        }
        return display.toString();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int getCharacterOffset() {
        return this.characterOffset;
    }

    @Override
    public int getSegmentPosition() {
        return this.segmentPosition;
    }

    @Override
    public String getSegmentTag() {
        return this.segmentTag;
    }

    @Override
    public int getElementPosition() {
        return this.elementPosition;
    }

    @Override
    public int getComponentPosition() {
        return this.componentPosition;
    }

    @Override
    public int getElementOccurrence() {
        return this.elementOccurrence;
    }

    @Override
    public Location copy() {
        return new LocationView(this);
    }
}

