/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.stream.Location;

public class X12Dialect
extends Dialect {
    private static final String ISA = "ISA";
    private static final String ISX = "ISX";
    private static final String GS = "GS";
    private static final String ST = "ST";
    private static final int RELEASE_ISX_SEGMENT = 704;
    private static final int RELEASE_ELEMENT_I65 = 402;
    static final char DFLT_SEGMENT_TERMINATOR = '~';
    static final char DFLT_DATA_ELEMENT_SEPARATOR = '*';
    static final char DFLT_COMPONENT_ELEMENT_SEPARATOR = ':';
    static final char DFLT_REPETITION_SEPARATOR = '^';
    private static final int X12_ISA_LENGTH = 106;
    private static final int X12_ELEMENT_OFFSET = 3;
    private static final int X12_COMPONENT_OFFSET = 104;
    private static final int X12_SEGMENT_OFFSET = 105;
    private static final int X12_REPEAT_OFFSET = 82;
    private static final int[] X12_ISA_TOKENS = new int[]{3, 6, 17, 20, 31, 34, 50, 53, 69, 76, 81, 83, 89, 99, 101, 103};
    private String[] version;
    char[] header;
    private int index = -1;
    private boolean initialized;
    private boolean rejected;
    private CharacterSet characters;
    private static final int TX_AGENCY = 0;
    private static final int TX_VERSION = 1;
    private String[] transactionVersion = new String[2];
    private String transactionVersionString;
    private String agencyCode;
    private String groupVersion;

    X12Dialect() {
        this.segmentDelimiter = (char)126;
        this.elementDelimiter = (char)42;
        this.decimalMark = (char)46;
        this.releaseIndicator = '\u0000';
        this.componentDelimiter = (char)58;
        this.elementRepeater = (char)94;
        this.clearTransactionVersion();
    }

    @Override
    public String getStandard() {
        return "X12";
    }

    @Override
    public String[] getVersion() {
        return this.version;
    }

    boolean initialize(CharacterSet characters) {
        char ELEMENT = this.header[3];
        int e = 0;
        int m = 106;
        for (int i = 0; i < m; ++i) {
            if (ELEMENT != this.header[i] || X12_ISA_TOKENS[e++] == i) continue;
            return false;
        }
        this.componentDelimiter = this.header[104];
        this.segmentDelimiter = this.header[105];
        this.elementRepeater = this.header[82];
        characters.setClass(this.componentDelimiter, CharacterClass.COMPONENT_DELIMITER);
        characters.setClass(this.segmentDelimiter, CharacterClass.SEGMENT_DELIMITER);
        this.version = new String[]{new String(this.header, 84, 5)};
        if (this.numericVersion() >= 402) {
            characters.setClass(this.elementRepeater, CharacterClass.ELEMENT_REPEATER);
        } else {
            this.elementRepeater = '\u0000';
        }
        this.characters = characters;
        this.initialized = true;
        return true;
    }

    int numericVersion() {
        try {
            return Integer.parseInt(this.version[0]);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public void setHeaderTag(String tag) {
    }

    @Override
    public String getHeaderTag() {
        return ISA;
    }

    @Override
    public boolean isConfirmed() {
        return this.initialized;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public boolean isServiceAdviceSegment(String tag) {
        return false;
    }

    @Override
    public boolean appendHeader(CharacterSet characters, char value) {
        ++this.index;
        switch (this.index) {
            case 0: {
                this.header = new char[106];
                break;
            }
            case 3: {
                this.elementDelimiter = value;
                characters.setClass(this.elementDelimiter, CharacterClass.ELEMENT_DELIMITER);
                break;
            }
            case 82: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                if (!characters.isIgnored(value)) break;
                --this.index;
                return true;
            }
        }
        this.header[this.index] = value;
        boolean proceed = true;
        if (this.index == 105) {
            this.rejected = !this.initialize(characters);
            proceed = this.isConfirmed();
        }
        return proceed;
    }

    void clearTransactionVersion() {
        this.agencyCode = "";
        this.groupVersion = "";
        this.transactionVersion[0] = this.agencyCode;
        this.transactionVersion[1] = this.groupVersion;
        this.updateTransactionVersionString(null);
    }

    void updateTransactionVersionString(String[] transactionVersion) {
        this.transactionVersionString = transactionVersion != null ? String.join((CharSequence)".", transactionVersion) : "";
    }

    @Override
    public void elementData(CharSequence data, Location location) {
        if (ISX.equals(location.getSegmentTag()) && this.numericVersion() >= 704) {
            if (location.getElementPosition() == 1 && data.length() == 1) {
                this.releaseIndicator = data.charAt(0);
                this.characters.setClass(this.releaseIndicator, CharacterClass.RELEASE_CHARACTER);
            }
        } else if (GS.equals(location.getSegmentTag())) {
            switch (location.getElementPosition()) {
                case 1: {
                    this.clearTransactionVersion();
                    break;
                }
                case 7: {
                    this.agencyCode = data.toString();
                    break;
                }
                case 8: {
                    this.groupVersion = data.toString();
                    this.transactionVersion[0] = this.agencyCode;
                    this.transactionVersion[1] = this.groupVersion;
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
            }
        } else if (ST.equals(location.getSegmentTag()) && location.getElementPosition() == 3 && data.length() > 0) {
            this.transactionVersion[1] = data.toString();
            this.updateTransactionVersionString(this.transactionVersion);
        }
    }

    @Override
    public void transactionEnd() {
        this.transactionVersion[1] = this.groupVersion;
        this.updateTransactionVersionString(this.transactionVersion);
    }

    @Override
    public void groupEnd() {
        this.clearTransactionVersion();
    }

    @Override
    public String[] getTransactionVersion() {
        return this.transactionVersionString.isEmpty() ? null : this.transactionVersion;
    }

    @Override
    public String getTransactionVersionString() {
        return this.transactionVersionString;
    }
}

