/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.SchemaReaderV3;
import io.xlate.edi.internal.schema.StaEDISchemaFactory;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDIType;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;

public class SchemaReaderV4
extends SchemaReaderV3 {
    private static final Logger LOGGER = Logger.getLogger(SchemaReaderV4.class.getName());

    public SchemaReaderV4(XMLStreamReader reader, Map<String, Object> properties) {
        super("http://xlate.io/EDISchema/v4", reader, properties);
    }

    @Override
    void nameCheck(String name, Map<String, EDIType> types, XMLStreamReader reader) {
        if (types.containsKey(name)) {
            LOGGER.fine(() -> "Duplicate type name encountered: [" + name + ']');
        }
    }

    @Override
    protected String readReferencedId(XMLStreamReader reader) {
        return this.parseAttribute(reader, "type", String::valueOf);
    }

    @Override
    protected void readInclude(XMLStreamReader reader, Map<String, EDIType> types) throws EDISchemaException {
        String location = this.parseAttribute(reader, "schemaLocation", String::valueOf);
        URL context = null;
        try {
            if (this.properties.containsKey("io.xlate.edi.schema.SCHEMA_LOCATION_URL_CONTEXT")) {
                Object ctx = this.properties.get("io.xlate.edi.schema.SCHEMA_LOCATION_URL_CONTEXT");
                context = ctx instanceof URL ? (URL)ctx : new URL(String.valueOf(ctx));
            }
            URL schemaLocation = context != null ? new URL(context, location) : new URL(location);
            types.putAll(StaEDISchemaFactory.readSchemaTypes(schemaLocation, this.properties));
            reader.nextTag();
        }
        catch (Exception e) {
            throw StaEDISchemaFactory.schemaException("Exception reading included schema", reader, e);
        }
        this.nextTag(reader, "seeking next element after include");
    }
}

