/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.StaEDIFilteredStreamReader;
import io.xlate.edi.internal.stream.StaEDIStreamReader;
import io.xlate.edi.internal.stream.StaEDIXMLStreamReader;
import io.xlate.edi.internal.stream.json.JsonParserFactory;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIInputErrorReporter;
import io.xlate.edi.stream.EDIInputFactory;
import io.xlate.edi.stream.EDIReporter;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamFilter;
import io.xlate.edi.stream.EDIStreamReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaEDIInputFactory
extends EDIInputFactory {
    private EDIInputErrorReporter reporter;

    public StaEDIInputFactory() {
        this.supportedProperties.add("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_STRUCTURE");
        this.supportedProperties.add("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_CODE_VALUES");
        this.supportedProperties.add("io.xlate.edi.stream.XML_DECLARE_TRANSACTION_XMLNS");
        this.supportedProperties.add("io.xlate.edi.stream.EDI_IGNORE_EXTRANEOUS_CHARACTERS");
        this.supportedProperties.add("io.xlate.edi.stream.JSON_NULL_EMPTY_ELEMENTS");
        this.supportedProperties.add("io.xlate.edi.stream.JSON_OBJECT_ELEMENTS");
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream) {
        return this.createEDIStreamReader(stream, (Schema)null);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, String encoding) throws EDIStreamException {
        return this.createEDIStreamReader(stream, encoding, null);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, Schema schema) {
        Objects.requireNonNull(stream, "stream must not be null");
        return new StaEDIStreamReader(stream, StandardCharsets.UTF_8, schema, this.properties, this.getErrorReporter());
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, String encoding, Schema schema) throws EDIStreamException {
        Objects.requireNonNull(stream, "stream must not be null");
        if (Charset.isSupported(encoding)) {
            return new StaEDIStreamReader(stream, Charset.forName(encoding), schema, this.properties, this.getErrorReporter());
        }
        throw new EDIStreamException("Unsupported encoding: " + encoding);
    }

    @Override
    public EDIStreamReader createFilteredReader(EDIStreamReader reader, EDIStreamFilter filter) {
        return new StaEDIFilteredStreamReader(reader, filter);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(EDIStreamReader reader) throws XMLStreamException {
        return new StaEDIXMLStreamReader(reader, this.properties);
    }

    @Override
    public <J> J createJsonParser(EDIStreamReader reader, Class<J> type) {
        return JsonParserFactory.createJsonParser(reader, type, this.properties);
    }

    @Override
    public EDIInputErrorReporter getErrorReporter() {
        return this.reporter;
    }

    @Override
    public void setErrorReporter(EDIInputErrorReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    @Deprecated
    public EDIReporter getEDIReporter() {
        EDIInputErrorReporter errorReporter = this.getErrorReporter();
        if (errorReporter instanceof EDIReporter) {
            return (EDIReporter)errorReporter;
        }
        throw new ClassCastException("Can not cast reporter to EDIReporter; did you mean to call getErrorReporter() ?");
    }

    @Override
    @Deprecated
    public void setEDIReporter(EDIReporter reporter) {
        this.setErrorReporter(reporter);
    }
}

