/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.DialectFactory;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.tokenization.EDIFACTDialect;
import io.xlate.edi.internal.stream.tokenization.ElementDataHandler;
import io.xlate.edi.internal.stream.tokenization.State;
import io.xlate.edi.internal.stream.tokenization.ValidationEventHandler;
import io.xlate.edi.internal.stream.validation.UsageError;
import io.xlate.edi.internal.stream.validation.Validator;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIOutputErrorReporter;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.EDIStreamWriter;
import io.xlate.edi.stream.EDIValidationException;
import io.xlate.edi.stream.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class StaEDIStreamWriter
implements EDIStreamWriter,
ElementDataHandler,
ValidationEventHandler {
    static final Logger LOGGER = Logger.getLogger(StaEDIStreamWriter.class.getName());
    private static final int LEVEL_INITIAL = 0;
    private static final int LEVEL_INTERCHANGE = 1;
    private static final int LEVEL_SEGMENT = 2;
    private static final int LEVEL_ELEMENT = 3;
    private static final int LEVEL_COMPOSITE = 4;
    private static final int LEVEL_COMPONENT = 5;
    private int level;
    private State state = State.INITIAL;
    private CharacterSet characters = new CharacterSet();
    private final OutputStream stream;
    private final OutputStreamWriter writer;
    private final Map<String, Object> properties;
    private final EDIOutputErrorReporter reporter;
    private Dialect dialect;
    CharBuffer unconfirmedBuffer = CharBuffer.allocate(500);
    private final StaEDIStreamLocation location;
    private Schema controlSchema;
    private Validator controlValidator;
    private boolean transactionSchemaAllowed = false;
    private boolean transaction = false;
    private Schema transactionSchema;
    private Validator transactionValidator;
    private CharArraySequence dataHolder = new CharArraySequence();
    private boolean atomicElementWrite = false;
    private CharBuffer elementBuffer = CharBuffer.allocate(500);
    private final StringBuilder formattedElement = new StringBuilder();
    private List<EDIValidationException> errors = new ArrayList<EDIValidationException>();
    private char segmentTerminator;
    private char segmentTagTerminator;
    private char dataElementSeparator;
    private char componentElementSeparator;
    private char repetitionSeparator;
    private char decimalMark;
    private char releaseIndicator;
    final boolean emptyElementTruncation;
    final boolean formatElements;
    private final boolean prettyPrint;
    private String prettyPrintString;
    private long elementLength = 0L;
    private int emptyElements = 0;
    private boolean unterminatedElement = false;
    private int emptyComponents = 0;
    private boolean unterminatedComponent = false;

    public StaEDIStreamWriter(OutputStream stream, Charset charset, Map<String, Object> properties, EDIOutputErrorReporter reporter) {
        this.stream = stream;
        this.writer = new OutputStreamWriter(stream, charset);
        this.properties = new HashMap<String, Object>(properties);
        this.reporter = reporter;
        this.emptyElementTruncation = this.booleanValue(properties.get("io.xlate.edi.stream.TRUNCATE_EMPTY_ELEMENTS"));
        this.prettyPrint = this.booleanValue(properties.get("io.xlate.edi.stream.PRETTY_PRINT"));
        this.formatElements = this.booleanValue(properties.get("io.xlate.edi.stream.FORMAT_ELEMENTS"));
        this.location = new StaEDIStreamLocation();
    }

    boolean booleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        if (value == null) {
            return false;
        }
        LOGGER.warning(() -> "Value [" + value + "] could not be converted to boolean");
        return false;
    }

    private void setupDelimiters() {
        this.segmentTerminator = this.getDelimiter(this.properties, "io.xlate.edi.stream.delim.segment", this.dialect::getSegmentTerminator);
        this.segmentTagTerminator = this.dialect.getSegmentTagTerminator();
        this.dataElementSeparator = this.getDelimiter(this.properties, "io.xlate.edi.stream.delim.dataElement", this.dialect::getDataElementSeparator);
        this.componentElementSeparator = this.getDelimiter(this.properties, "io.xlate.edi.stream.delim.componentElement", this.dialect::getComponentElementSeparator);
        this.decimalMark = this.getDelimiter(this.properties, "io.xlate.edi.stream.delim.decimal", this.dialect::getDecimalMark);
        this.releaseIndicator = this.getDelimiter(this.properties, "io.xlate.edi.stream.delim.release", this.dialect::getReleaseIndicator);
        this.repetitionSeparator = this.getDelimiter(this.properties, "io.xlate.edi.stream.delim.repetition", this.dialect::getRepetitionSeparator);
        String lineSeparator = System.getProperty("line.separator");
        this.prettyPrintString = this.prettyPrint && lineSeparator.indexOf(this.segmentTerminator) < 0 ? lineSeparator : "";
    }

    private boolean areDelimitersSpecified() {
        return Arrays.asList("io.xlate.edi.stream.delim.segment", "io.xlate.edi.stream.delim.dataElement", "io.xlate.edi.stream.delim.componentElement", "io.xlate.edi.stream.delim.repetition", "io.xlate.edi.stream.delim.decimal", "io.xlate.edi.stream.delim.release").stream().anyMatch(this.properties::containsKey);
    }

    char getDelimiter(Map<String, Object> properties, String key, Supplier<Character> dialectSupplier) {
        if (properties.containsKey(key) && !this.dialect.isConfirmed()) {
            return ((Character)properties.get(key)).charValue();
        }
        return dialectSupplier.get().charValue();
    }

    static void putDelimiter(String key, char value, Map<String, Character> delimiters) {
        if (value != '\u0000') {
            delimiters.put(key, Character.valueOf(value));
        }
    }

    private static void ensureArgs(int arrayLength, int start, int end) {
        if (start < 0 || start >= arrayLength || end > arrayLength) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IllegalArgumentException();
        }
    }

    private void ensureState(State s) {
        if (this.state != s) {
            throw new IllegalStateException();
        }
    }

    private void ensureLevel(int l) {
        if (this.level != l) {
            throw new IllegalStateException();
        }
    }

    private void ensureLevelAtLeast(int lvl) {
        if (this.level < lvl) {
            throw new IllegalStateException();
        }
    }

    private void ensureLevelBetween(int min, int max) {
        if (this.level < min || this.level > max) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        return this.properties.get(name);
    }

    @Override
    public void close() throws EDIStreamException {
        this.flush();
    }

    @Override
    public void flush() throws EDIStreamException {
        try {
            this.writer.flush();
            this.stream.flush();
        }
        catch (IOException e) {
            throw new EDIStreamException("Exception flushing output stream", this.location, e);
        }
    }

    @Override
    public Schema getControlSchema() {
        return this.controlSchema;
    }

    @Override
    public void setControlSchema(Schema controlSchema) {
        this.ensureLevel(0);
        this.controlSchema = controlSchema;
        this.controlValidator = Validator.forSchema(controlSchema, null, true, this.formatElements);
    }

    @Override
    public void setTransactionSchema(Schema transactionSchema) {
        if (!Objects.equals(this.transactionSchema, transactionSchema)) {
            this.transactionSchema = transactionSchema;
            this.transactionValidator = Validator.forSchema(transactionSchema, this.controlSchema, true, this.formatElements);
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getStandard() {
        if (this.dialect == null) {
            throw new IllegalStateException("standard not accessible");
        }
        return this.dialect.getStandard();
    }

    @Override
    public Map<String, Character> getDelimiters() {
        if (this.dialect == null) {
            throw new IllegalStateException("standard not accessible");
        }
        HashMap<String, Character> delimiters = new HashMap<String, Character>(6);
        StaEDIStreamWriter.putDelimiter("io.xlate.edi.stream.delim.segment", this.segmentTerminator, delimiters);
        StaEDIStreamWriter.putDelimiter("io.xlate.edi.stream.delim.dataElement", this.dataElementSeparator, delimiters);
        StaEDIStreamWriter.putDelimiter("io.xlate.edi.stream.delim.componentElement", this.componentElementSeparator, delimiters);
        StaEDIStreamWriter.putDelimiter("io.xlate.edi.stream.delim.repetition", this.repetitionSeparator, delimiters);
        StaEDIStreamWriter.putDelimiter("io.xlate.edi.stream.delim.decimal", this.decimalMark, delimiters);
        StaEDIStreamWriter.putDelimiter("io.xlate.edi.stream.delim.release", this.releaseIndicator, delimiters);
        return delimiters;
    }

    private Validator validator() {
        return this.transaction && !this.transactionSchemaAllowed ? this.transactionValidator : this.controlValidator;
    }

    private void write(int output) throws EDIStreamException {
        CharacterClass clazz = this.characters.getClass(output);
        if (clazz == CharacterClass.INVALID) {
            throw new EDIStreamException(String.format("Invalid character: 0x%04X", output), this.location);
        }
        this.state = this.state.transition(clazz);
        switch (this.state) {
            case HEADER_X12_I: 
            case HEADER_EDIFACT_U: 
            case HEADER_TRADACOMS_S: {
                this.unconfirmedBuffer.clear();
                this.writeHeader((char)output);
                break;
            }
            case HEADER_X12_S: 
            case HEADER_EDIFACT_N: 
            case HEADER_TRADACOMS_T: 
            case INTERCHANGE_CANDIDATE: 
            case HEADER_DATA: 
            case HEADER_ELEMENT_END: 
            case HEADER_COMPONENT_END: {
                this.writeHeader((char)output);
                break;
            }
            case INVALID: {
                throw new EDIException(String.format("Invalid state: %s; output 0x%04X", new Object[]{this.state, output}));
            }
            default: {
                this.writeOutput(output);
            }
        }
    }

    void writeHeader(char output) throws EDIStreamException {
        if (!this.dialect.appendHeader(this.characters, output)) {
            throw new EDIStreamException(String.format("Unexpected header character: 0x%04X [%s]", output, Character.valueOf(output)), this.location);
        }
        this.unconfirmedBuffer.append(output);
        if (this.dialect.isConfirmed()) {
            this.setupDelimiters();
            switch (this.state) {
                case HEADER_DATA: {
                    this.state = State.TAG_SEARCH;
                    break;
                }
                case HEADER_ELEMENT_END: {
                    this.state = State.ELEMENT_END;
                    break;
                }
                case HEADER_COMPONENT_END: {
                    this.state = State.COMPONENT_END;
                    break;
                }
                default: {
                    throw new IllegalStateException("Confirmed at state " + (Object)((Object)this.state));
                }
            }
            this.unconfirmedBuffer.flip();
            if ("UNA".equals(this.dialect.getHeaderTag())) {
                this.unconfirmedBuffer.put(7, this.repetitionSeparator > '\u0000' ? (char)this.repetitionSeparator : (char)' ');
            }
            while (this.unconfirmedBuffer.hasRemaining()) {
                this.writeOutput(this.unconfirmedBuffer.get());
            }
        }
    }

    void writeOutput(int output) throws EDIStreamException {
        try {
            this.location.incrementOffset(output);
            this.writer.write(output);
        }
        catch (IOException e) {
            throw new EDIStreamException("Exception to output stream", this.location, e);
        }
    }

    @Override
    public EDIStreamWriter startInterchange() throws EDIStreamException {
        this.ensureLevel(0);
        this.ensureState(State.INITIAL);
        this.level = 1;
        return this;
    }

    @Override
    public EDIStreamWriter endInterchange() throws EDIStreamException {
        this.ensureLevel(1);
        this.level = 0;
        this.flush();
        return this;
    }

    @Override
    public EDIStreamWriter writeStartSegment(String name) throws EDIStreamException {
        this.ensureLevel(1);
        this.location.incrementSegmentPosition(name);
        this.validate(validator -> validator.validateSegment(this, name));
        if (this.exitTransaction(name)) {
            this.transaction = false;
            this.validate(validator -> validator.validateSegment(this, name));
        }
        if (this.state == State.INITIAL) {
            this.dialect = DialectFactory.getDialect(name);
            this.setupDelimiters();
            if (this.dialect instanceof EDIFACTDialect) {
                if ("UNB".equals(name) && this.areDelimitersSpecified()) {
                    this.dialect = DialectFactory.getDialect("UNA");
                    this.writeServiceAdviceString();
                    this.writeString(name);
                } else {
                    this.writeString(name);
                    if ("UNA".equals(name)) {
                        this.writeServiceAdviceCharacters();
                    }
                }
            } else {
                this.writeString(name);
            }
        } else {
            this.writeString(name);
        }
        this.level = 2;
        this.emptyElements = 0;
        this.terminateSegmentTag();
        return this;
    }

    void terminateSegmentTag() throws EDIStreamException {
        if (this.segmentTagTerminator != '\u0000') {
            this.write(this.segmentTagTerminator);
            this.unterminatedElement = false;
        } else {
            this.unterminatedElement = true;
        }
    }

    void writeServiceAdviceString() throws EDIStreamException {
        this.writeString("UNA");
        this.writeServiceAdviceCharacters();
        this.writeSegmentTerminator();
    }

    void writeServiceAdviceCharacters() throws EDIStreamException {
        this.write(this.componentElementSeparator);
        this.write(this.dataElementSeparator);
        this.write(this.decimalMark);
        this.write(this.releaseIndicator);
        this.write(this.repetitionSeparator);
    }

    private void writeString(String value) throws EDIStreamException {
        int m = value.length();
        for (int i = 0; i < m; ++i) {
            this.write(value.charAt(i));
        }
    }

    void writeSegmentTerminator() throws EDIStreamException {
        this.write(this.segmentTerminator);
        if (this.prettyPrint) {
            this.writeString(this.prettyPrintString);
        }
    }

    boolean exitTransaction(CharSequence tag) {
        return this.transaction && !this.transactionSchemaAllowed && this.controlSchema != null && this.controlSchema.containsSegment(tag.toString());
    }

    @Override
    public EDIStreamWriter writeEndSegment() throws EDIStreamException {
        this.ensureLevelAtLeast(2);
        if (this.level > 2) {
            this.validateElement(this.elementBuffer::flip, this.elementBuffer);
        }
        this.validate(validator -> validator.validateSyntax(this.dialect, this, this, this.location, false));
        if (this.state == State.ELEMENT_DATA_BINARY) {
            this.state = State.ELEMENT_END_BINARY;
        }
        this.writeSegmentTerminator();
        this.level = 1;
        this.location.clearSegmentLocations();
        this.transactionSchemaAllowed = false;
        return this;
    }

    @Override
    public EDIStreamWriter writeStartElement() throws EDIStreamException {
        this.ensureLevel(2);
        this.level = 3;
        this.location.incrementElementPosition();
        this.elementBuffer.clear();
        this.elementLength = 0L;
        this.emptyComponents = 0;
        this.unterminatedComponent = false;
        if (!this.emptyElementTruncation && this.unterminatedElement) {
            this.write(this.dataElementSeparator);
        }
        return this;
    }

    @Override
    public EDIStreamWriter writeStartElementBinary() throws EDIStreamException {
        this.writeStartElement();
        this.state = State.ELEMENT_DATA_BINARY;
        return this;
    }

    @Override
    public EDIStreamWriter writeRepeatElement() throws EDIStreamException {
        this.ensureLevelAtLeast(2);
        this.write(this.repetitionSeparator);
        this.unterminatedElement = false;
        this.level = 3;
        this.location.incrementElementOccurrence();
        this.elementLength = 0L;
        this.emptyComponents = 0;
        this.unterminatedComponent = false;
        return this;
    }

    @Override
    public EDIStreamWriter endElement() throws EDIStreamException {
        this.ensureLevelAtLeast(3);
        if (!this.atomicElementWrite) {
            if (this.level > 3) {
                this.validate(validator -> validator.validateSyntax(this.dialect, this, this, this.location, true));
            } else {
                this.validateElement(this.elementBuffer::flip, this.elementBuffer);
            }
        }
        this.location.clearComponentPosition();
        this.level = 2;
        if (this.elementLength > 0L) {
            this.unterminatedElement = true;
        } else {
            ++this.emptyElements;
        }
        if (this.state == State.ELEMENT_DATA_BINARY) {
            this.state = State.ELEMENT_END_BINARY;
        }
        return this;
    }

    @Override
    public EDIStreamWriter startComponent() throws EDIStreamException {
        this.ensureLevelBetween(3, 4);
        if (this.state == State.ELEMENT_DATA_BINARY) {
            throw new IllegalStateException();
        }
        if (3 == this.level) {
            this.validateCompositeOccurrence();
        }
        if (4 == this.level && !this.emptyElementTruncation) {
            this.write(this.componentElementSeparator);
        }
        this.level = 5;
        this.location.incrementComponentPosition();
        this.elementBuffer.clear();
        this.elementLength = 0L;
        return this;
    }

    @Override
    public EDIStreamWriter endComponent() throws EDIStreamException {
        this.ensureLevel(5);
        if (!this.atomicElementWrite) {
            this.validateElement(this.elementBuffer::flip, this.elementBuffer);
        }
        if (this.elementLength > 0L) {
            this.unterminatedComponent = true;
        } else {
            ++this.emptyComponents;
        }
        this.level = 4;
        return this;
    }

    @Override
    public EDIStreamWriter writeElement(CharSequence text) throws EDIStreamException {
        this.atomicElementWrite = true;
        this.writeStartElement();
        CharSequence value = this.validateElement(() -> {}, text);
        this.writeElementData(value);
        this.endElement();
        this.atomicElementWrite = false;
        return this;
    }

    @Override
    public EDIStreamWriter writeElement(char[] text, int start, int end) throws EDIStreamException {
        this.atomicElementWrite = true;
        this.writeStartElement();
        CharSequence value = this.validateElement(() -> this.dataHolder.set(text, start, start + end), this.dataHolder);
        this.writeElementData(value);
        this.endElement();
        this.atomicElementWrite = false;
        return this;
    }

    @Override
    public EDIStreamWriter writeEmptyElement() throws EDIStreamException {
        this.atomicElementWrite = true;
        this.writeStartElement();
        this.validateElement(this.dataHolder::clear, this.dataHolder);
        this.endElement();
        this.atomicElementWrite = false;
        return this;
    }

    @Override
    public EDIStreamWriter writeComponent(CharSequence text) throws EDIStreamException {
        this.atomicElementWrite = true;
        this.startComponent();
        CharSequence value = this.validateElement(() -> {}, text);
        this.writeElementData(value);
        this.endComponent();
        this.atomicElementWrite = false;
        return this;
    }

    @Override
    public EDIStreamWriter writeComponent(char[] text, int start, int end) throws EDIStreamException {
        this.atomicElementWrite = true;
        this.startComponent();
        CharSequence value = this.validateElement(() -> this.dataHolder.set(text, start, start + end), this.dataHolder);
        this.writeElementData(value);
        this.endComponent();
        this.atomicElementWrite = false;
        return this;
    }

    @Override
    public EDIStreamWriter writeEmptyComponent() throws EDIStreamException {
        this.atomicElementWrite = true;
        this.startComponent();
        this.validateElement(this.dataHolder::clear, this.dataHolder);
        this.endComponent();
        this.atomicElementWrite = false;
        return this;
    }

    void writeRequiredSeparators(int dataLength) throws EDIStreamException {
        if (dataLength < 1 || !this.emptyElementTruncation) {
            return;
        }
        this.writeRequiredSeparator(this.emptyElements, this.unterminatedElement, this.dataElementSeparator);
        this.emptyElements = 0;
        this.unterminatedElement = false;
        if (this.level == 5) {
            this.writeRequiredSeparator(this.emptyComponents, this.unterminatedComponent, this.componentElementSeparator);
            this.emptyComponents = 0;
            this.unterminatedComponent = false;
        }
    }

    void writeRequiredSeparator(int emptyCount, boolean unterminated, char separator) throws EDIStreamException {
        for (int i = 0; i < emptyCount; ++i) {
            this.write(separator);
        }
        if (unterminated) {
            this.write(separator);
        }
    }

    @Override
    public EDIStreamWriter writeElementData(CharSequence text) throws EDIStreamException {
        this.ensureLevelAtLeast(3);
        this.writeRequiredSeparators(text.length());
        int m = text.length();
        for (int i = 0; i < m; ++i) {
            char curr = text.charAt(i);
            if (this.characters.isDelimiter(curr)) {
                if (this.releaseIndicator > '\u0000') {
                    this.write(this.releaseIndicator);
                } else {
                    throw new IllegalArgumentException("Value contains separator: " + curr);
                }
            }
            this.write(curr);
            this.elementBuffer.put(curr);
            ++this.elementLength;
        }
        return this;
    }

    @Override
    public EDIStreamWriter writeElementData(char[] text, int start, int end) throws EDIStreamException {
        this.ensureLevelAtLeast(3);
        StaEDIStreamWriter.ensureArgs(text.length, start, end);
        this.writeRequiredSeparators(end - start);
        int m = end;
        for (int i = start; i < m; ++i) {
            char curr = text[i];
            if (this.characters.isDelimiter(curr)) {
                throw new IllegalArgumentException("Value contains separator");
            }
            this.write(curr);
            this.elementBuffer.put(curr);
            ++this.elementLength;
        }
        return this;
    }

    @Override
    public EDIStreamWriter writeBinaryData(InputStream binaryStream) throws EDIStreamException {
        this.ensureLevel(3);
        this.ensureState(State.ELEMENT_DATA_BINARY);
        try {
            int output;
            this.writeRequiredSeparators(binaryStream.available());
            this.flush();
            while ((output = binaryStream.read()) != -1) {
                this.location.incrementOffset(output);
                this.stream.write(output);
                ++this.elementLength;
            }
        }
        catch (IOException e) {
            throw new EDIStreamException("Exception writing binary element data", this.location, e);
        }
        return this;
    }

    @Override
    public EDIStreamWriter writeBinaryData(byte[] binary, int start, int end) throws EDIStreamException {
        this.ensureLevel(3);
        this.ensureState(State.ELEMENT_DATA_BINARY);
        StaEDIStreamWriter.ensureArgs(binary.length, start, end);
        this.writeRequiredSeparators(end - start);
        try {
            this.flush();
            for (int i = start; i < end; ++i) {
                this.location.incrementOffset(binary[i]);
                this.stream.write(binary[i]);
                ++this.elementLength;
            }
        }
        catch (IOException e) {
            throw new EDIStreamException("Exception writing binary element data", this.location, e);
        }
        return this;
    }

    @Override
    public EDIStreamWriter writeBinaryData(ByteBuffer binary) throws EDIStreamException {
        this.ensureLevel(3);
        this.ensureState(State.ELEMENT_DATA_BINARY);
        this.writeRequiredSeparators(binary.remaining());
        while (binary.hasRemaining()) {
            this.write(binary.get());
            ++this.elementLength;
        }
        return this;
    }

    @Override
    public boolean binaryData(InputStream binary) {
        return true;
    }

    @Override
    public boolean elementData(char[] text, int start, int length) {
        return true;
    }

    @Override
    public void loopBegin(EDIReference typeReference) {
        String loopCode = typeReference.getReferencedType().getCode();
        if (EDIType.Type.TRANSACTION.toString().equals(loopCode)) {
            this.transaction = true;
            this.transactionSchemaAllowed = true;
            if (this.transactionValidator != null) {
                this.transactionValidator.reset();
            }
        }
    }

    @Override
    public void loopEnd(EDIReference typeReference) {
        String loopCode = typeReference.getReferencedType().getCode();
        if (EDIType.Type.TRANSACTION.toString().equals(loopCode)) {
            this.transaction = false;
            this.dialect.transactionEnd();
        } else if (EDIType.Type.GROUP.toString().equals(loopCode)) {
            this.dialect.groupEnd();
        }
    }

    @Override
    public void elementError(EDIStreamEvent event, EDIStreamValidationError error, EDIReference typeReference, CharSequence data, int element, int component, int repetition) {
        StaEDIStreamLocation copy = this.location.copy();
        copy.setElementPosition(element);
        copy.setElementOccurrence(repetition);
        copy.setComponentPosition(component);
        if (this.reporter != null) {
            this.reporter.report(error, this, copy, data, typeReference);
        } else {
            this.errors.add(new EDIValidationException(event, error, copy, data));
        }
    }

    @Override
    public void segmentError(CharSequence token, EDIReference typeReference, EDIStreamValidationError error) {
        if (this.reporter != null) {
            this.reporter.report(error, this, this.getLocation(), token, typeReference);
        } else {
            this.errors.add(new EDIValidationException(EDIStreamEvent.SEGMENT_ERROR, error, this.location, token));
        }
    }

    private void validate(Consumer<Validator> command) {
        Validator validator = this.validator();
        if (validator != null) {
            this.errors.clear();
            command.accept(validator);
            if (!this.errors.isEmpty()) {
                throw this.validationExceptionChain(this.errors);
            }
        }
    }

    private void validateCompositeOccurrence() {
        Validator validator = this.validator();
        if (validator != null) {
            this.errors.clear();
            if (!validator.validCompositeOccurrences(this.dialect, this.location)) {
                for (UsageError error : validator.getElementErrors()) {
                    this.elementError(error.getError().getCategory(), error.getError(), error.getTypeReference(), "", this.location.getElementPosition(), this.location.getComponentPosition(), this.location.getElementOccurrence());
                }
            }
            if (!this.errors.isEmpty()) {
                throw this.validationExceptionChain(this.errors);
            }
        }
    }

    private CharSequence validateElement(Runnable setupCommand, CharSequence data) {
        CharSequence result;
        Validator validator = this.validator();
        if (validator != null) {
            if (this.formatElements) {
                result = this.formattedElement;
                this.formattedElement.setLength(0);
                this.formattedElement.append(data);
            } else {
                result = data;
            }
            this.errors.clear();
            setupCommand.run();
            if (!validator.validateElement(this.dialect, this.location, data, this.formattedElement)) {
                for (UsageError error : validator.getElementErrors()) {
                    this.elementError(error.getError().getCategory(), error.getError(), error.getTypeReference(), result, this.location.getElementPosition(), this.location.getComponentPosition(), this.location.getElementOccurrence());
                }
            }
            if (!this.errors.isEmpty()) {
                throw this.validationExceptionChain(this.errors);
            }
            this.dialect.elementData(result, this.location);
        } else {
            result = data;
        }
        return result;
    }

    EDIValidationException validationExceptionChain(List<EDIValidationException> errors) {
        EDIValidationException first;
        Iterator<EDIValidationException> iter = errors.iterator();
        EDIValidationException e = first = iter.next();
        while (iter.hasNext()) {
            EDIValidationException next = iter.next();
            e.setNextException(next);
            e = next;
        }
        return first;
    }
}

