/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.Location;
import java.util.HashMap;
import java.util.Map;

public class EDIException
extends EDIStreamException {
    private static final long serialVersionUID = -2724168743697298348L;
    public static final Integer MISSING_HANDLER = 1;
    public static final Integer UNSUPPORTED_DIALECT = 2;
    public static final Integer INVALID_STATE = 3;
    public static final Integer INVALID_CHARACTER = 4;
    public static final Integer INCOMPLETE_STREAM = 5;
    private static final Map<Integer, String> exceptionMessages = new HashMap<Integer, String>();

    public EDIException(String message) {
        super(message);
    }

    EDIException(Integer id, Location location) {
        super(exceptionMessages.get(id), location);
    }

    EDIException(Integer id, String message, Location location) {
        super(exceptionMessages.get(id) + "; " + message, location);
    }

    public EDIException(Integer id, String message) {
        super(exceptionMessages.get(id) + "; " + message);
    }

    static {
        exceptionMessages.put(MISSING_HANDLER, "EDIE001 - Missing required handler");
        exceptionMessages.put(UNSUPPORTED_DIALECT, "EDIE002 - Unsupported EDI dialect");
        exceptionMessages.put(INVALID_STATE, "EDIE003 - Invalid processing state");
        exceptionMessages.put(INVALID_CHARACTER, "EDIE004 - Invalid input character");
        exceptionMessages.put(INCOMPLETE_STREAM, "EDIE005 - Unexpected end of stream");
    }
}

