/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.validation.NumericValidator;

class DecimalValidator
extends NumericValidator {
    private static final DecimalValidator singleton = new DecimalValidator();

    private DecimalValidator() {
    }

    static DecimalValidator getInstance() {
        return singleton;
    }

    @Override
    int validate(Dialect dialect, CharSequence value) {
        int length = value.length();
        int dec = 0;
        int exp = 0;
        boolean invalid = false;
        int m = length;
        block5: for (int i = 0; i < m; ++i) {
            switch (value.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                case 'E': {
                    --length;
                    if (++exp <= 1) continue block5;
                    invalid = true;
                    continue block5;
                }
                case '-': {
                    --length;
                    invalid = !this.validNegativeSymbol(i, value, invalid);
                    continue block5;
                }
                default: {
                    if (dialect.isDecimalMark(value.charAt(i))) {
                        --length;
                        invalid = !this.validDecimalSymbol(++dec, exp, invalid);
                        continue block5;
                    }
                    invalid = true;
                }
            }
        }
        return invalid ? -length : length;
    }

    boolean validNegativeSymbol(int currentIndex, CharSequence value, boolean currentlyInvalid) {
        if (currentlyInvalid) {
            return false;
        }
        return currentIndex == 0 || value.charAt(currentIndex - 1) == 'E';
    }

    boolean validDecimalSymbol(int decimalCount, int exponentCount, boolean currentlyInvalid) {
        if (currentlyInvalid) {
            return false;
        }
        return decimalCount <= 1 && exponentCount <= 0;
    }
}

