/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.validation.ElementValidator;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class UsageNode {
    private static final String TOSTRING_FORMAT = "usageCount: %d, depth: %d, link: { %s }";
    private final UsageNode parent;
    private final int depth;
    private final EDIReference link;
    private final int siblingIndex;
    private final ElementValidator validator;
    private final List<UsageNode> children = new ArrayList<UsageNode>();
    private int usageCount;

    UsageNode(UsageNode parent, int depth, EDIReference link, int siblingIndex) {
        if (link == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.depth = depth;
        this.link = link;
        EDIType referencedType = link.getReferencedType();
        if (referencedType instanceof EDISimpleType) {
            EDISimpleType simple = (EDISimpleType)referencedType;
            this.validator = ElementValidator.getInstance(simple.getBase());
        } else {
            this.validator = null;
        }
        this.siblingIndex = siblingIndex;
    }

    public static boolean hasMinimumUsage(String version, UsageNode node) {
        return node == null || node.hasMinimumUsage(version);
    }

    public static UsageNode getParent(UsageNode node) {
        return node != null ? node.getParent() : null;
    }

    public static UsageNode getFirstChild(UsageNode node) {
        return node != null ? node.getFirstChild() : null;
    }

    public static void resetChildren(UsageNode ... nodes) {
        for (UsageNode node : nodes) {
            if (node == null) continue;
            node.resetChildren();
        }
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, this.usageCount, this.depth, this.link);
    }

    UsageNode getParent() {
        return this.parent;
    }

    int getDepth() {
        return this.depth;
    }

    EDIReference getLink() {
        return this.link;
    }

    EDIType getReferencedType() {
        return this.link.getReferencedType();
    }

    List<UsageNode> getChildren() {
        return this.children;
    }

    UsageNode getChild(int index) {
        return index < this.children.size() ? this.children.get(index) : null;
    }

    List<UsageNode> getChildren(String version) {
        return this.children.stream().filter(c -> c == null || c.link.getMaxOccurs(version) > 0).collect(Collectors.toList());
    }

    UsageNode getChild(String version, int index) {
        List<UsageNode> versionedChildren = this.getChildren(version);
        return index < versionedChildren.size() ? versionedChildren.get(index) : null;
    }

    boolean isImplementation() {
        return this.link instanceof EDITypeImplementation;
    }

    String getId() {
        if (this.link instanceof EDITypeImplementation) {
            return ((EDITypeImplementation)this.link).getId();
        }
        return this.link.getReferencedType().getId();
    }

    EDISimpleType getSimpleType() {
        if (this.link instanceof EDISimpleType) {
            return (EDISimpleType)((Object)this.link);
        }
        return (EDISimpleType)this.link.getReferencedType();
    }

    void validate(Dialect dialect, CharSequence value, List<EDIStreamValidationError> errors) {
        this.validator.validate(dialect, this.getSimpleType(), value, errors);
    }

    void format(Dialect dialect, CharSequence value, StringBuilder result) {
        this.validator.format(dialect, this.getSimpleType(), value, result);
    }

    List<EDISyntaxRule> getSyntaxRules() {
        EDIType referencedNode = this.link.getReferencedType();
        if (referencedNode instanceof EDIComplexType) {
            return ((EDIComplexType)referencedNode).getSyntaxRules();
        }
        return Collections.emptyList();
    }

    int getIndex() {
        return this.siblingIndex;
    }

    void incrementUsage() {
        ++this.usageCount;
    }

    boolean isUsed() {
        return this.usageCount > 0;
    }

    boolean isFirstChild() {
        return this == this.getFirstSibling();
    }

    boolean hasMinimumUsage(String version) {
        return this.usageCount >= this.link.getMinOccurs(version);
    }

    boolean hasVersions() {
        return this.getSimpleType().hasVersions();
    }

    boolean exceedsMaximumUsage(String version) {
        return this.usageCount > this.link.getMaxOccurs(version);
    }

    boolean isNodeType(EDIType.Type ... types) {
        for (EDIType.Type type : types) {
            if (!this.link.getReferencedType().isType(type)) continue;
            return true;
        }
        return false;
    }

    EDIType.Type getNodeType() {
        return this.link.getReferencedType().getType();
    }

    void reset() {
        this.usageCount = 0;
        this.resetChildren();
    }

    void resetChildren() {
        for (UsageNode node : this.children) {
            if (node == null) continue;
            node.reset();
        }
    }

    private UsageNode getSibling(int index) {
        return this.parent != null ? this.parent.getChild(index) : null;
    }

    UsageNode getFirstSibling() {
        return this.getSibling(0);
    }

    UsageNode getNextSibling() {
        return this.getSibling(this.siblingIndex + 1);
    }

    public UsageNode getFirstChild() {
        return this.getChild(0);
    }

    UsageNode getChildById(CharSequence id) {
        return this.children.stream().filter(c -> c != null && c.getId().contentEquals(id)).findFirst().orElse(null);
    }

    UsageNode getSiblingById(CharSequence id) {
        return this.parent != null ? this.parent.getChildById(id) : null;
    }
}

