/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.stream.Location;

public abstract class Dialect {
    protected char segmentDelimiter;
    protected char segmentTagTerminator = '\u0000';
    protected char elementDelimiter;
    protected char decimalMark;
    protected char releaseIndicator;
    protected char componentDelimiter;
    protected char elementRepeater;
    protected boolean initialized;
    protected boolean rejected;
    protected String transactionType;
    protected final String[] transactionVersion;
    protected String transactionVersionString;

    protected Dialect(String[] initialTransactionVersion) {
        this.transactionVersion = initialTransactionVersion;
    }

    public char getComponentElementSeparator() {
        return this.componentDelimiter;
    }

    public char getDataElementSeparator() {
        return this.elementDelimiter;
    }

    public char getDecimalMark() {
        return this.decimalMark;
    }

    public char getReleaseIndicator() {
        return this.releaseIndicator;
    }

    public char getRepetitionSeparator() {
        return this.elementRepeater;
    }

    public char getSegmentTerminator() {
        return this.segmentDelimiter;
    }

    public char getSegmentTagTerminator() {
        return this.segmentTagTerminator;
    }

    public boolean isDecimalMark(char value) {
        return value == this.getDecimalMark();
    }

    public boolean isConfirmed() {
        return this.initialized;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public boolean isServiceAdviceSegment(CharSequence segmentTag) {
        return false;
    }

    public abstract String getStandard();

    public abstract String[] getVersion();

    public abstract String getHeaderTag();

    public abstract boolean appendHeader(CharacterSet var1, char var2);

    public abstract void elementData(CharSequence var1, Location var2);

    protected abstract void clearTransactionVersion();

    public void transactionEnd() {
        this.transactionType = null;
        this.clearTransactionVersion();
    }

    public void groupEnd() {
        this.clearTransactionVersion();
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String[] getTransactionVersion() {
        return this.transactionVersionString.isEmpty() ? null : this.transactionVersion;
    }

    public String getTransactionVersionString() {
        return this.transactionVersionString;
    }
}

