/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.ElementType;
import io.xlate.edi.internal.schema.Reference;
import io.xlate.edi.internal.schema.SchemaReader;
import io.xlate.edi.internal.schema.StaEDISchema;
import io.xlate.edi.internal.schema.StaEDISchemaFactory;
import io.xlate.edi.internal.schema.StructureType;
import io.xlate.edi.internal.schema.SyntaxRestriction;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

abstract class SchemaReaderBase
implements SchemaReader {
    private static final Logger LOGGER = Logger.getLogger(SchemaReaderBase.class.getName());
    static final String REFERR_UNDECLARED = "Type %s references undeclared %s with ref='%s'";
    static final String REFERR_ILLEGAL = "Type '%s' must not be referenced as '%s' in definition of type '%s'";
    static final String LOCALNAME_ELEMENT = "element";
    static final String LOCALNAME_COMPOSITE = "composite";
    static final String ATTR_MIN_OCCURS = "minOccurs";
    static final String ATTR_MAX_OCCURS = "maxOccurs";
    static final String ATTR_TITLE = "title";
    static final EDIReference ANY_ELEMENT_REF_OPT = new Reference("io.xlate.edi.internal.schema.ANY_ELEMENT", "element", 0, 1, null, null);
    static final EDIReference ANY_COMPOSITE_REF_OPT = new Reference("io.xlate.edi.internal.schema.ANY_COMPOSITE", "composite", 0, 99, null, null);
    static final EDIReference ANY_ELEMENT_REF_REQ = new Reference("io.xlate.edi.internal.schema.ANY_ELEMENT", "element", 1, 1, null, null);
    static final EDIReference ANY_COMPOSITE_REF_REQ = new Reference("io.xlate.edi.internal.schema.ANY_COMPOSITE", "composite", 1, 99, null, null);
    static final EDISimpleType ANY_ELEMENT = new ElementType("io.xlate.edi.internal.schema.ANY_ELEMENT", EDISimpleType.Base.STRING, -1, "ANY", 0, 0L, 99999L, Collections.emptySet(), Collections.emptyList(), null, null);
    static final EDIComplexType ANY_COMPOSITE = new StructureType("io.xlate.edi.internal.schema.ANY_COMPOSITE", EDIType.Type.COMPOSITE, "ANY", IntStream.rangeClosed(0, 99).mapToObj(i -> ANY_ELEMENT_REF_OPT).collect(Collectors.toList()), Collections.emptyList(), null, null);
    final String xmlns;
    final QName qnSchema;
    final QName qnInclude;
    final QName qnDescription;
    final QName qnInterchange;
    final QName qnGroup;
    final QName qnTransaction;
    final QName qnImplementation;
    final QName qnLoop;
    final QName qnSegment;
    final QName qnComposite;
    final QName qnElement;
    final QName qnSyntax;
    final QName qnPosition;
    final QName qnSequence;
    final QName qnEnumeration;
    final QName qnValue;
    final QName qnVersion;
    final QName qnAny;
    final QName qnCompositeType;
    final QName qnElementType;
    final QName qnSegmentType;
    final Map<QName, EDIType.Type> complex;
    final Map<QName, EDIType.Type> typeDefinitions;
    final Set<QName> references;
    protected XMLStreamReader reader;
    protected Map<String, Object> properties;

    protected SchemaReaderBase(String xmlns, XMLStreamReader reader, Map<String, Object> properties) {
        this.xmlns = xmlns;
        this.qnSchema = new QName(xmlns, "schema");
        this.qnInclude = new QName(xmlns, "include");
        this.qnDescription = new QName(xmlns, "description");
        this.qnInterchange = new QName(xmlns, "interchange");
        this.qnGroup = new QName(xmlns, "group");
        this.qnTransaction = new QName(xmlns, "transaction");
        this.qnImplementation = new QName(xmlns, "implementation");
        this.qnLoop = new QName(xmlns, "loop");
        this.qnSegment = new QName(xmlns, "segment");
        this.qnComposite = new QName(xmlns, LOCALNAME_COMPOSITE);
        this.qnElement = new QName(xmlns, LOCALNAME_ELEMENT);
        this.qnSyntax = new QName(xmlns, "syntax");
        this.qnPosition = new QName(xmlns, "position");
        this.qnSequence = new QName(xmlns, "sequence");
        this.qnEnumeration = new QName(xmlns, "enumeration");
        this.qnValue = new QName(xmlns, "value");
        this.qnVersion = new QName(xmlns, "version");
        this.qnAny = new QName(xmlns, "any");
        this.qnCompositeType = new QName(xmlns, "compositeType");
        this.qnElementType = new QName(xmlns, "elementType");
        this.qnSegmentType = new QName(xmlns, "segmentType");
        this.complex = new HashMap<QName, EDIType.Type>(4);
        this.complex.put(this.qnInterchange, EDIType.Type.INTERCHANGE);
        this.complex.put(this.qnGroup, EDIType.Type.GROUP);
        this.complex.put(this.qnTransaction, EDIType.Type.TRANSACTION);
        this.complex.put(this.qnLoop, EDIType.Type.LOOP);
        this.complex.put(this.qnSegmentType, EDIType.Type.SEGMENT);
        this.complex.put(this.qnCompositeType, EDIType.Type.COMPOSITE);
        this.typeDefinitions = new HashMap<QName, EDIType.Type>(3);
        this.typeDefinitions.put(this.qnSegmentType, EDIType.Type.SEGMENT);
        this.typeDefinitions.put(this.qnCompositeType, EDIType.Type.COMPOSITE);
        this.typeDefinitions.put(this.qnElementType, EDIType.Type.ELEMENT);
        this.references = new HashSet<QName>(4);
        this.references.add(this.qnSegment);
        this.references.add(this.qnComposite);
        this.references.add(this.qnElement);
        this.reader = reader;
        this.properties = properties;
    }

    @Override
    public Map<String, EDIType> readTypes(boolean setReferences) throws EDISchemaException {
        HashMap<String, EDIType> types = new HashMap<String, EDIType>(100);
        types.put("io.xlate.edi.internal.schema.ANY_ELEMENT", ANY_ELEMENT);
        types.put("io.xlate.edi.internal.schema.ANY_COMPOSITE", ANY_COMPOSITE);
        this.nextTag(this.reader, "advancing to first schema element");
        QName element = this.reader.getName();
        while (this.qnInclude.equals(element)) {
            this.readInclude(this.reader, types);
            element = this.reader.getName();
        }
        if (this.qnInterchange.equals(element)) {
            this.readInterchange(this.reader, types);
        } else if (this.qnTransaction.equals(element)) {
            this.readTransaction(this.reader, types);
            this.readImplementation(this.reader, types);
        } else if (this.qnImplementation.equals(element)) {
            this.readImplementation(this.reader, types);
        } else if (!this.typeDefinitions.containsKey(this.reader.getName())) {
            throw StaEDISchemaFactory.unexpectedElement(element, this.reader);
        }
        this.readTypeDefinitions(this.reader, types);
        try {
            this.reader.next();
        }
        catch (XMLStreamException xse) {
            throw StaEDISchemaFactory.schemaException("XMLStreamException reading end of document", this.reader, xse);
        }
        this.requireEvent(8, this.reader);
        if (setReferences) {
            this.setReferences(types);
        }
        return types;
    }

    String readDescription(XMLStreamReader reader) {
        this.nextTag(reader, "seeking description element");
        QName element = reader.getName();
        String description = null;
        if (this.qnDescription.equals(element)) {
            description = this.getElementText(reader, "description");
            this.nextTag(reader, "after description element");
        }
        return description;
    }

    void readInterchange(XMLStreamReader reader, Map<String, EDIType> types) {
        List<EDISyntaxRule> rules;
        Reference headerRef = this.createControlReference(reader, "header");
        Reference trailerRef = this.createControlReference(reader, "trailer");
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        String descr = this.readDescription(reader);
        QName element = reader.getName();
        if (!this.qnSequence.equals(element)) {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
        this.nextTag(reader, "reading interchange sequence");
        element = reader.getName();
        ArrayList<EDIReference> refs = new ArrayList<EDIReference>(3);
        refs.add(headerRef);
        while (this.qnSegment.equals(element)) {
            this.addReferences(reader, EDIType.Type.SEGMENT, refs, this.readReference(reader, types));
            this.nextTag(reader, "completing interchange segment");
            this.nextTag(reader, "reading after interchange segment");
            element = reader.getName();
        }
        if (this.qnGroup.equals(element)) {
            refs.add(this.readControlStructure(reader, element, this.qnTransaction, types));
            this.nextTag(reader, "completing group");
            this.nextTag(reader, "reading after group");
            element = reader.getName();
        }
        if (this.qnTransaction.equals(element)) {
            refs.add(this.readControlStructure(reader, element, null, types));
            this.nextTag(reader, "completing transaction");
            this.nextTag(reader, "reading after transaction");
            element = reader.getName();
        }
        refs.add(trailerRef);
        if (this.qnSyntax.equals(element)) {
            rules = new ArrayList(2);
            this.readSyntaxList(reader, rules);
        } else {
            rules = Collections.emptyList();
        }
        StructureType interchange = new StructureType(StaEDISchema.INTERCHANGE_ID, EDIType.Type.INTERCHANGE, "INTERCHANGE", refs, rules, title, descr);
        types.put(interchange.getId(), interchange);
        this.nextTag(reader, "advancing after interchange");
    }

    Reference readControlStructure(XMLStreamReader reader, QName element, QName subelement, Map<String, EDIType> types) {
        String use;
        int minOccurs = 0;
        int maxOccurs = 99999;
        switch (use = this.parseAttribute(reader, "use", String::valueOf, "optional")) {
            case "required": {
                minOccurs = 1;
                break;
            }
            case "optional": {
                minOccurs = 0;
                break;
            }
            case "prohibited": {
                maxOccurs = 0;
                break;
            }
            default: {
                throw StaEDISchemaFactory.schemaException("Invalid value for 'use': " + use, reader);
            }
        }
        Reference headerRef = this.createControlReference(reader, "header");
        Reference trailerRef = this.createControlReference(reader, "trailer");
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        String descr = this.readDescription(reader);
        if (subelement != null) {
            this.requireElementStart(subelement, reader);
        }
        ArrayList<EDIReference> refs = new ArrayList<EDIReference>(3);
        refs.add(headerRef);
        if (subelement != null) {
            refs.add(this.readControlStructure(reader, subelement, null, types));
        }
        refs.add(trailerRef);
        EDIType.Type elementType = this.complex.get(element);
        String elementId = "io.xlate.edi.internal.schema." + elementType.name();
        StructureType struct = new StructureType(elementId, elementType, elementType.toString(), refs, Collections.emptyList(), title, descr);
        types.put(struct.getId(), struct);
        Reference structRef = new Reference(struct.getId(), element.getLocalPart(), minOccurs, maxOccurs, title, descr);
        structRef.setReferencedType(struct);
        return structRef;
    }

    Reference createControlReference(XMLStreamReader reader, String attributeName) {
        String refId = this.parseAttribute(reader, attributeName, String::valueOf);
        return new Reference(refId, "segment", 1, 1, null, null);
    }

    void readTransaction(XMLStreamReader reader, Map<String, EDIType> types) {
        QName element = reader.getName();
        types.put(StaEDISchema.TRANSACTION_ID, this.readComplexType(reader, element, types));
        this.nextTag(reader, "seeking next element after transaction");
    }

    void readTypeDefinitions(XMLStreamReader reader, Map<String, EDIType> types) {
        boolean schemaEnd = reader.getName().equals(this.qnSchema);
        if (this.typeDefinitions.containsKey(reader.getName()) && reader.getEventType() == 1) {
            this.readTypeDefinition(types, reader);
        }
        while (!schemaEnd) {
            if (this.nextTag(reader, "reading schema types") == 1) {
                this.readTypeDefinition(types, reader);
                continue;
            }
            schemaEnd = reader.getName().equals(this.qnSchema);
        }
    }

    void readTypeDefinition(Map<String, EDIType> types, XMLStreamReader reader) {
        QName element = reader.getName();
        if (this.complex.containsKey(element)) {
            String name = this.parseAttribute(reader, "name", String::valueOf);
            this.nameCheck(name, types, reader);
            types.put(name, this.readComplexType(reader, element, types));
        } else if (this.qnElementType.equals(element)) {
            String name = this.parseAttribute(reader, "name", String::valueOf);
            this.nameCheck(name, types, reader);
            types.put(name, this.readSimpleType(reader));
        } else {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
    }

    void nameCheck(String name, Map<String, EDIType> types, XMLStreamReader reader) {
        if (types.containsKey(name)) {
            throw StaEDISchemaFactory.schemaException("duplicate name: " + name, reader);
        }
    }

    StructureType readComplexType(XMLStreamReader reader, QName complexType, Map<String, EDIType> types) {
        String id;
        EDIType.Type type = this.complex.get(complexType);
        String code = this.parseAttribute(reader, "code", String::valueOf, null);
        if (this.qnTransaction.equals(complexType)) {
            id = StaEDISchema.TRANSACTION_ID;
        } else if (this.qnLoop.equals(complexType)) {
            id = code;
        } else {
            id = this.parseAttribute(reader, "name", String::valueOf);
            if (type == EDIType.Type.SEGMENT && !id.matches("^[A-Z][A-Z0-9]{1,2}$")) {
                throw StaEDISchemaFactory.schemaException("Invalid segment name [" + id + ']', reader);
            }
        }
        if (code == null) {
            code = id;
        }
        ArrayList<EDIReference> refs = new ArrayList<EDIReference>(8);
        ArrayList<EDISyntaxRule> rules = new ArrayList<EDISyntaxRule>(2);
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        String descr = this.readDescription(reader);
        this.requireElementStart(this.qnSequence, reader);
        this.readReferences(reader, types, type, refs);
        int event = this.nextTag(reader, "searching for syntax element");
        if (event == 1) {
            this.requireElementStart(this.qnSyntax, reader);
            this.readSyntaxList(reader, rules);
        }
        if ((event = reader.getEventType()) == 2) {
            return new StructureType(id, type, code, refs, rules, title, descr);
        }
        throw StaEDISchemaFactory.unexpectedEvent(reader);
    }

    void readReferences(XMLStreamReader reader, Map<String, EDIType> types, EDIType.Type parentType, List<EDIReference> refs) {
        boolean endOfReferences = false;
        while (!endOfReferences) {
            int event = this.nextTag(reader, "reading sequence");
            if (event == 1) {
                this.addReferences(reader, parentType, refs, this.readReference(reader, types));
                continue;
            }
            if (!reader.getName().equals(this.qnSequence)) continue;
            endOfReferences = true;
        }
    }

    void addReferences(XMLStreamReader reader, EDIType.Type parentType, List<EDIReference> refs, Reference reference) {
        if ("ANY".equals(reference.getRefId())) {
            EDIReference reqRef;
            EDIReference optRef;
            switch (parentType) {
                case SEGMENT: {
                    optRef = ANY_COMPOSITE_REF_OPT;
                    reqRef = ANY_COMPOSITE_REF_REQ;
                    break;
                }
                case COMPOSITE: {
                    optRef = ANY_ELEMENT_REF_OPT;
                    reqRef = ANY_ELEMENT_REF_REQ;
                    break;
                }
                default: {
                    throw StaEDISchemaFactory.schemaException("Element " + this.qnAny + " may only be present for segmentType and compositeType", reader);
                }
            }
            int min = reference.getMinOccurs();
            int max = reference.getMaxOccurs();
            for (int i = 0; i < max; ++i) {
                refs.add(i < min ? reqRef : optRef);
            }
        } else {
            refs.add(reference);
        }
    }

    Reference readReference(XMLStreamReader reader, Map<String, EDIType> types) {
        Reference ref;
        QName element = reader.getName();
        String refId = null;
        if (this.qnAny.equals(element)) {
            refId = "ANY";
        } else if (this.references.contains(element)) {
            refId = this.readReferencedId(reader);
            Objects.requireNonNull(refId);
        } else if (this.qnLoop.equals(element)) {
            refId = this.parseAttribute(reader, "code", String::valueOf);
        } else {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
        String refTag = element.getLocalPart();
        int minOccurs = this.parseAttribute(reader, ATTR_MIN_OCCURS, Integer::parseInt, 0);
        int maxOccurs = this.parseAttribute(reader, ATTR_MAX_OCCURS, Integer::parseInt, 1);
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        if (this.qnLoop.equals(element)) {
            StructureType loop = this.readComplexType(reader, element, types);
            this.nameCheck(refId, types, reader);
            types.put(refId, loop);
            ref = new Reference(refId, refTag, minOccurs, maxOccurs, title, null);
            ref.setReferencedType(loop);
        } else if (this.qnComposite.equals(element) || this.qnElement.equals(element)) {
            List<Reference.Version> versions = null;
            if (this.nextTag(reader, "reading " + element + " contents") != 2) {
                this.requireElementStart(this.qnVersion, reader);
                versions = new ArrayList();
                do {
                    versions.add(this.readReferenceVersion(reader));
                } while (this.nextTag(reader, "reading after " + element + " version") != 2);
            } else {
                versions = Collections.emptyList();
            }
            ref = new Reference(refId, refTag, minOccurs, maxOccurs, versions, title, null);
        } else {
            ref = new Reference(refId, refTag, minOccurs, maxOccurs, title, null);
        }
        return ref;
    }

    Reference.Version readReferenceVersion(XMLStreamReader reader) {
        this.requireElementStart(this.qnVersion, reader);
        String minVersion = this.parseAttribute(reader, "minVersion", String::valueOf, "");
        String maxVersion = this.parseAttribute(reader, "maxVersion", String::valueOf, "");
        Integer minOccurs = this.parseAttribute(reader, ATTR_MIN_OCCURS, Integer::valueOf, null);
        Integer maxOccurs = this.parseAttribute(reader, ATTR_MAX_OCCURS, Integer::valueOf, null);
        if (this.nextTag(reader, "reading version contents") != 2) {
            throw StaEDISchemaFactory.unexpectedElement(reader.getName(), reader);
        }
        return new Reference.Version(minVersion, maxVersion, minOccurs, maxOccurs);
    }

    void readSyntaxList(XMLStreamReader reader, List<EDISyntaxRule> rules) {
        do {
            this.readSyntax(reader, rules);
            this.nextTag(reader, "reading after syntax element");
        } while (this.qnSyntax.equals(reader.getName()));
    }

    void readSyntax(XMLStreamReader reader, List<EDISyntaxRule> rules) {
        String type = this.parseAttribute(reader, "type", String::valueOf);
        EDISyntaxRule.Type typeInt = null;
        try {
            typeInt = EDISyntaxRule.Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw StaEDISchemaFactory.schemaException("Invalid syntax 'type': [" + type + ']', reader, e);
        }
        rules.add(new SyntaxRestriction(typeInt, this.readSyntaxPositions(reader)));
    }

    List<Integer> readSyntaxPositions(XMLStreamReader reader) {
        ArrayList<Integer> positions = new ArrayList<Integer>(5);
        boolean endOfSyntax = false;
        while (!endOfSyntax) {
            int event = this.nextTag(reader, "reading syntax positions");
            QName element = reader.getName();
            if (event == 1) {
                if (!element.equals(this.qnPosition)) continue;
                String position = this.getElementText(reader, "syntax position");
                try {
                    positions.add(Integer.parseInt(position));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw StaEDISchemaFactory.schemaException("invalid position [" + position + ']', reader);
                }
            }
            endOfSyntax = true;
        }
        return positions;
    }

    ElementType readSimpleType(XMLStreamReader reader) {
        List<ElementType.Version> versions;
        Set<String> values;
        String name = this.parseAttribute(reader, "name", String::valueOf);
        String code = this.parseAttribute(reader, "code", String::valueOf, name);
        EDISimpleType.Base base = this.parseAttribute(reader, "base", val -> EDISimpleType.Base.valueOf(val.toUpperCase()), EDISimpleType.Base.STRING);
        int scale = EDISimpleType.Base.NUMERIC == base ? this.parseAttribute(reader, "scale", Integer::parseInt, 0) : -1;
        int number = this.parseAttribute(reader, "number", Integer::parseInt, -1);
        long minLength = this.parseAttribute(reader, "minLength", Long::parseLong, 1L);
        long maxLength = this.parseAttribute(reader, "maxLength", Long::parseLong, 1L);
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        String descr = this.readDescription(reader);
        if (reader.getEventType() == 2) {
            values = Collections.emptySet();
            versions = Collections.emptyList();
        } else {
            if (this.qnEnumeration.equals(reader.getName())) {
                values = this.readEnumerationValues(reader);
                this.nextTag(reader, "reading after elementType enumeration");
            } else {
                values = Collections.emptySet();
            }
            if (this.qnVersion.equals(reader.getName())) {
                versions = new ArrayList();
                do {
                    versions.add(this.readSimpleTypeVersion(reader));
                } while (this.nextTag(reader, "reading after elementType version") != 2);
            } else {
                versions = Collections.emptyList();
            }
        }
        return new ElementType(name, base, scale, code, number, minLength, maxLength, values, versions, title, descr);
    }

    ElementType.Version readSimpleTypeVersion(XMLStreamReader reader) {
        Set<String> values;
        this.requireElementStart(this.qnVersion, reader);
        String minVersion = this.parseAttribute(reader, "minVersion", String::valueOf, "");
        String maxVersion = this.parseAttribute(reader, "maxVersion", String::valueOf, "");
        Long minLength = this.parseAttribute(reader, "minLength", Long::valueOf, null);
        Long maxLength = this.parseAttribute(reader, "maxLength", Long::valueOf, null);
        if (this.nextTag(reader, "reading elementType version contents") == 2) {
            values = null;
        } else if (this.qnEnumeration.equals(reader.getName())) {
            values = this.readEnumerationValues(reader);
            this.nextTag(reader, "reading after elementType version enumeration");
        } else {
            throw StaEDISchemaFactory.unexpectedElement(reader.getName(), reader);
        }
        return new ElementType.Version(minVersion, maxVersion, minLength, maxLength, values);
    }

    Set<String> readEnumerationValues(XMLStreamReader reader) {
        Set<String> values = null;
        boolean endOfEnumeration = false;
        while (!endOfEnumeration) {
            int event = this.nextTag(reader, "reading enumeration");
            QName element = reader.getName();
            if (event == 1) {
                if (element.equals(this.qnValue)) {
                    values = this.readEnumerationValue(reader, values);
                    continue;
                }
                throw StaEDISchemaFactory.unexpectedElement(element, reader);
            }
            endOfEnumeration = true;
        }
        return values != null ? values : Collections.emptySet();
    }

    Set<String> readEnumerationValue(XMLStreamReader reader, Set<String> values) {
        if (values == null) {
            values = new LinkedHashSet<String>();
        }
        values.add(this.getElementText(reader, "enumeration value"));
        return values;
    }

    <T> T parseAttribute(XMLStreamReader reader, String attrName, Function<String, T> converter, T defaultValue) {
        String attr = reader.getAttributeValue(null, attrName);
        try {
            return attr != null ? converter.apply(attr) : defaultValue;
        }
        catch (Exception e) {
            throw StaEDISchemaFactory.schemaException("Invalid " + attrName, reader, e);
        }
    }

    <T> T parseAttribute(XMLStreamReader reader, String attrName, Function<String, T> converter) {
        String attr = reader.getAttributeValue(null, attrName);
        if (attr != null) {
            try {
                return converter.apply(attr);
            }
            catch (Exception e) {
                throw StaEDISchemaFactory.schemaException("Invalid " + attrName, reader, e);
            }
        }
        throw StaEDISchemaFactory.schemaException("Missing required attribute: [" + attrName + ']', reader);
    }

    int nextTag(XMLStreamReader reader, String activity) {
        try {
            if (!reader.hasNext()) {
                throw StaEDISchemaFactory.schemaException("End of stream reached while " + activity, reader, null);
            }
            return reader.nextTag();
        }
        catch (XMLStreamException xse) {
            throw StaEDISchemaFactory.schemaException("XMLStreamException while " + activity, reader, xse);
        }
    }

    String getElementText(XMLStreamReader reader, String context) {
        try {
            return reader.getElementText();
        }
        catch (XMLStreamException xse) {
            throw StaEDISchemaFactory.schemaException("XMLStreamException reading element text: " + context, reader, xse);
        }
    }

    void requireEvent(int eventId, XMLStreamReader reader) {
        Integer event = reader.getEventType();
        if (event != eventId) {
            throw StaEDISchemaFactory.unexpectedEvent(reader);
        }
    }

    void requireElement(QName element, XMLStreamReader reader) {
        Integer event = reader.getEventType();
        if (event != 1 && event != 2) {
            throw StaEDISchemaFactory.unexpectedEvent(reader);
        }
        if (!element.equals(reader.getName())) {
            throw StaEDISchemaFactory.unexpectedElement(reader.getName(), reader);
        }
    }

    void requireElementStart(QName element, XMLStreamReader reader) {
        Integer event = reader.getEventType();
        if (event != 1) {
            throw StaEDISchemaFactory.schemaException("Expected XML element [" + element + "] not found", reader);
        }
        if (!element.equals(reader.getName())) {
            throw StaEDISchemaFactory.unexpectedElement(reader.getName(), reader);
        }
    }

    void setReferences(Map<String, EDIType> types) {
        types.values().stream().filter(StructureType.class::isInstance).forEach(struct -> this.setReferences((StructureType)struct, types));
        this.logUnusedTypes(types, Level.INFO);
    }

    void setReferences(StructureType struct, Map<String, EDIType> types) {
        for (EDIReference ref : struct.getReferences()) {
            Reference impl = (Reference)ref;
            EDIType target = types.get(impl.getRefId());
            if (target == null) {
                throw StaEDISchemaFactory.schemaException(String.format(REFERR_UNDECLARED, struct.getId(), impl.getRefTag(), impl.getRefId()));
            }
            EDIType.Type refType = target.getType();
            if (refType != EDIType.Type.valueOf(impl.getRefTag().toUpperCase())) {
                throw StaEDISchemaFactory.schemaException(String.format(REFERR_ILLEGAL, impl.getRefId(), impl.getRefTag(), struct.getId()));
            }
            impl.setReferencedType(target);
        }
    }

    void logUnusedTypes(Map<String, EDIType> types, Level level) {
        if (LOGGER.isLoggable(level)) {
            HashSet<String> unused = new HashSet<String>(types.keySet());
            unused.remove(StaEDISchema.INTERCHANGE_ID);
            unused.remove(StaEDISchema.TRANSACTION_ID);
            unused.remove("io.xlate.edi.internal.schema.IMPLEMENTATION");
            unused.remove(ANY_COMPOSITE.getId());
            types.values().stream().filter(StructureType.class::isInstance).map(StructureType.class::cast).flatMap(struct -> struct.getReferences().stream()).forEach(ref -> unused.remove(ref.getReferencedType().getId()));
            for (String u : unused) {
                LOGGER.log(level, String.format("Unused %s '%s'", new Object[]{types.get(u).getType(), u}));
            }
        }
    }

    protected abstract String readReferencedId(XMLStreamReader var1);

    protected abstract void readInclude(XMLStreamReader var1, Map<String, EDIType> var2) throws EDISchemaException;

    protected abstract void readImplementation(XMLStreamReader var1, Map<String, EDIType> var2);
}

