/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.SchemaReader;
import io.xlate.edi.internal.schema.SchemaReaderV2;
import io.xlate.edi.internal.schema.SchemaReaderV3;
import io.xlate.edi.internal.schema.SchemaReaderV4;
import io.xlate.edi.internal.schema.SchemaUtils;
import io.xlate.edi.internal.schema.StaEDISchema;
import io.xlate.edi.internal.schema.StaEDISchemaReadException;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.SchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaEDISchemaFactory
implements SchemaFactory {
    static final Logger LOGGER = Logger.getLogger(StaEDISchemaFactory.class.getName());
    static final XMLInputFactory FACTORY = XMLInputFactory.newInstance();
    static final String SCHEMA_TAG = "schema";
    static final String XMLNS_V2 = "http://xlate.io/EDISchema/v2";
    static final String XMLNS_V3 = "http://xlate.io/EDISchema/v3";
    static final String XMLNS_V4 = "http://xlate.io/EDISchema/v4";
    static final Map<QName, BiFunction<XMLStreamReader, Map<String, Object>, SchemaReader>> readerFactories = new HashMap<QName, BiFunction<XMLStreamReader, Map<String, Object>, SchemaReader>>(3);
    static final Set<String> supportedProperties = new HashSet<String>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public Schema createSchema(InputStream stream) throws EDISchemaException {
        Map<String, EDIType> types = StaEDISchemaFactory.readSchemaTypes(stream, this.properties, true);
        StaEDISchema schema = new StaEDISchema(StaEDISchema.INTERCHANGE_ID, StaEDISchema.TRANSACTION_ID, "io.xlate.edi.internal.schema.IMPLEMENTATION");
        schema.setTypes(types);
        LOGGER.log(Level.FINE, "Schema created, contains {0} types", types.size());
        return schema;
    }

    @Override
    public Schema createSchema(URL location) throws EDISchemaException {
        Schema schema;
        block8: {
            LOGGER.fine(() -> "Creating schema from URL: " + location);
            InputStream stream = location.openStream();
            try {
                schema = this.createSchema(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EDISchemaException("Unable to read URL stream", e);
                }
            }
            stream.close();
        }
        return schema;
    }

    @Override
    public Schema getControlSchema(String standard, String[] version) throws EDISchemaException {
        return SchemaUtils.getControlSchema(standard, version);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return supportedProperties.contains(name);
    }

    @Override
    public Object getProperty(String name) {
        if (this.isPropertySupported(name)) {
            return this.properties.get(name);
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.isPropertySupported(name)) {
            if (value != null) {
                this.properties.put(name, value);
            } else {
                this.properties.remove(name);
            }
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }

    static Map<String, EDIType> readSchemaTypes(URL location, Map<String, Object> properties) throws EDISchemaException {
        Map<String, EDIType> map;
        block8: {
            LOGGER.fine(() -> "Reading schema from URL: " + location);
            InputStream stream = location.openStream();
            try {
                map = StaEDISchemaFactory.readSchemaTypes(stream, properties, false);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EDISchemaException("Unable to read URL stream", e);
                }
            }
            stream.close();
        }
        return map;
    }

    static Map<String, EDIType> readSchemaTypes(InputStream stream, Map<String, Object> properties, boolean setReferences) throws EDISchemaException {
        try {
            return StaEDISchemaFactory.getReader(stream, properties).readTypes(setReferences);
        }
        catch (StaEDISchemaReadException e) {
            throw StaEDISchemaFactory.wrapped(e);
        }
    }

    private static SchemaReader getReader(InputStream stream, Map<String, Object> properties) throws EDISchemaException {
        try {
            LOGGER.fine(() -> "Creating schema from stream");
            XMLStreamReader reader = FACTORY.createXMLStreamReader(stream);
            reader.nextTag();
            QName schemaElement = reader.getName();
            if (readerFactories.containsKey(schemaElement)) {
                return readerFactories.get(schemaElement).apply(reader, properties);
            }
            throw StaEDISchemaFactory.unexpectedElement(schemaElement, reader);
        }
        catch (XMLStreamException e) {
            throw new EDISchemaException("Exception checking start of schema XML", e);
        }
    }

    private static EDISchemaException wrapped(StaEDISchemaReadException e) {
        Location errorLocation = e.getLocation();
        if (errorLocation != null) {
            return new EDISchemaException(e.getMessage(), errorLocation, e);
        }
        return new EDISchemaException(e.getMessage(), e);
    }

    static StaEDISchemaReadException schemaException(String message) {
        return new StaEDISchemaReadException(message, null, null);
    }

    static StaEDISchemaReadException schemaException(String message, XMLStreamReader reader) {
        return StaEDISchemaFactory.schemaException(message, reader, null);
    }

    static StaEDISchemaReadException unexpectedElement(QName element, XMLStreamReader reader) {
        return StaEDISchemaFactory.schemaException("Unexpected XML element [" + element.toString() + ']', reader);
    }

    static StaEDISchemaReadException unexpectedEvent(XMLStreamReader reader) {
        return StaEDISchemaFactory.schemaException("Unexpected XML event [" + reader.getEventType() + ']', reader);
    }

    static StaEDISchemaReadException schemaException(String message, XMLStreamReader reader, Throwable cause) {
        return new StaEDISchemaReadException(message, reader.getLocation(), cause);
    }

    static {
        readerFactories.put(new QName(XMLNS_V2, SCHEMA_TAG), SchemaReaderV2::new);
        readerFactories.put(new QName(XMLNS_V3, SCHEMA_TAG), SchemaReaderV3::new);
        readerFactories.put(new QName(XMLNS_V4, SCHEMA_TAG), SchemaReaderV4::new);
        supportedProperties.add("io.xlate.edi.schema.SCHEMA_LOCATION_URL_CONTEXT");
    }
}

