/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class StaEDIXMLStreamWriter
implements XMLStreamWriter {
    private static final QName INTERCHANGE = new QName("urn:xlate.io:staedi:names:loops", "INTERCHANGE");
    static final String MSG_INVALID_COMPONENT_NAME = "Invalid component element name or position not given: %s";
    static final String MSG_INVALID_COMPONENT_POSITION = "Invalid/non-numeric component element position: %s";
    static final String MSG_INVALID_ELEMENT_NAME = "Invalid element name or position not numeric: %s";
    static final String MSG_ILLEGAL_NONWHITESPACE = "Illegal non-whitespace characters";
    private final EDIStreamWriter ediWriter;
    private final Deque<QName> elementStack = new ArrayDeque<QName>();
    private QName previousElement;
    int lastElementPosition;
    int lastComponentPosition;
    private NamespaceContext namespaceContext;
    private final Deque<Map<String, String>> namespaceStack = new ArrayDeque<Map<String, String>>();

    StaEDIXMLStreamWriter(EDIStreamWriter ediWriter) {
        this.ediWriter = ediWriter;
        this.namespaceStack.push(new HashMap());
    }

    void execute(EDIStreamWriterRunner runner) throws XMLStreamException {
        try {
            runner.execute();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    boolean repeatedElement(QName name, QName previousElement) {
        if (previousElement == null) {
            return false;
        }
        if (name.equals(previousElement)) {
            return true;
        }
        return name.getLocalPart().equals(previousElement.getLocalPart());
    }

    int getPosition(QName name, boolean component) throws XMLStreamException {
        int position;
        String localPart = name.getLocalPart();
        if (component) {
            int componentIdx = localPart.indexOf(45);
            if (componentIdx < 2) {
                throw new XMLStreamException(String.format(MSG_INVALID_COMPONENT_NAME, name));
            }
            try {
                position = Integer.parseInt(localPart.substring(componentIdx + 1));
            }
            catch (NumberFormatException e) {
                throw new XMLStreamException(String.format(MSG_INVALID_COMPONENT_POSITION, name));
            }
        }
        try {
            position = Integer.parseInt(localPart.substring(localPart.length() - 2));
        }
        catch (NumberFormatException e) {
            throw new XMLStreamException(String.format(MSG_INVALID_ELEMENT_NAME, name));
        }
        return position;
    }

    void writeStart(QName name) throws XMLStreamException {
        this.namespaceStack.push(new HashMap());
        switch (name.getNamespaceURI()) {
            case "urn:xlate.io:staedi:names:composites": {
                this.lastComponentPosition = 0;
                this.writeElementStart(name);
                break;
            }
            case "urn:xlate.io:staedi:names:elements": {
                if ("urn:xlate.io:staedi:names:composites".equals(this.elementStack.element().getNamespaceURI())) {
                    this.writeComponentStart(name);
                    break;
                }
                this.writeElementStart(name);
                break;
            }
            case "urn:xlate.io:staedi:names:loops": {
                this.elementStack.push(name);
                break;
            }
            case "urn:xlate.io:staedi:names:segments": {
                this.lastElementPosition = 0;
                this.lastComponentPosition = 0;
                this.execute(() -> this.ediWriter.writeStartSegment(name.getLocalPart()));
                this.elementStack.push(name);
                break;
            }
        }
    }

    void writeComponentStart(QName name) throws XMLStreamException {
        int position = this.getPosition(name, true);
        while (position > this.lastComponentPosition + 1) {
            ++this.lastComponentPosition;
            this.execute(this.ediWriter::writeEmptyComponent);
        }
        this.execute(this.ediWriter::startComponent);
        ++this.lastComponentPosition;
        this.elementStack.push(name);
    }

    void writeElementStart(QName name) throws XMLStreamException {
        int position = this.getPosition(name, false);
        while (position > this.lastElementPosition + 1) {
            ++this.lastElementPosition;
            this.execute(this.ediWriter::writeEmptyElement);
        }
        if (this.repeatedElement(name, this.previousElement)) {
            this.execute(this.ediWriter::writeRepeatElement);
        } else {
            this.execute(this.ediWriter::writeStartElement);
        }
        ++this.lastElementPosition;
        this.elementStack.push(name);
    }

    void writeEnd() throws XMLStreamException {
        QName name = this.elementStack.remove();
        this.namespaceStack.remove();
        switch (name.getNamespaceURI()) {
            case "urn:xlate.io:staedi:names:composites": {
                this.execute(this.ediWriter::endElement);
                this.previousElement = name;
                break;
            }
            case "urn:xlate.io:staedi:names:elements": {
                if ("urn:xlate.io:staedi:names:composites".equals(this.elementStack.element().getNamespaceURI())) {
                    this.execute(this.ediWriter::endComponent);
                    break;
                }
                this.execute(this.ediWriter::endElement);
                this.previousElement = name;
                break;
            }
            case "urn:xlate.io:staedi:names:loops": {
                break;
            }
            case "urn:xlate.io:staedi:names:segments": {
                this.previousElement = null;
                this.execute(this.ediWriter::writeEndSegment);
                break;
            }
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        String uri;
        String local;
        String prefix;
        int idx = localName.indexOf(58);
        if (idx >= 0) {
            prefix = localName.substring(0, idx);
            local = localName.substring(idx + 1);
            uri = this.getNamespaceURI(prefix);
        } else {
            prefix = "";
            local = localName;
            uri = this.getNamespaceURI("");
        }
        if (INTERCHANGE.getLocalPart().equals(local)) {
            this.writeStart(INTERCHANGE);
        } else {
            if (uri == null || uri.isEmpty()) {
                throw new XMLStreamException("Element " + localName + " has an undefined namespace");
            }
            this.writeStart(new QName(uri, local, prefix));
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStart(new QName(namespaceURI, localName));
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStart(new QName(namespaceURI, localName, prefix));
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.writeEnd();
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeEnd();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeEnd();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writeEnd();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.execute(this.ediWriter::endInterchange);
    }

    @Override
    public void close() throws XMLStreamException {
        this.execute(this.ediWriter::close);
    }

    @Override
    public void flush() throws XMLStreamException {
        this.execute(this.ediWriter::flush);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writeCharacters(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.execute(this.ediWriter::startInterchange);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if ("urn:xlate.io:staedi:names:elements".equals(this.elementStack.element().getNamespaceURI())) {
            this.execute(() -> this.ediWriter.writeElementData(text));
        } else {
            int m = text.length();
            for (int i = 0; i < m; ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                throw new XMLStreamException(MSG_ILLEGAL_NONWHITESPACE);
            }
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if ("urn:xlate.io:staedi:names:elements".equals(this.elementStack.element().getNamespaceURI())) {
            this.execute(() -> this.ediWriter.writeElementData(text, start, start + len));
        } else {
            int m = start + len;
            for (int i = start; i < m; ++i) {
                if (Character.isWhitespace(text[i])) continue;
                throw new XMLStreamException(MSG_ILLEGAL_NONWHITESPACE);
            }
        }
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.namespaceStack.stream().filter(m -> m.containsValue(uri)).flatMap(m -> m.entrySet().stream()).filter(e -> ((String)e.getValue()).equals(uri)).map(Map.Entry::getKey).findFirst().orElseGet(() -> this.getContextPrefix(uri));
    }

    String getNamespaceURI(String prefix) {
        return this.namespaceStack.stream().filter(m -> m.containsKey(prefix)).map(m -> (String)m.get(prefix)).findFirst().orElseGet(() -> this.getContextNamespaceURI(prefix));
    }

    String getContextNamespaceURI(String prefix) {
        if (this.namespaceContext != null) {
            return this.namespaceContext.getNamespaceURI(prefix);
        }
        return null;
    }

    String getContextPrefix(String uri) {
        if (this.namespaceContext != null) {
            return this.namespaceContext.getPrefix(uri);
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        Objects.requireNonNull(prefix);
        if (uri != null) {
            this.namespaceStack.element().put(prefix, uri);
        } else {
            this.namespaceStack.element().remove(prefix);
        }
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.setPrefix("", uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (this.namespaceContext != null) {
            throw new XMLStreamException("NamespaceContext has already been set");
        }
        if (!this.elementStack.isEmpty()) {
            throw new XMLStreamException("NamespaceContext must only be called at the start of the document");
        }
        this.namespaceContext = Objects.requireNonNull(context);
        this.namespaceStack.getLast().clear();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Properties not supported");
    }

    @FunctionalInterface
    static interface EDIStreamWriterRunner {
        public void execute() throws EDIStreamException;
    }
}

