/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class CharacterSet {
    private static final CharacterClass _SPACE = CharacterClass.SPACE;
    private static final CharacterClass _LATNA = CharacterClass.LATIN_A;
    private static final CharacterClass _LATNB = CharacterClass.LATIN_B;
    private static final CharacterClass _LATND = CharacterClass.LATIN_D;
    private static final CharacterClass _LATNE = CharacterClass.LATIN_E;
    private static final CharacterClass _LATNI = CharacterClass.LATIN_I;
    private static final CharacterClass _LATNN = CharacterClass.LATIN_N;
    private static final CharacterClass _LATNS = CharacterClass.LATIN_S;
    private static final CharacterClass _LATNT = CharacterClass.LATIN_T;
    private static final CharacterClass _LATNU = CharacterClass.LATIN_U;
    private static final CharacterClass _LATNX = CharacterClass.LATIN_X;
    private static final CharacterClass _LATNZ = CharacterClass.LATIN_Z;
    private static final CharacterClass _ALNUM = CharacterClass.ALPHANUMERIC;
    private static final CharacterClass _OTHER = CharacterClass.OTHER;
    private static final CharacterClass _WHITE = CharacterClass.WHITESPACE;
    private static final CharacterClass _CNTRL = CharacterClass.CONTROL;
    private static final CharacterClass _INVLD = CharacterClass.INVALID;
    private static final CharacterClass[] prototype = new CharacterClass[]{_INVLD, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _INVLD, _WHITE, _WHITE, _WHITE, _WHITE, _WHITE, _INVLD, _INVLD, _INVLD, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _INVLD, _INVLD, _INVLD, _INVLD, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _SPACE, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _LATNA, _LATNB, _ALNUM, _LATND, _LATNE, _ALNUM, _ALNUM, _ALNUM, _LATNI, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _LATNN, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _LATNS, _LATNT, _LATNU, _ALNUM, _ALNUM, _LATNX, _ALNUM, _LATNZ, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _OTHER, _OTHER, _OTHER, _OTHER, _INVLD};
    private final CharacterClass[] list = Arrays.copyOf(prototype, prototype.length);
    private final Map<Integer, CharacterClass> auxilary = new TreeMap<Integer, CharacterClass>();
    private final boolean extraneousIgnored;

    public CharacterSet() {
        this(false);
    }

    public CharacterSet(boolean extraneousIgnored) {
        this.extraneousIgnored = extraneousIgnored;
    }

    public CharacterClass getClass(int character) {
        return character < this.list.length ? this.list[character] : this.auxilary.getOrDefault(character, _OTHER);
    }

    public void reset() {
        System.arraycopy(prototype, 0, this.list, 0, prototype.length);
        this.auxilary.clear();
    }

    public void setClass(int character, CharacterClass clazz) {
        if (character < this.list.length) {
            this.list[character] = clazz;
        } else {
            this.auxilary.put(character, clazz);
        }
    }

    public boolean isDelimiter(int character) {
        switch (this.getClass(character)) {
            case ELEMENT_DELIMITER: 
            case ELEMENT_REPEATER: 
            case SEGMENT_DELIMITER: 
            case COMPONENT_DELIMITER: 
            case RELEASE_CHARACTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isIgnored(int character) {
        switch (this.getClass(character)) {
            case CONTROL: 
            case INVALID: 
            case WHITESPACE: {
                return this.extraneousIgnored;
            }
        }
        return false;
    }

    public boolean isCharacterClass(int character, CharacterClass clazz) {
        return this.getClass(character).equals((Object)clazz);
    }

    public static boolean isValid(int character) {
        if (character >= prototype.length) {
            return true;
        }
        switch (prototype[character]) {
            case CONTROL: 
            case INVALID: {
                return false;
            }
        }
        return true;
    }
}

