/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EventHandler;
import io.xlate.edi.internal.stream.tokenization.StreamEvent;
import io.xlate.edi.internal.stream.validation.UsageError;
import io.xlate.edi.internal.stream.validation.Validator;
import io.xlate.edi.schema.EDIElementPosition;
import io.xlate.edi.schema.EDILoopType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;

public class ProxyEventHandler
implements EventHandler {
    private final StaEDIStreamLocation location;
    private final boolean nestHierarchicalLoops;
    private Schema controlSchema;
    private Validator controlValidator;
    private Schema transactionSchema;
    private Validator transactionValidator;
    private boolean transactionSchemaAllowed = false;
    private boolean transaction = false;
    private InputStream binary;
    private String segmentTag;
    private CharArraySequence elementHolder = new CharArraySequence();
    private final Queue<StreamEvent> eventPool = new LinkedList<StreamEvent>();
    private final LinkedList<StreamEvent> eventQueue = new LinkedList();
    private final Deque<HierarchicalLevel> openLevels = new LinkedList<HierarchicalLevel>();
    private boolean levelCheckPending;
    private StreamEvent currentSegmentBegin;
    private StreamEvent startedLevel;
    private EDIElementPosition levelIdPosition;
    private String startedLevelId;
    private EDIElementPosition parentIdPosition;
    private String startedLevelParentId;
    private Dialect dialect;

    public ProxyEventHandler(StaEDIStreamLocation location, Schema controlSchema, boolean nestHierarchicalLoops) {
        this.location = location;
        this.nestHierarchicalLoops = nestHierarchicalLoops;
        this.setControlSchema(controlSchema, true);
    }

    public void setControlSchema(Schema controlSchema, boolean validateCodeValues) {
        if (this.controlValidator != null) {
            throw new IllegalStateException("control validator already created");
        }
        this.controlSchema = controlSchema;
        this.controlValidator = Validator.forSchema(controlSchema, null, validateCodeValues, false);
    }

    public boolean isTransactionSchemaAllowed() {
        return this.transactionSchemaAllowed;
    }

    public Schema getTransactionSchema() {
        return this.transactionSchema;
    }

    public void setTransactionSchema(Schema transactionSchema) {
        if (!Objects.equals(this.transactionSchema, transactionSchema)) {
            this.transactionSchema = transactionSchema;
            this.transactionValidator = Validator.forSchema(transactionSchema, this.controlSchema, true, false);
        }
    }

    public void resetEvents() {
        this.eventPool.addAll(this.eventQueue);
        this.eventQueue.clear();
    }

    public EDIStreamEvent getEvent() {
        return this.current(StreamEvent::getType, null);
    }

    public CharBuffer getCharacters() {
        return this.current(StreamEvent::getData, null);
    }

    public boolean nextEvent() {
        if (this.eventQueue.isEmpty()) {
            return false;
        }
        this.eventPool.add(this.eventQueue.removeFirst());
        return !this.eventQueue.isEmpty();
    }

    public EDIStreamValidationError getErrorType() {
        return this.current(StreamEvent::getErrorType, null);
    }

    public String getReferenceCode() {
        return this.current(StreamEvent::getReferenceCode, null);
    }

    public Location getLocation() {
        return this.current(StreamEvent::getLocation, this.location);
    }

    <T> T current(Function<StreamEvent, T> mapper, T defaultValue) {
        T value = this.eventQueue.isEmpty() ? defaultValue : mapper.apply(this.eventQueue.getFirst());
        return value;
    }

    StreamEvent getPooledEvent() {
        return this.eventPool.isEmpty() ? new StreamEvent() : this.eventPool.remove();
    }

    public InputStream getBinary() {
        return this.binary;
    }

    public void setBinary(InputStream binary) {
        this.binary = binary;
    }

    public EDIReference getSchemaTypeReference() {
        return this.current(StreamEvent::getTypeReference, null);
    }

    @Override
    public void interchangeBegin(Dialect dialect) {
        this.dialect = dialect;
        this.enqueueEvent(EDIStreamEvent.START_INTERCHANGE, EDIStreamValidationError.NONE, "", null, this.location);
    }

    @Override
    public void interchangeEnd() {
        Validator validator = this.validator();
        if (validator != null) {
            validator.validateLoopSyntax(this);
        }
        this.enqueueEvent(EDIStreamEvent.END_INTERCHANGE, EDIStreamValidationError.NONE, "", null, this.location);
    }

    @Override
    public void loopBegin(EDIReference typeReference) {
        String loopCode = typeReference.getReferencedType().getCode();
        if (EDIType.Type.TRANSACTION.toString().equals(loopCode)) {
            this.transaction = true;
            this.transactionSchemaAllowed = true;
            this.enqueueEvent(EDIStreamEvent.START_TRANSACTION, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
            if (this.transactionValidator != null) {
                this.transactionValidator.reset();
            }
        } else if (EDIType.Type.GROUP.toString().equals(loopCode)) {
            this.enqueueEvent(EDIStreamEvent.START_GROUP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        } else {
            this.enqueueEvent(EDIStreamEvent.START_LOOP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
            if (this.nestHierarchicalLoops && this.isHierarchicalLoop(typeReference.getReferencedType())) {
                EDILoopType loop = (EDILoopType)typeReference.getReferencedType();
                this.startedLevel = this.eventQueue.getLast();
                this.levelIdPosition = loop.getLevelIdPosition();
                this.parentIdPosition = loop.getParentIdPosition();
                this.levelCheckPending = true;
            }
        }
    }

    @Override
    public void loopEnd(EDIReference typeReference) {
        String loopCode = typeReference.getReferencedType().getCode();
        this.validator().validateLoopSyntax(this);
        if (EDIType.Type.TRANSACTION.toString().equals(loopCode)) {
            this.transaction = false;
            this.dialect.transactionEnd();
            this.enqueueEvent(EDIStreamEvent.END_TRANSACTION, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        } else if (EDIType.Type.GROUP.toString().equals(loopCode)) {
            this.dialect.groupEnd();
            this.enqueueEvent(EDIStreamEvent.END_GROUP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        } else if (this.nestHierarchicalLoops && this.isHierarchicalLoop(typeReference.getReferencedType())) {
            this.levelCheckPending = true;
        } else {
            this.enqueueEvent(EDIStreamEvent.END_LOOP, EDIStreamValidationError.NONE, loopCode, typeReference, this.location);
        }
    }

    @Override
    public boolean segmentBegin(String segmentTag) {
        this.segmentTag = segmentTag;
        this.transactionSchemaAllowed = false;
        Validator validator = this.validator();
        boolean eventsReady = true;
        EDIReference typeReference = null;
        this.clearLevelCheck();
        if (validator != null && !this.dialect.isServiceAdviceSegment(segmentTag)) {
            validator.validateSegment(this, segmentTag);
            typeReference = validator.getSegmentReference();
            boolean bl = eventsReady = !validator.isPendingDiscrimination();
        }
        if (this.exitTransaction(segmentTag)) {
            if (validator != null) {
                validator.validateLoopSyntax(this);
            }
            this.transaction = false;
            validator = this.validator();
            validator.validateSegment(this, segmentTag);
            typeReference = this.validator().getSegmentReference();
        }
        this.enqueueEvent(EDIStreamEvent.START_SEGMENT, EDIStreamValidationError.NONE, segmentTag, typeReference, this.location);
        this.currentSegmentBegin = this.eventQueue.getLast();
        return !this.levelCheckPending && eventsReady;
    }

    boolean exitTransaction(CharSequence tag) {
        return this.transaction && !this.transactionSchemaAllowed && this.controlSchema != null && this.controlSchema.containsSegment(tag.toString());
    }

    @Override
    public boolean segmentEnd() {
        Validator validator = this.validator();
        EDIReference typeReference = null;
        if (validator != null) {
            validator.validateSyntax(this.dialect, this, this, this.location, false);
            validator.validateVersionConstraints(this.dialect, this, null);
            typeReference = validator.getSegmentReference();
        }
        if (this.levelCheckPending) {
            this.performLevelCheck();
        }
        this.location.clearSegmentLocations();
        this.enqueueEvent(EDIStreamEvent.END_SEGMENT, EDIStreamValidationError.NONE, this.segmentTag, typeReference, this.location);
        return true;
    }

    @Override
    public boolean compositeBegin(boolean isNil) {
        EDIReference typeReference = null;
        boolean eventsReady = true;
        Validator validator = this.validator();
        if (validator != null && !isNil) {
            boolean invalid = !validator.validCompositeOccurrences(this.dialect, this.location);
            typeReference = validator.getCompositeReference();
            if (invalid) {
                List<UsageError> errors = validator.getElementErrors();
                for (UsageError error : errors) {
                    this.enqueueEvent(error.getError().getCategory(), error.getError(), "", error.getTypeReference(), this.location);
                }
            }
            eventsReady = !validator.isPendingDiscrimination();
        }
        this.enqueueEvent(EDIStreamEvent.START_COMPOSITE, EDIStreamValidationError.NONE, "", typeReference, this.location);
        return !this.levelCheckPending && eventsReady;
    }

    @Override
    public boolean compositeEnd(boolean isNil) {
        boolean eventsReady = true;
        if (this.validator() != null && !isNil) {
            this.validator().validateSyntax(this.dialect, this, this, this.location, true);
            eventsReady = !this.validator().isPendingDiscrimination();
        }
        this.location.clearComponentPosition();
        this.enqueueEvent(EDIStreamEvent.END_COMPOSITE, EDIStreamValidationError.NONE, "", null, this.location);
        return !this.levelCheckPending && eventsReady;
    }

    @Override
    public boolean elementData(char[] text, int start, int length) {
        boolean componentReceivedAsSimple;
        EDIReference typeReference;
        boolean derivedComposite;
        boolean valid;
        boolean eventsReady = true;
        boolean compositeFromStream = this.location.getComponentPosition() > -1;
        this.elementHolder.set(text, start, length);
        this.dialect.elementData(this.elementHolder, this.location);
        Validator validator = this.validator();
        if (this.levelCheckPending && this.startedLevel != null) {
            this.setLevelIdentifiers();
        }
        if (validator != null) {
            valid = validator.validateElement(this.dialect, this.location, this.elementHolder, null);
            derivedComposite = !compositeFromStream && validator.isComposite();
            typeReference = validator.getElementReference();
            this.enqueueElementOccurrenceErrors(validator, valid);
        } else {
            valid = true;
            derivedComposite = false;
            typeReference = null;
        }
        boolean bl = componentReceivedAsSimple = derivedComposite && text != null;
        if (componentReceivedAsSimple) {
            this.compositeBegin(this.elementHolder.length() == 0);
            this.location.incrementComponentPosition();
        }
        this.enqueueElementErrors(validator, valid);
        if (!(text == null || derivedComposite && length <= 0)) {
            this.enqueueEvent(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.NONE, this.elementHolder, typeReference, this.location);
            if (validator != null && validator.isPendingDiscrimination()) {
                eventsReady = validator.selectImplementation(this.eventQueue, this);
            }
        }
        if (componentReceivedAsSimple) {
            this.compositeEnd(length == 0);
            this.location.clearComponentPosition();
        }
        return !this.levelCheckPending && eventsReady;
    }

    void clearLevelCheck() {
        this.levelCheckPending = false;
        this.currentSegmentBegin = null;
        this.startedLevel = null;
        this.levelIdPosition = null;
        this.startedLevelId = "";
        this.parentIdPosition = null;
        this.startedLevelParentId = "";
    }

    boolean isHierarchicalLoop(EDIType type) {
        EDILoopType loop = (EDILoopType)type;
        return loop.getLevelIdPosition() != null && loop.getParentIdPosition() != null;
    }

    void setLevelIdentifiers() {
        if (this.levelIdPosition.matchesLocation(this.location)) {
            this.startedLevelId = this.elementHolder.toString();
        }
        if (this.parentIdPosition.matchesLocation(this.location)) {
            this.startedLevelParentId = this.elementHolder.toString();
        }
    }

    void performLevelCheck() {
        if (this.startedLevel != null) {
            this.completeLevel(this.startedLevel, this.startedLevelParentId);
            StreamEvent openLevel = this.getPooledEvent();
            openLevel.type = EDIStreamEvent.END_LOOP;
            openLevel.errorType = this.startedLevel.errorType;
            openLevel.setData(this.startedLevel.data);
            openLevel.setTypeReference(this.startedLevel.typeReference);
            openLevel.setLocation(this.startedLevel.location);
            this.openLevels.addLast(new HierarchicalLevel(this.startedLevelId, openLevel));
        } else {
            this.completeLevel(this.currentSegmentBegin, "");
        }
        this.clearLevelCheck();
    }

    void completeLevel(StreamEvent successor, String parentId) {
        while (!this.openLevels.isEmpty() && !this.openLevels.getLast().isParentOf(parentId)) {
            HierarchicalLevel completed = this.openLevels.removeLast();
            completed.event.location.set(this.location);
            completed.event.location.clearSegmentLocations();
            this.eventQueue.add(this.eventQueue.indexOf(successor), completed.event);
        }
    }

    void enqueueElementOccurrenceErrors(Validator validator, boolean valid) {
        if (valid) {
            return;
        }
        List<UsageError> errors = validator.getElementErrors();
        Iterator<UsageError> cursor = errors.iterator();
        while (cursor.hasNext()) {
            UsageError error = cursor.next();
            switch (error.getError()) {
                case TOO_MANY_DATA_ELEMENTS: 
                case TOO_MANY_REPETITIONS: {
                    this.enqueueEvent(error.getError().getCategory(), error.getError(), this.elementHolder, error.getTypeReference(), this.location);
                    cursor.remove();
                }
            }
        }
    }

    void enqueueElementErrors(Validator validator, boolean valid) {
        if (valid) {
            return;
        }
        List<UsageError> errors = validator.getElementErrors();
        for (UsageError error : errors) {
            this.enqueueEvent(error.getError().getCategory(), error.getError(), this.elementHolder, error.getTypeReference(), this.location);
        }
    }

    public boolean isBinaryElementLength() {
        return this.validator() != null && this.validator().isBinaryElementLength();
    }

    @Override
    public boolean binaryData(InputStream binaryStream) {
        this.enqueueEvent(EDIStreamEvent.ELEMENT_DATA_BINARY, EDIStreamValidationError.NONE, "", null, this.location);
        this.setBinary(binaryStream);
        return true;
    }

    @Override
    public void segmentError(CharSequence token, EDIReference typeReference, EDIStreamValidationError error) {
        this.enqueueEvent(EDIStreamEvent.SEGMENT_ERROR, error, token, typeReference, this.location);
    }

    @Override
    public void elementError(EDIStreamEvent event, EDIStreamValidationError error, EDIReference typeReference, CharSequence data, int element, int component, int repetition) {
        StaEDIStreamLocation copy = this.location.copy();
        copy.setElementPosition(element);
        copy.setElementOccurrence(repetition);
        copy.setComponentPosition(component);
        this.enqueueEvent(event, error, data, typeReference, copy);
    }

    private Validator validator() {
        return this.transaction && !this.transactionSchemaAllowed ? this.transactionValidator : this.controlValidator;
    }

    private void enqueueEvent(EDIStreamEvent event, EDIStreamValidationError error, CharSequence data, EDIReference typeReference, Location location) {
        EDIStreamEvent associatedEvent;
        StreamEvent target = this.getPooledEvent();
        EDIStreamEvent eDIStreamEvent = associatedEvent = this.eventQueue.isEmpty() ? null : ProxyEventHandler.getAssociatedEvent(error);
        if (this.eventExists(associatedEvent)) {
            int offset = this.eventQueue.size();
            boolean complete = false;
            while (!complete) {
                StreamEvent enqueuedEvent = this.eventQueue.get(offset - 1);
                if (enqueuedEvent.type == associatedEvent) {
                    complete = true;
                    continue;
                }
                if (this.eventQueue.size() == offset) {
                    this.eventQueue.add(offset, enqueuedEvent);
                } else {
                    this.eventQueue.set(offset, enqueuedEvent);
                }
                --offset;
            }
            this.eventQueue.set(offset, target);
        } else {
            this.eventQueue.add(target);
        }
        target.type = event;
        target.errorType = error;
        target.setData(data);
        target.setTypeReference(typeReference);
        target.setLocation(location);
    }

    private boolean eventExists(EDIStreamEvent associatedEvent) {
        for (int offset = this.eventQueue.size(); associatedEvent != null && offset > 0; --offset) {
            if (this.eventQueue.get((int)(offset - 1)).type != associatedEvent) continue;
            return true;
        }
        return false;
    }

    private static EDIStreamEvent getAssociatedEvent(EDIStreamValidationError error) {
        EDIStreamEvent event;
        switch (error) {
            case IMPLEMENTATION_LOOP_OCCURS_UNDER_MINIMUM_TIMES: {
                event = EDIStreamEvent.END_LOOP;
                break;
            }
            case MANDATORY_SEGMENT_MISSING: 
            case IMPLEMENTATION_SEGMENT_BELOW_MINIMUM_USE: {
                event = null;
                break;
            }
            default: {
                event = null;
            }
        }
        return event;
    }

    static class HierarchicalLevel {
        final String id;
        final StreamEvent event;

        HierarchicalLevel(String id, StreamEvent event) {
            this.id = id;
            this.event = event;
        }

        boolean isParentOf(String parentId) {
            return !parentId.isEmpty() && parentId.equals(this.id);
        }
    }
}

