/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.ElementDataHandler;
import io.xlate.edi.internal.stream.tokenization.StreamEvent;
import io.xlate.edi.internal.stream.tokenization.ValidationEventHandler;
import io.xlate.edi.internal.stream.validation.SyntaxValidator;
import io.xlate.edi.internal.stream.validation.UsageError;
import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.implementation.CompositeImplementation;
import io.xlate.edi.schema.implementation.Discriminator;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.schema.implementation.LoopImplementation;
import io.xlate.edi.schema.implementation.PolymorphicImplementation;
import io.xlate.edi.schema.implementation.SegmentImplementation;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.logging.Logger;

public class Validator {
    static final Logger LOGGER = Logger.getLogger(Validator.class.getName());
    static final String SEGMENT_VERSION = "";
    private Schema containerSchema;
    private Schema schema;
    private final boolean validateCodeValues;
    private final boolean formatElements;
    private boolean initial = true;
    final UsageNode root;
    final UsageNode implRoot;
    private boolean segmentExpected;
    private UsageNode segment;
    private UsageNode correctSegment;
    private UsageNode composite;
    private UsageNode element;
    private Queue<RevalidationNode> revalidationQueue = new LinkedList<RevalidationNode>();
    private boolean implSegmentSelected;
    private UsageNode implNode;
    private UsageNode implComposite;
    private UsageNode implElement;
    private List<UsageNode> implSegmentCandidates = new ArrayList<UsageNode>();
    private final Deque<UsageNode> loopStack = new ArrayDeque<UsageNode>();
    private final List<UsageError> useErrors = new ArrayList<UsageError>();
    private final List<UsageError> elementErrors = new ArrayList<UsageError>(5);
    private int depth = 1;
    private final UsageCursor cursor = new UsageCursor();

    public static Validator forSchema(Schema schema, Schema containerSchema, boolean validateCodeValues, boolean formatElements) {
        Validator instance = schema != null ? new Validator(schema, containerSchema, validateCodeValues, formatElements) : null;
        return instance;
    }

    public Validator(Schema schema, Schema containerSchema, boolean validateCodeValues) {
        this(schema, containerSchema, validateCodeValues, false);
    }

    public Validator(Schema schema, Schema containerSchema, boolean validateCodeValues, boolean formatElements) {
        this.schema = schema;
        this.validateCodeValues = validateCodeValues;
        this.formatElements = formatElements;
        this.containerSchema = containerSchema;
        LOGGER.finer(() -> "Creating usage tree");
        this.root = Validator.buildTree(schema.getStandard());
        LOGGER.finer(() -> "Done creating usage tree");
        this.correctSegment = this.segment = this.root.getFirstChild();
        if (schema.getImplementation() != null) {
            this.implRoot = Validator.buildImplTree(null, 0, schema.getImplementation(), -1);
            this.implNode = this.implRoot.getFirstChild();
        } else {
            this.implRoot = null;
            this.implNode = null;
        }
    }

    public void reset() {
        if (this.initial) {
            return;
        }
        this.root.reset();
        this.correctSegment = this.segment = this.root.getFirstChild();
        if (this.implRoot != null) {
            this.implRoot.reset();
            this.implNode = this.implRoot.getFirstChild();
        }
        this.cursor.reset(this.root, this.implRoot);
        this.depth = 1;
        this.segmentExpected = false;
        this.implSegmentSelected = false;
        this.clearElements();
        this.implSegmentCandidates.clear();
        this.useErrors.clear();
        this.elementErrors.clear();
        this.initial = true;
    }

    void clearElements() {
        this.composite = null;
        this.element = null;
        this.implComposite = null;
        this.implElement = null;
    }

    public boolean isPendingDiscrimination() {
        return !this.implSegmentCandidates.isEmpty();
    }

    public EDIReference getSegmentReference() {
        EDIReference reference = this.implSegmentSelected ? this.implNode.getLink() : (this.segmentExpected ? this.segment.getLink() : null);
        return reference;
    }

    public EDIReference getCompositeReference() {
        EDIReference reference = this.implSegmentSelected && this.implComposite != null ? this.implComposite.getLink() : (this.composite != null ? this.composite.getLink() : null);
        return reference;
    }

    public boolean isBinaryElementLength() {
        UsageNode next;
        if (this.element != null && (next = this.element.getNextSibling()) != null && next.isNodeType(EDIType.Type.ELEMENT)) {
            EDISimpleType nextType = (EDISimpleType)next.getReferencedType();
            return nextType.getBase() == EDISimpleType.Base.BINARY;
        }
        return false;
    }

    public EDIReference getElementReference() {
        EDIReference reference = this.implSegmentSelected && this.implElement != null ? this.implElement.getLink() : (this.element != null ? this.element.getLink() : null);
        return reference;
    }

    private static EDIReference referenceOf(final EDIComplexType type, final int minOccurs, final int maxOccurs) {
        return new EDIReference(){

            @Override
            public EDIType getReferencedType() {
                return type;
            }

            @Override
            public int getMinOccurs() {
                return minOccurs;
            }

            @Override
            public int getMaxOccurs() {
                return maxOccurs;
            }

            @Override
            public String getTitle() {
                return type.getTitle();
            }

            @Override
            public String getDescription() {
                return type.getDescription();
            }
        };
    }

    private static UsageNode buildTree(EDIComplexType root) {
        return Validator.buildTree(null, 0, Validator.referenceOf(root, 1, 1), -1);
    }

    private static UsageNode buildTree(UsageNode parent, int parentDepth, EDIReference link, int index) {
        int depth = parentDepth + 1;
        EDIType referencedNode = link.getReferencedType();
        UsageNode node = new UsageNode(parent, depth, link, index);
        if (!(referencedNode instanceof EDIComplexType)) {
            return node;
        }
        EDIComplexType structure = (EDIComplexType)referencedNode;
        List<EDIReference> children = structure.getReferences();
        List<UsageNode> childUsages = node.getChildren();
        int childIndex = -1;
        for (EDIReference child : children) {
            childUsages.add(Validator.buildTree(node, depth, child, ++childIndex));
        }
        return node;
    }

    private static UsageNode buildImplTree(UsageNode parent, int parentDepth, EDITypeImplementation impl, int index) {
        List<Object> children;
        int depth = parentDepth + 1;
        UsageNode node = new UsageNode(parent, depth, impl, index);
        switch (impl.getType()) {
            case COMPOSITE: {
                children = ((CompositeImplementation)CompositeImplementation.class.cast(impl)).getSequence();
                break;
            }
            case ELEMENT: {
                children = Collections.emptyList();
                break;
            }
            case TRANSACTION: 
            case LOOP: {
                children = ((LoopImplementation)LoopImplementation.class.cast(impl)).getSequence();
                break;
            }
            case SEGMENT: {
                children = ((SegmentImplementation)SegmentImplementation.class.cast(impl)).getSequence();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type of EDITypeImplementation: " + (Object)((Object)impl.getType()));
            }
        }
        List<UsageNode> childUsages = node.getChildren();
        int childIndex = -1;
        for (EDITypeImplementation eDITypeImplementation : children) {
            ++childIndex;
            UsageNode childNode = null;
            if (eDITypeImplementation != null) {
                childNode = Validator.buildImplTree(node, depth, eDITypeImplementation, childIndex);
            }
            childUsages.add(childNode);
        }
        return node;
    }

    private UsageNode startLoop(UsageNode loop) {
        loop.incrementUsage();
        loop.resetChildren();
        UsageNode startSegment = loop.getFirstChild();
        startSegment.reset();
        startSegment.incrementUsage();
        ++this.depth;
        return startSegment;
    }

    private void completeLoops(ValidationEventHandler handler, int workingDepth) {
        while (this.depth < workingDepth) {
            this.handleMissingMandatory(handler, workingDepth);
            UsageNode loop = this.loopStack.pop();
            handler.loopEnd(loop.getLink());
            --workingDepth;
            if (!loop.isImplementation()) continue;
            this.implNode = loop;
        }
    }

    public void validateSegment(ValidationEventHandler handler, CharSequence tag) {
        this.initial = false;
        this.segmentExpected = true;
        this.implSegmentSelected = false;
        this.clearElements();
        int startDepth = this.depth;
        UsageCursor startLoop = null;
        this.cursor.standard = this.correctSegment;
        this.cursor.impl = this.implNode;
        this.revalidationQueue.clear();
        this.useErrors.clear();
        boolean handled = false;
        while (!handled) {
            handled = this.handleNode(tag, this.cursor.standard, this.cursor.impl, startDepth, handler);
            if (handled) continue;
            this.checkMinimumUsage(this.cursor.standard);
            UsageNode nextImpl = this.checkMinimumImplUsage(this.cursor.impl, this.cursor.standard);
            if (this.cursor.hasNextSibling()) {
                this.cursor.next(nextImpl);
                continue;
            }
            if (startLoop == null) {
                startLoop = this.cursor.copy();
            }
            handled = this.handleLoopEnd(this.cursor, startLoop, tag, startDepth, handler);
        }
        this.handleMissingMandatory(handler);
    }

    UsageNode checkMinimumImplUsage(UsageNode nextImpl, UsageNode current) {
        while (nextImpl != null && nextImpl.getReferencedType().equals(current.getReferencedType())) {
            this.checkMinimumUsage(nextImpl);
            nextImpl = nextImpl.getNextSibling();
        }
        return nextImpl;
    }

    boolean handleNode(CharSequence tag, UsageNode current, UsageNode currentImpl, int startDepth, ValidationEventHandler handler) {
        boolean handled;
        switch (current.getNodeType()) {
            case SEGMENT: {
                handled = this.handleSegment(tag, current, currentImpl, startDepth, handler);
                break;
            }
            case TRANSACTION: 
            case LOOP: 
            case GROUP: {
                handled = this.handleLoop(tag, current, currentImpl, startDepth, handler);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    boolean handleSegment(CharSequence tag, UsageNode current, UsageNode currentImpl, int startDepth, ValidationEventHandler handler) {
        if (!current.getId().contentEquals(tag)) {
            return false;
        }
        if (current.isUsed() && current.isFirstChild() && current.getParent().isNodeType(EDIType.Type.LOOP)) {
            return false;
        }
        this.completeLoops(handler, startDepth);
        current.incrementUsage();
        current.resetChildren();
        if (current.exceedsMaximumUsage(SEGMENT_VERSION)) {
            this.handleMissingMandatory(handler);
            handler.segmentError(current.getId(), current.getLink(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
        }
        this.correctSegment = this.segment = current;
        if (currentImpl != null) {
            for (UsageNode impl = currentImpl; impl != null && impl.getReferencedType().equals(current.getReferencedType()); impl = impl.getNextSibling()) {
                this.implSegmentCandidates.add(impl);
            }
            if (this.implSegmentCandidates.isEmpty()) {
                this.handleMissingMandatory(handler);
                handler.segmentError(current.getId(), current.getLink(), EDIStreamValidationError.IMPLEMENTATION_UNUSED_SEGMENT_PRESENT);
                this.implNode = currentImpl;
            } else if (this.implSegmentCandidates.size() == 1) {
                currentImpl.incrementUsage();
                currentImpl.resetChildren();
                if (currentImpl.exceedsMaximumUsage(SEGMENT_VERSION)) {
                    handler.segmentError(currentImpl.getId(), current.getLink(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
                }
                this.implNode = currentImpl;
                this.implSegmentCandidates.clear();
                this.implSegmentSelected = true;
            }
        }
        return true;
    }

    static UsageNode toSegment(UsageNode node) {
        UsageNode segmentNode;
        switch (node.getNodeType()) {
            case SEGMENT: {
                segmentNode = node;
                break;
            }
            case TRANSACTION: 
            case LOOP: 
            case GROUP: {
                segmentNode = node.getFirstChild();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected node type: " + (Object)((Object)node.getNodeType()));
            }
        }
        return segmentNode;
    }

    void checkMinimumUsage(UsageNode node) {
        if (!node.hasMinimumUsage(SEGMENT_VERSION)) {
            UsageNode segmentNode = Validator.toSegment(node);
            if (!segmentNode.isImplementation()) {
                this.useErrors.add(new UsageError(segmentNode.getLink(), EDIStreamValidationError.MANDATORY_SEGMENT_MISSING, node.getDepth()));
            } else if (node.getNodeType() == EDIType.Type.SEGMENT) {
                this.useErrors.add(new UsageError(segmentNode.getLink(), EDIStreamValidationError.IMPLEMENTATION_SEGMENT_BELOW_MINIMUM_USE, node.getDepth()));
            } else {
                this.useErrors.add(new UsageError(segmentNode.getLink(), EDIStreamValidationError.IMPLEMENTATION_LOOP_OCCURS_UNDER_MINIMUM_TIMES, node.getDepth()));
            }
        }
    }

    boolean handleLoop(CharSequence tag, UsageNode current, UsageNode currentImpl, int startDepth, ValidationEventHandler handler) {
        if (!current.getFirstChild().getId().contentEquals(tag)) {
            return false;
        }
        this.completeLoops(handler, startDepth);
        boolean implUnusedSegment = false;
        if (currentImpl != null) {
            for (UsageNode impl = currentImpl; impl != null && impl.getReferencedType().equals(current.getReferencedType()); impl = impl.getNextSibling()) {
                this.implSegmentCandidates.add(impl);
            }
            if (this.implSegmentCandidates.isEmpty()) {
                implUnusedSegment = true;
                this.implNode = currentImpl;
            } else if (this.implSegmentCandidates.size() == 1) {
                this.handleImplementationSelected(currentImpl, currentImpl.getFirstChild(), handler);
            }
        }
        if (currentImpl != null && this.implSegmentSelected) {
            this.loopStack.push(currentImpl);
            handler.loopBegin(currentImpl.getLink());
        } else {
            this.loopStack.push(current);
            handler.loopBegin(current.getLink());
        }
        this.correctSegment = this.segment = this.startLoop(current);
        if (current.exceedsMaximumUsage(SEGMENT_VERSION)) {
            this.handleMissingMandatory(handler);
            handler.segmentError(tag, current.getLink(), EDIStreamValidationError.LOOP_OCCURS_OVER_MAXIMUM_TIMES);
        }
        if (implUnusedSegment) {
            this.handleMissingMandatory(handler);
            handler.segmentError(this.segment.getId(), this.segment.getLink(), EDIStreamValidationError.IMPLEMENTATION_UNUSED_SEGMENT_PRESENT);
        }
        return true;
    }

    boolean handleLoopEnd(UsageCursor cursor, UsageCursor startLoop, CharSequence tag, int startDepth, ValidationEventHandler handler) {
        boolean handled;
        if (this.depth > 1) {
            cursor.nagivateUp(this.depth);
            --this.depth;
            handled = false;
        } else {
            handled = this.checkPeerSegments(tag, startLoop.standard, handler);
            if (handled) {
                this.depth = startDepth;
            } else {
                cursor.reset(this.root, this.implRoot);
                handled = this.checkUnexpectedSegment(tag, cursor.standard, startDepth, handler);
            }
        }
        return handled;
    }

    boolean checkPeerSegments(CharSequence tag, UsageNode current, ValidationEventHandler handler) {
        UsageNode next;
        boolean handled = false;
        if (current != this.correctSegment && (next = current.getSiblingById(tag)) != null && !next.isFirstChild()) {
            this.useErrors.clear();
            handler.segmentError(next.getId(), next.getLink(), EDIStreamValidationError.SEGMENT_NOT_IN_PROPER_SEQUENCE);
            next.incrementUsage();
            next.resetChildren();
            if (next.exceedsMaximumUsage(SEGMENT_VERSION)) {
                handler.segmentError(next.getId(), next.getLink(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
            }
            this.segment = next;
            handled = true;
        }
        return handled;
    }

    boolean checkUnexpectedSegment(CharSequence tag, UsageNode current, int startDepth, ValidationEventHandler handler) {
        boolean handled = false;
        if (!current.getId().contentEquals(tag)) {
            String tagString = tag.toString();
            if (this.containerSchema != null && this.containerSchema.containsSegment(tagString)) {
                this.completeLoops(handler, startDepth);
                this.handleMissingMandatory(handler);
            } else {
                this.segmentExpected = false;
                this.depth = startDepth;
                this.useErrors.clear();
                if (this.schema.containsSegment(tagString)) {
                    handler.segmentError(tag, null, EDIStreamValidationError.UNEXPECTED_SEGMENT);
                } else {
                    handler.segmentError(tag, null, EDIStreamValidationError.SEGMENT_NOT_IN_DEFINED_TRANSACTION_SET);
                }
            }
            handled = true;
        }
        return handled;
    }

    private void handleMissingMandatory(ValidationEventHandler handler) {
        for (UsageError error : this.useErrors) {
            error.handleSegmentError(handler);
        }
        this.useErrors.clear();
    }

    private void handleMissingMandatory(ValidationEventHandler handler, int depth) {
        Iterator<UsageError> errors = this.useErrors.iterator();
        while (errors.hasNext()) {
            UsageError e = errors.next();
            if (!e.isDepthGreaterThan(depth)) continue;
            e.handleSegmentError(handler);
            errors.remove();
        }
    }

    public boolean selectImplementation(Deque<StreamEvent> eventQueue, ValidationEventHandler handler) {
        StreamEvent currentEvent = eventQueue.getLast();
        if (currentEvent.getType() != EDIStreamEvent.ELEMENT_DATA) {
            return false;
        }
        for (UsageNode candidate : this.implSegmentCandidates) {
            UsageNode implSeg = Validator.toSegment(candidate);
            PolymorphicImplementation implType = (PolymorphicImplementation)candidate.getLink();
            if (!Validator.isMatch(implType, currentEvent)) continue;
            this.handleImplementationSelected(candidate, implSeg, handler);
            if (this.implNode.isFirstChild()) {
                Validator.updateEventReferences(eventQueue, implType, implSeg.getLink());
                this.loopStack.pop();
                this.loopStack.push(this.implNode.getParent());
            } else {
                Validator.updateEventReferences(eventQueue, null, implSeg.getLink());
            }
            return true;
        }
        return false;
    }

    void handleImplementationSelected(UsageNode candidate, UsageNode implSeg, ValidationEventHandler handler) {
        this.checkMinimumImplUsage(this.implNode, candidate, handler);
        this.implSegmentCandidates.clear();
        this.implNode = implSeg;
        this.implSegmentSelected = true;
        if (this.isComposite()) {
            this.implComposite = implSeg.getChild(this.composite.getIndex());
            this.implElement = this.implComposite.getChild(this.element.getIndex());
            this.checkPreviousSiblings(implSeg, handler);
        } else if (this.element != null) {
            this.implComposite = null;
            this.implElement = implSeg.getChild(this.element.getIndex());
            this.checkPreviousSiblings(implSeg, handler);
        }
        if (candidate.isNodeType(EDIType.Type.LOOP)) {
            candidate.incrementUsage();
            candidate.resetChildren();
            implSeg.incrementUsage();
            if (candidate.exceedsMaximumUsage(SEGMENT_VERSION)) {
                handler.segmentError(implSeg.getId(), implSeg.getLink(), EDIStreamValidationError.LOOP_OCCURS_OVER_MAXIMUM_TIMES);
            }
        } else {
            candidate.incrementUsage();
            if (candidate.exceedsMaximumUsage(SEGMENT_VERSION)) {
                handler.segmentError(implSeg.getId(), implSeg.getLink(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
            }
        }
    }

    void checkMinimumImplUsage(UsageNode sibling, UsageNode selected, ValidationEventHandler handler) {
        while (sibling != null && sibling != selected) {
            this.checkMinimumUsage(sibling);
            sibling = sibling.getNextSibling();
        }
        this.handleMissingMandatory(handler);
    }

    void checkPreviousSiblings(UsageNode implSeg, ValidationEventHandler handler) {
        for (RevalidationNode entry : this.revalidationQueue) {
            UsageNode std = entry.standard;
            UsageNode impl = implSeg.getChild(std.getIndex());
            this.validateImplRepetitions(null, impl);
            if (std.isUsed()) {
                this.validateImplUnusedElementBlank(std, impl, true);
            } else {
                this.validateDataElementRequirement(null, std, impl, entry.data, entry.location);
            }
            this.handleRevalidatedElementErrors(entry, this.elementErrors, handler);
        }
        this.revalidationQueue.clear();
    }

    static boolean isMatch(PolymorphicImplementation implType, StreamEvent currentEvent) {
        Discriminator discr = implType.getDiscriminator();
        if (discr == null) {
            return true;
        }
        return discr.matchesLocation(currentEvent.getLocation()) && discr.getValueSet().contains(currentEvent.getData().toString());
    }

    static void updateEventReferences(Deque<StreamEvent> eventQueue, EDIReference implType, EDIReference implSeg) {
        for (StreamEvent event : eventQueue) {
            switch (event.getType()) {
                case START_LOOP: {
                    Objects.requireNonNull(implType, "Unexpected loop event during implementation segment selection");
                    Validator.updateReferenceWhenMatched(event, implType);
                    break;
                }
                case START_SEGMENT: {
                    Validator.updateReferenceWhenMatched(event, implSeg);
                    break;
                }
                case START_COMPOSITE: 
                case END_COMPOSITE: 
                case ELEMENT_DATA: {
                    Validator.updateReference(event, (SegmentImplementation)implSeg);
                    break;
                }
            }
        }
    }

    static void updateReferenceWhenMatched(StreamEvent event, EDIReference override) {
        if (Objects.equals(event.getReferenceCode(), override.getReferencedType().getCode())) {
            event.setTypeReference(override);
        }
    }

    static void updateReference(StreamEvent event, SegmentImplementation override) {
        List<EDITypeImplementation> implElements = override.getSequence();
        Location location = event.getLocation();
        int elementIndex = location.getElementPosition() - 1;
        int componentIndex = location.getComponentPosition() - 1;
        EDITypeImplementation element = implElements.get(elementIndex);
        if (componentIndex > -1) {
            CompositeImplementation composite = (CompositeImplementation)implElements.get(elementIndex);
            element = composite.getSequence().get(componentIndex);
        }
        if (element != null) {
            event.setTypeReference(element);
        }
    }

    public List<UsageError> getElementErrors() {
        return this.elementErrors;
    }

    UsageNode getImplElement(String version, int index) {
        if (this.implSegmentSelected) {
            return this.implNode.getChild(version, index);
        }
        return null;
    }

    boolean isImplElementSelected() {
        return this.implSegmentSelected && this.implElement != null;
    }

    boolean isImplUnusedElementPresent(UsageNode implElementUsed, boolean valueReceived) {
        return valueReceived && this.implSegmentSelected && implElementUsed == null;
    }

    public boolean validCompositeOccurrences(Dialect dialect, Location position) {
        if (!this.segmentExpected) {
            return true;
        }
        int elementPosition = position.getElementPosition() - 1;
        int componentIndex = position.getComponentPosition() - 1;
        String version = dialect.getTransactionVersionString();
        this.elementErrors.clear();
        this.composite = null;
        this.element = this.segment.getChild(version, elementPosition);
        this.validateImplRepetitions(version, elementPosition, -1);
        this.implComposite = null;
        this.implElement = this.getImplElement(version, elementPosition);
        if (this.element == null) {
            this.elementErrors.add(new UsageError(EDIStreamValidationError.TOO_MANY_DATA_ELEMENTS));
            return false;
        }
        if (!this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.element.incrementUsage();
            if (this.element.exceedsMaximumUsage(version)) {
                this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_REPETITIONS));
                return false;
            }
            return true;
        }
        if (componentIndex > -1) {
            throw new IllegalStateException("Invalid position w/in composite");
        }
        this.composite = this.element;
        this.element = null;
        this.composite.incrementUsage();
        if (this.composite.exceedsMaximumUsage(version)) {
            this.elementErrors.add(new UsageError(this.composite, EDIStreamValidationError.TOO_MANY_REPETITIONS));
            return false;
        }
        if (!this.validateImplUnusedElementBlank(this.composite, this.implElement, true)) {
            return false;
        }
        this.implComposite = this.implElement;
        this.implElement = null;
        if (this.implSegmentSelected) {
            this.implComposite.incrementUsage();
        }
        return this.elementErrors.isEmpty();
    }

    public boolean isComposite() {
        return this.composite != null && !"io.xlate.edi.internal.schema.ANY_COMPOSITE".equals(this.composite.getId());
    }

    public boolean validateElement(Dialect dialect, StaEDIStreamLocation position, CharSequence value, StringBuilder formattedValue) {
        if (!this.segmentExpected) {
            return true;
        }
        boolean valueReceived = value != null && value.length() > 0;
        this.clearElements();
        this.elementErrors.clear();
        int elementPosition = position.getElementPosition() - 1;
        int componentIndex = position.getComponentPosition() - 1;
        String version = dialect.getTransactionVersionString();
        this.validateImplRepetitions(version, elementPosition, componentIndex);
        if (elementPosition >= this.segment.getChildren(version).size()) {
            if (componentIndex < 0) {
                this.elementErrors.add(new UsageError(EDIStreamValidationError.TOO_MANY_DATA_ELEMENTS));
                return false;
            }
            return true;
        }
        this.element = this.segment.getChild(version, elementPosition);
        this.implElement = this.getImplElement(version, elementPosition);
        if (this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.composite = this.element;
            this.implComposite = this.implElement;
            if (componentIndex < 0) {
                componentIndex = 0;
            }
        }
        if (componentIndex > -1) {
            this.validateComponentElement(dialect, componentIndex, valueReceived);
        } else {
            this.validateImplUnusedElementBlank(this.element, this.implElement, valueReceived);
        }
        if (!this.elementErrors.isEmpty()) {
            return false;
        }
        if (valueReceived) {
            this.validateElementValue(dialect, position, value, formattedValue);
        } else {
            this.validateDataElementRequirement(version, this.element, this.implElement, value, position);
        }
        return this.elementErrors.isEmpty();
    }

    void validateComponentElement(Dialect dialect, int componentIndex, boolean valueReceived) {
        if (!this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_COMPONENTS));
        } else {
            String version;
            if (componentIndex == 0) {
                UsageNode.resetChildren(this.element, this.implElement);
            }
            if (componentIndex < this.element.getChildren(version = dialect.getTransactionVersionString()).size()) {
                if (valueReceived || componentIndex != 0) {
                    this.element = this.element.getChild(version, componentIndex);
                    if (this.isImplElementSelected()) {
                        this.implElement = this.implElement.getChild(version, componentIndex);
                        this.validateImplUnusedElementBlank(this.element, this.implElement, valueReceived);
                    }
                }
            } else {
                this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_COMPONENTS));
            }
        }
    }

    void validateElementValue(Dialect dialect, StaEDIStreamLocation position, CharSequence value, StringBuilder formattedValue) {
        String version = dialect.getTransactionVersionString();
        if (!this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.element.incrementUsage();
            if (this.implElement != null) {
                this.implElement.incrementUsage();
            }
            if (this.element.exceedsMaximumUsage(version)) {
                this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_REPETITIONS));
            }
        }
        if (version.isEmpty() && this.element.hasVersions() || this.isPendingDiscrimination()) {
            this.revalidationQueue.add(new RevalidationNode(this.element, this.implElement, value, position));
            return;
        }
        this.validateElementValue(dialect, this.element, this.implElement, value, formattedValue);
    }

    public void validateVersionConstraints(Dialect dialect, ValidationEventHandler validationHandler, StringBuilder formattedValue) {
        for (RevalidationNode entry : this.revalidationQueue) {
            this.validateElementValue(dialect, entry.standard, entry.impl, entry.data, formattedValue);
            this.handleRevalidatedElementErrors(entry, this.elementErrors, validationHandler);
        }
        this.revalidationQueue.clear();
    }

    void handleRevalidatedElementErrors(RevalidationNode entry, List<UsageError> errors, ValidationEventHandler validationHandler) {
        for (UsageError error : errors) {
            validationHandler.elementError(error.getError().getCategory(), error.getError(), error.getTypeReference(), entry.data, entry.location.getElementPosition(), entry.location.getComponentPosition(), entry.location.getElementOccurrence());
        }
        errors.clear();
    }

    void validateElementValue(Dialect dialect, UsageNode element, UsageNode implElement, CharSequence value, StringBuilder formattedValue) {
        ArrayList<EDIStreamValidationError> errors = new ArrayList<EDIStreamValidationError>();
        if (this.formatElements) {
            formattedValue.setLength(0);
            element.format(dialect, value, formattedValue);
            value = formattedValue;
        } else {
            element.validate(dialect, value, errors);
        }
        for (EDIStreamValidationError error : errors) {
            if (!this.validateCodeValues && error == EDIStreamValidationError.INVALID_CODE_VALUE) continue;
            this.elementErrors.add(new UsageError(element, error));
        }
        if (errors.isEmpty() && this.implSegmentSelected && implElement != null) {
            implElement.validate(dialect, value, errors);
            for (EDIStreamValidationError error : errors) {
                if (error == EDIStreamValidationError.INVALID_CODE_VALUE) {
                    error = EDIStreamValidationError.IMPLEMENTATION_INVALID_CODE_VALUE;
                }
                this.elementErrors.add(new UsageError(element, error));
            }
        }
    }

    public void validateSyntax(Dialect dialect, ElementDataHandler handler, ValidationEventHandler validationHandler, StaEDIStreamLocation location, boolean isComposite) {
        UsageNode previousImpl;
        if (isComposite && this.composite == null) {
            return;
        }
        String version = dialect.getTransactionVersionString();
        UsageNode structure = isComposite ? this.composite : this.segment;
        int index = this.getCurrentIndex(location, isComposite);
        int elementPosition = location.getElementPosition() - 1;
        int componentIndex = location.getComponentPosition() - 1;
        List<UsageNode> children = structure.getChildren(version);
        int max = children.size();
        for (int i = Math.max(index, 0); i < max; ++i) {
            if (isComposite) {
                location.incrementComponentPosition();
            } else {
                location.incrementElementPosition();
            }
            handler.elementData(null, 0, 0);
        }
        if (!isComposite && this.implSegmentSelected && index == children.size() && this.tooFewRepetitions(version, previousImpl = this.implNode.getChild(elementPosition))) {
            validationHandler.elementError(EDIStreamValidationError.IMPLEMENTATION_TOO_FEW_REPETITIONS.getCategory(), EDIStreamValidationError.IMPLEMENTATION_TOO_FEW_REPETITIONS, previousImpl.getLink(), null, elementPosition + 1, componentIndex + 1, -1);
        }
        for (EDISyntaxRule rule : structure.getSyntaxRules()) {
            EDISyntaxRule.Type ruleType = rule.getType();
            SyntaxValidator validator = SyntaxValidator.getInstance(ruleType);
            validator.validate(rule, structure, validationHandler);
        }
    }

    public void validateLoopSyntax(ValidationEventHandler validationHandler) {
        UsageNode loop = this.segment.getParent();
        for (EDISyntaxRule rule : loop.getSyntaxRules()) {
            EDISyntaxRule.Type ruleType = rule.getType();
            SyntaxValidator validator = SyntaxValidator.getInstance(ruleType);
            validator.validate(rule, loop, validationHandler);
        }
    }

    void validateImplRepetitions(String version, int elementPosition, int componentPosition) {
        if (elementPosition > 0 && componentPosition < 0) {
            UsageNode previousImpl = this.getImplElement(version, elementPosition - 1);
            this.validateImplRepetitions(version, previousImpl);
        }
    }

    void validateImplRepetitions(String version, UsageNode implElement) {
        if (this.tooFewRepetitions(version, implElement)) {
            this.elementErrors.add(new UsageError(implElement, EDIStreamValidationError.IMPLEMENTATION_TOO_FEW_REPETITIONS));
        }
    }

    boolean validateImplUnusedElementBlank(UsageNode node, UsageNode implNode, boolean valueReceived) {
        if (this.isImplUnusedElementPresent(implNode, valueReceived)) {
            this.elementErrors.add(new UsageError(node, EDIStreamValidationError.IMPLEMENTATION_UNUSED_DATA_ELEMENT_PRESENT));
            return false;
        }
        return true;
    }

    void validateDataElementRequirement(String version, UsageNode element, UsageNode implElement, CharSequence value, StaEDIStreamLocation position) {
        if (!UsageNode.hasMinimumUsage(version, element) || !UsageNode.hasMinimumUsage(version, implElement)) {
            this.elementErrors.add(new UsageError(element, EDIStreamValidationError.REQUIRED_DATA_ELEMENT_MISSING));
        } else if (this.isPendingDiscrimination()) {
            this.revalidationQueue.add(new RevalidationNode(this.element, this.implElement, value, position));
        }
    }

    boolean tooFewRepetitions(String version, UsageNode node) {
        if (!UsageNode.hasMinimumUsage(version, node)) {
            return node.getLink().getMinOccurs(version) > 1;
        }
        return false;
    }

    int getCurrentIndex(Location location, boolean isComposite) {
        int componentPosition;
        int index = isComposite ? ((componentPosition = location.getComponentPosition()) < 1 ? 1 : componentPosition) : location.getElementPosition();
        return index;
    }

    static class RevalidationNode {
        final UsageNode standard;
        final UsageNode impl;
        final CharBuffer data;
        final StaEDIStreamLocation location;

        public RevalidationNode(UsageNode standard, UsageNode impl, CharSequence data, StaEDIStreamLocation location) {
            this.standard = standard;
            this.impl = impl;
            this.data = CharBuffer.allocate(data.length());
            this.data.append(data);
            this.data.flip();
            this.location = location.copy();
        }
    }

    static class UsageCursor {
        UsageNode standard;
        UsageNode impl;

        UsageCursor() {
        }

        boolean hasNextSibling() {
            return this.standard.getNextSibling() != null;
        }

        void next(UsageNode nextImpl) {
            this.standard = this.standard.getNextSibling();
            if (nextImpl != null) {
                this.impl = nextImpl;
            }
        }

        void nagivateUp(int limit) {
            this.standard = UsageNode.getParent(this.standard);
            if (this.impl != null && this.impl.getDepth() > limit) {
                this.impl = UsageNode.getParent(this.impl);
            }
        }

        void reset(UsageNode root, UsageNode implRoot) {
            this.standard = UsageNode.getFirstChild(root);
            this.impl = UsageNode.getFirstChild(implRoot);
        }

        UsageCursor copy() {
            UsageCursor copy = new UsageCursor();
            copy.standard = this.standard;
            copy.impl = this.impl;
            return copy;
        }
    }
}

