/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.validation.ElementValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.List;

class NumericValidator
extends ElementValidator {
    private static final NumericValidator singleton = new NumericValidator();

    protected NumericValidator() {
    }

    static NumericValidator getInstance() {
        return singleton;
    }

    @Override
    void validate(Dialect dialect, EDISimpleType element, CharSequence value, List<EDIStreamValidationError> errors) {
        int length = this.validate(dialect, value);
        NumericValidator.validateLength(dialect, element, Math.abs(length), errors);
        if (length < 0) {
            errors.add(EDIStreamValidationError.INVALID_CHARACTER_DATA);
        }
    }

    @Override
    void format(Dialect dialect, EDISimpleType element, CharSequence value, StringBuilder result) {
        int length = this.validate(dialect, value);
        long min = element.getMinLength();
        for (long i = (long)length; i < min; ++i) {
            result.append('0');
        }
        result.append(value);
    }

    int validate(Dialect dialect, CharSequence value) {
        int length = value.length();
        boolean invalid = false;
        int m = length;
        block4: for (int i = 0; i < m; ++i) {
            switch (value.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block4;
                }
                case '-': {
                    --length;
                    if (i <= 0) continue block4;
                    invalid = true;
                    continue block4;
                }
                default: {
                    invalid = true;
                }
            }
        }
        return invalid ? -length : length;
    }
}

